/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Asdf
extends AbstractRepositoryPackager<Asdf> {
    public static final String TYPE = "asdf";
    public static final String SKIP_ASDF = "skipAsdf";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final AsdfRepository repository = new AsdfRepository();
    private String toolCheck;

    public Asdf() {
        super(TYPE);
    }

    @Override
    public void merge(Asdf source) {
        this.freezeCheck();
        super.merge(source);
        this.toolCheck = this.merge(this.toolCheck, source.toolCheck);
        this.setRepository(source.repository);
    }

    public String getToolCheck() {
        return this.toolCheck;
    }

    public void setToolCheck(String toolCheck) {
        this.freezeCheck();
        this.toolCheck = toolCheck;
    }

    public AsdfRepository getRepository() {
        return this.repository;
    }

    public void setRepository(AsdfRepository repository) {
        this.repository.merge(repository);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("toolcheck", this.toolCheck);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isMac((String)platform) || PlatformUtils.isLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return Collections.unmodifiableSet(SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet()));
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_ASDF));
    }

    static {
        Set extensions = CollectionUtils.setOf((Object[])new String[]{FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }

    public static class AsdfRepository
    extends AbstractRepositoryTap<AsdfRepository> {
        public AsdfRepository() {
            super(Asdf.TYPE, Asdf.TYPE);
        }
    }
}

