/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.AbstractModelObject;
import org.jreleaser.model.Activatable;
import org.jreleaser.model.Active;
import org.jreleaser.model.Announcer;
import org.jreleaser.model.Article;
import org.jreleaser.model.Discord;
import org.jreleaser.model.Discussions;
import org.jreleaser.model.Domain;
import org.jreleaser.model.Gitter;
import org.jreleaser.model.GoogleChat;
import org.jreleaser.model.Mail;
import org.jreleaser.model.Mastodon;
import org.jreleaser.model.Mattermost;
import org.jreleaser.model.Project;
import org.jreleaser.model.SdkmanAnnouncer;
import org.jreleaser.model.Slack;
import org.jreleaser.model.Teams;
import org.jreleaser.model.Telegram;
import org.jreleaser.model.Twitter;
import org.jreleaser.model.Webhook;
import org.jreleaser.model.Webhooks;
import org.jreleaser.model.Zulip;
import org.jreleaser.util.Env;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserOutput;
import org.jreleaser.util.StringUtils;

public class Announce
extends AbstractModelObject<Announce>
implements Domain,
Activatable {
    private final Article article = new Article();
    private final Discord discord = new Discord();
    private final Discussions discussions = new Discussions();
    private final Gitter gitter = new Gitter();
    private final GoogleChat googleChat = new GoogleChat();
    private final Mail mail = new Mail();
    private final Mastodon mastodon = new Mastodon();
    private final Mattermost mattermost = new Mattermost();
    private final SdkmanAnnouncer sdkman = new SdkmanAnnouncer();
    private final Slack slack = new Slack();
    private final Teams teams = new Teams();
    private final Telegram telegram = new Telegram();
    private final Twitter twitter = new Twitter();
    private final Webhooks webhooks = new Webhooks();
    private final Zulip zulip = new Zulip();
    private Active active;
    @JsonIgnore
    private boolean enabled = true;

    @Override
    public void freeze() {
        super.freeze();
        this.article.freeze();
        this.discord.freeze();
        this.discussions.freeze();
        this.gitter.freeze();
        this.googleChat.freeze();
        this.mail.freeze();
        this.mastodon.freeze();
        this.mattermost.freeze();
        this.sdkman.freeze();
        this.slack.freeze();
        this.teams.freeze();
        this.telegram.freeze();
        this.twitter.freeze();
        this.webhooks.freeze();
        this.zulip.freeze();
    }

    @Override
    public void merge(Announce announce) {
        this.freezeCheck();
        this.active = this.merge(this.active, announce.active);
        this.enabled = this.merge(this.enabled, announce.enabled);
        this.setArticle(announce.article);
        this.setDiscord(announce.discord);
        this.setDiscussions(announce.discussions);
        this.setGitter(announce.gitter);
        this.setGoogleChat(announce.googleChat);
        this.setMail(announce.mail);
        this.setMastodon(announce.mastodon);
        this.setMattermost(announce.mattermost);
        this.setSdkman(announce.sdkman);
        this.setSlack(announce.slack);
        this.setTeams(announce.teams);
        this.setTelegram(announce.telegram);
        this.setTwitter(announce.twitter);
        this.setZulip(announce.zulip);
        this.setConfiguredWebhooks(announce.webhooks);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && this.active != null;
    }

    @Deprecated
    public void setEnabled(Boolean enabled) {
        JReleaserOutput.nag((String)"announce.enabled is deprecated since 1.1.0 and will be removed in 2.0.0");
        this.freezeCheck();
        if (null != enabled) {
            this.active = enabled != false ? Active.ALWAYS : Active.NEVER;
        }
    }

    @Override
    public void disable() {
        this.active = Active.NEVER;
        this.enabled = false;
    }

    public boolean resolveEnabled(Project project) {
        if (null == this.active) {
            this.setActive(Env.resolveOrDefault((String)"announce.active", (String)"", (String)"ALWAYS"));
        }
        this.enabled = this.active.check(project);
        return this.enabled;
    }

    @Override
    public Active getActive() {
        return this.active;
    }

    @Override
    public void setActive(Active active) {
        this.freezeCheck();
        this.active = active;
    }

    @Override
    public void setActive(String str) {
        this.setActive(Active.of(str));
    }

    @Override
    public boolean isActiveSet() {
        return this.active != null;
    }

    public Article getArticle() {
        return this.article;
    }

    public void setArticle(Article article) {
        this.article.merge(article);
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public void setDiscord(Discord discord) {
        this.discord.merge(discord);
    }

    public Discussions getDiscussions() {
        return this.discussions;
    }

    public void setDiscussions(Discussions discussions) {
        this.discussions.merge(discussions);
    }

    public Gitter getGitter() {
        return this.gitter;
    }

    public void setGitter(Gitter gitter) {
        this.gitter.merge(gitter);
    }

    public GoogleChat getGoogleChat() {
        return this.googleChat;
    }

    public void setGoogleChat(GoogleChat googleChat) {
        this.googleChat.merge(googleChat);
    }

    public Mail getMail() {
        return this.mail;
    }

    public void setMail(Mail mail) {
        this.mail.merge(mail);
    }

    public Mastodon getMastodon() {
        return this.mastodon;
    }

    public void setMastodon(Mastodon mastodon) {
        this.mastodon.merge(mastodon);
    }

    public Mattermost getMattermost() {
        return this.mattermost;
    }

    public void setMattermost(Mattermost mattermost) {
        this.mattermost.merge(mattermost);
    }

    public SdkmanAnnouncer getSdkman() {
        return this.sdkman;
    }

    public void setSdkman(SdkmanAnnouncer sdkman) {
        this.sdkman.merge(sdkman);
    }

    public Slack getSlack() {
        return this.slack;
    }

    public void setSlack(Slack slack) {
        this.slack.merge(slack);
    }

    public Teams getTeams() {
        return this.teams;
    }

    public void setTeams(Teams teams) {
        this.teams.merge(teams);
    }

    public Telegram getTelegram() {
        return this.telegram;
    }

    public void setTelegram(Telegram telegram) {
        this.telegram.merge(telegram);
    }

    public Twitter getTwitter() {
        return this.twitter;
    }

    public void setTwitter(Twitter twitter) {
        this.twitter.merge(twitter);
    }

    public Webhooks getConfiguredWebhooks() {
        return this.webhooks;
    }

    void setConfiguredWebhooks(Webhooks webhooks) {
        this.webhooks.merge(webhooks);
    }

    public Map<String, Webhook> getWebhooks() {
        return this.webhooks.getWebhooks();
    }

    public void setWebhooks(Map<String, Webhook> webhooks) {
        this.webhooks.setWebhooks(webhooks);
    }

    public void addWebhook(Webhook webhook) {
        this.webhooks.addWebhook(webhook);
    }

    public Zulip getZulip() {
        return this.zulip;
    }

    public void setZulip(Zulip zulip) {
        this.zulip.merge(zulip);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("enabled", this.isEnabled());
        map.put("active", (Object)this.active);
        map.putAll(this.article.asMap(full));
        map.putAll(this.discord.asMap(full));
        map.putAll(this.discussions.asMap(full));
        map.putAll(this.gitter.asMap(full));
        map.putAll(this.googleChat.asMap(full));
        map.putAll(this.mail.asMap(full));
        map.putAll(this.mastodon.asMap(full));
        map.putAll(this.mattermost.asMap(full));
        map.putAll(this.sdkman.asMap(full));
        map.putAll(this.slack.asMap(full));
        map.putAll(this.teams.asMap(full));
        map.putAll(this.telegram.asMap(full));
        map.putAll(this.twitter.asMap(full));
        map.putAll(this.webhooks.asMap(full));
        map.putAll(this.zulip.asMap(full));
        return map;
    }

    public <A extends Announcer> A findAnnouncer(String name) {
        if (StringUtils.isBlank((String)name)) {
            throw new JReleaserException("Announcer name must not be blank");
        }
        return this.resolveAnnouncer(name);
    }

    public <A extends Announcer> A getAnnouncer(String name) {
        A announcer = this.findAnnouncer(name);
        if (null != announcer) {
            return announcer;
        }
        throw new JReleaserException(RB.$((String)"ERROR_announcer_not_configured", (Object[])new Object[]{name}));
    }

    private <A extends Announcer> A resolveAnnouncer(String name) {
        switch (name.toLowerCase(Locale.ENGLISH).trim()) {
            case "article": {
                return (A)this.getArticle();
            }
            case "discord": {
                return (A)this.getDiscord();
            }
            case "discussions": {
                return (A)this.getDiscussions();
            }
            case "gitter": {
                return (A)this.getGitter();
            }
            case "googlechat": {
                return (A)this.getGoogleChat();
            }
            case "mail": {
                return (A)this.getMail();
            }
            case "mastodon": {
                return (A)this.getMastodon();
            }
            case "mattermost": {
                return (A)this.getMattermost();
            }
            case "sdkman": {
                return (A)this.getSdkman();
            }
            case "slack": {
                return (A)this.getSlack();
            }
            case "teams": {
                return (A)this.getTeams();
            }
            case "telegram": {
                return (A)this.getTelegram();
            }
            case "twitter": {
                return (A)this.getTwitter();
            }
            case "webhooks": {
                return (A)this.getConfiguredWebhooks();
            }
            case "zulip": {
                return (A)this.getZulip();
            }
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_announcer", (Object[])new Object[]{name}));
    }

    public static Set<String> supportedAnnouncers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add("article");
        set.add("discord");
        set.add("discussions");
        set.add("gitter");
        set.add("googlechat");
        set.add("mail");
        set.add("mastodon");
        set.add("mattermost");
        set.add("sdkman");
        set.add("slack");
        set.add("teams");
        set.add("telegram");
        set.add("twitter");
        set.add("webhooks");
        set.add("zulip");
        return Collections.unmodifiableSet(set);
    }
}

