/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.command.Command;
import org.jreleaser.util.command.CommandException;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessInitException;

public class CommandExecutor {
    private final JReleaserLogger logger;
    private final boolean quiet;
    private final Map<String, String> environment = new LinkedHashMap<String, String>();

    public CommandExecutor(JReleaserLogger logger) {
        this(logger, false);
    }

    public CommandExecutor(JReleaserLogger logger, boolean quiet) {
        this.logger = logger;
        this.quiet = quiet;
    }

    public CommandExecutor environment(Map<String, String> env) {
        this.environment.putAll(env);
        return this;
    }

    public CommandExecutor environment(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public int executeCommand(ProcessExecutor processExecutor) throws CommandException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayOutputStream err = new ByteArrayOutputStream();
            int exitValue = processExecutor.redirectOutput((OutputStream)out).redirectError((OutputStream)err).execute().getExitValue();
            if (!this.quiet) {
                this.info(out);
                this.error(err);
            }
            return exitValue;
        }
        catch (ProcessInitException e) {
            throw new CommandException(RB.$("ERROR_unexpected_error", new Object[0]), e.getCause());
        }
        catch (Exception e) {
            throw new CommandException(RB.$("ERROR_unexpected_error", new Object[0]), e);
        }
    }

    public int executeCommand(Command command) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command));
    }

    public int executeCommand(Path directory, Command command) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).directory(directory.toFile()));
    }

    public int executeCommandCapturing(Command command, OutputStream out) throws CommandException {
        return this.executeCommandCapturing(this.createProcessExecutor(command), out);
    }

    public int executeCommandCapturing(Command command, OutputStream out, OutputStream err) throws CommandException {
        return this.executeCommandCapturing(this.createProcessExecutor(command), out, err);
    }

    public int executeCommandCapturing(Path directory, Command command, OutputStream out) throws CommandException {
        return this.executeCommandCapturing(this.createProcessExecutor(command).directory(directory.toFile()), out);
    }

    public int executeCommandWithInput(Command command, InputStream in) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).redirectInput(in));
    }

    public int executeCommandWithInputCapturing(Command command, InputStream in, OutputStream out) throws CommandException {
        return this.executeCommandCapturing(this.createProcessExecutor(command).redirectInput(in), out);
    }

    public int executeCommandWithInput(Path directory, Command command, InputStream in) throws CommandException {
        return this.executeCommand(this.createProcessExecutor(command).redirectInput(in).directory(directory.toFile()));
    }

    public int executeCommandWithInputCapturing(Path directory, Command command, InputStream in, OutputStream out) throws CommandException {
        return this.executeCommandCapturing(this.createProcessExecutor(command).directory(directory.toFile()).redirectInput(in), out);
    }

    private ProcessExecutor createProcessExecutor(Command command) throws CommandException {
        try {
            return new ProcessExecutor(command.asCommandLine()).environment(this.environment);
        }
        catch (IOException e) {
            throw new CommandException(RB.$("ERROR_unexpected_error", new Object[0]), e);
        }
    }

    private int executeCommandCapturing(ProcessExecutor processor, OutputStream out) throws CommandException {
        return this.executeCommandCapturing(processor, out, null);
    }

    private int executeCommandCapturing(ProcessExecutor processor, OutputStream out, OutputStream err) throws CommandException {
        try {
            ByteArrayOutputStream errLocal = new ByteArrayOutputStream();
            int exitValue = processor.redirectOutput(out).redirectError(err).execute().getExitValue();
            if (!this.quiet) {
                this.error(errLocal);
            }
            if (err != null) {
                err.write(errLocal.toByteArray());
            }
            return exitValue;
        }
        catch (ProcessInitException e) {
            throw new CommandException(RB.$("ERROR_unexpected_error", new Object[0]), e.getCause());
        }
        catch (Exception e) {
            throw new CommandException(RB.$("ERROR_unexpected_error", new Object[0]), e);
        }
    }

    private void info(ByteArrayOutputStream out) {
        this.log(out, this.logger::info);
    }

    private void error(ByteArrayOutputStream err) {
        this.log(err, this.logger::error);
    }

    private void log(ByteArrayOutputStream stream, Consumer<? super String> consumer) {
        String str = stream.toString();
        if (StringUtils.isBlank(str)) {
            return;
        }
        Arrays.stream(str.split(System.lineSeparator())).forEach(consumer);
    }
}

