/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.signing;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Signing;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.deploy.maven.MavenDeployer;
import org.jreleaser.model.internal.signing.Signing;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.DefaultVersions;
import org.jreleaser.util.Errors;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class SigningValidator {
    private SigningValidator() {
    }

    public static void validateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            errors = new Errors();
        }
        context.getLogger().debug("signing");
        Signing signing = context.getModel().getSigning();
        Validator.resolveActivatable(context, (Activatable)signing, "signing", "NEVER");
        if (!signing.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!signing.isArmoredSet()) {
            signing.setArmored(true);
        }
        boolean cosign = signing.resolveMode() == Signing.Mode.COSIGN;
        signing.setPassphrase(Validator.checkProperty(context, cosign ? "COSIGN_PASSWORD" : "GPG_PASSPHRASE", "signing.passphrase", signing.getPassphrase(), errors, context.isDryrun()));
        if (signing.resolveMode() == Signing.Mode.COMMAND) {
            signing.getCommand().setExecutable(Validator.checkProperty(context, "GPG_EXECUTABLE", "signing.command.executable", signing.getCommand().getExecutable(), "gpg" + (PlatformUtils.isWindows() ? ".exe" : "")));
            signing.getCommand().setHomeDir(Validator.checkProperty(context, "GPG_HOMEDIR", "signing.command.homeDir", signing.getCommand().getHomeDir(), ""));
            signing.getCommand().setKeyName(Validator.checkProperty(context, "GPG_KEYNAME", "signing.command.keyName", signing.getCommand().getKeyName(), ""));
            if (signing.isVerify()) {
                signing.getCommand().setPublicKeyring(Validator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.command.publicKeyRing", signing.getCommand().getPublicKeyring(), ""));
            }
        } else if (signing.resolveMode() == Signing.Mode.COSIGN) {
            if (StringUtils.isBlank((String)signing.getCosign().getVersion())) {
                signing.getCosign().setVersion(DefaultVersions.getInstance().getCosignVersion());
            }
            signing.getCosign().setPrivateKeyFile(Validator.checkProperty(context, "COSIGN_PRIVATE_KEY", "signing.cosign.privateKeyFile", signing.getCosign().getPrivateKeyFile(), ""));
            signing.getCosign().setPublicKeyFile(Validator.checkProperty(context, "COSIGN_PUBLIC_KEY", "signing.cosign.publicKeyFile", signing.getCosign().getPublicKeyFile(), ""));
        } else {
            if (signing.isVerify()) {
                signing.setPublicKey(Validator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.publicKey", signing.getPublicKey(), errors));
            }
            signing.setSecretKey(Validator.checkProperty(context, "GPG_SECRET_KEY", "signing.secretKey", signing.getSecretKey(), errors));
        }
    }

    public static void postValidateSigning(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        boolean checkSign;
        Signing signing = context.getModel().getSigning();
        if (!signing.isEnabled()) {
            return;
        }
        boolean bl = checkSign = mode == JReleaserContext.Mode.DEPLOY && context.getModel().getDeploy().getMaven().getActiveDeployers().stream().map(MavenDeployer::isSign).filter(b -> b).findAny().orElseGet(() -> false) != false;
        if (!checkSign) {
            return;
        }
        context.getLogger().debug("signing");
        if (signing.resolveMode() == Signing.Mode.COMMAND) {
            if (signing.isVerify()) {
                signing.getCommand().setPublicKeyring(Validator.checkProperty(context, "GPG_PUBLIC_KEYRING", "signing.command.publicKeyRing", signing.getCommand().getPublicKeyring(), ""));
            }
        } else if (signing.resolveMode() != Signing.Mode.COSIGN && signing.isVerify()) {
            signing.setPublicKey(Validator.checkProperty(context, "GPG_PUBLIC_KEY", "signing.publicKey", signing.getPublicKey(), errors));
        }
    }
}

