/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.catalog;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jreleaser.bundle.RB;
import org.jreleaser.engine.catalog.CatalogerSupport;
import org.jreleaser.engine.deploy.maven.ArtifactDeployers;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.api.JReleaserCommand;
import org.jreleaser.model.api.hooks.ExecutionEvent;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.JReleaserSupport;
import org.jreleaser.model.internal.catalog.GithubCataloger;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.deploy.maven.Maven;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.util.Artifacts;
import org.jreleaser.model.spi.catalog.CatalogProcessingException;
import org.jreleaser.model.spi.deploy.maven.Deployable;
import org.jreleaser.model.spi.deploy.maven.MavenDeployer;
import org.jreleaser.util.StringUtils;

public final class Github {
    private static final String GLOB_PREFIX = "glob:";
    private static final String REGEX_PREFIX = "regex:";

    private Github() {
    }

    public static void catalog(JReleaserContext context) {
        context.getLogger().increaseIndent();
        context.getLogger().setPrefix("github");
        GithubCataloger github = context.getModel().getCatalog().getGithub();
        if (!github.isEnabled()) {
            context.getLogger().info(RB.$((String)"catalogers.not.enabled", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        try {
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.before((String)JReleaserCommand.CATALOG.toStep()), context, github);
            Github.attestation(context, github);
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.success((String)JReleaserCommand.CATALOG.toStep()), context, github);
        }
        catch (CatalogProcessingException e) {
            CatalogerSupport.fireCatalogEvent(ExecutionEvent.failure((String)JReleaserCommand.CATALOG.toStep(), (Throwable)e), context, github);
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
        }
    }

    private static void attestation(JReleaserContext context, GithubCataloger github) throws CatalogProcessingException {
        LinkedHashSet<PathMatcher> includes = new LinkedHashSet<PathMatcher>();
        LinkedHashSet<PathMatcher> excludes = new LinkedHashSet<PathMatcher>();
        FileSystem fileSystem = FileSystems.getDefault();
        for (String s : github.getIncludes()) {
            includes.add(fileSystem.getPathMatcher(Github.normalize(s)));
        }
        for (String s : github.getExcludes()) {
            excludes.add(fileSystem.getPathMatcher(Github.normalize(s)));
        }
        if (includes.isEmpty()) {
            includes.add(fileSystem.getPathMatcher("glob:**/*"));
        }
        ArrayList<String> subjects = new ArrayList<String>();
        String attestationName = github.getResolvedAttestationName(context);
        context.getLogger().info(attestationName);
        if (github.isFiles()) {
            for (Artifact artifact : Artifacts.resolveFiles((JReleaserContext)context)) {
                if (!artifact.isActiveAndSelected() || artifact.extraPropertyIsTrue("skipGithub") || artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                Github.addSubject(context, subjects, artifact, includes, excludes);
            }
        }
        if (github.isArtifacts()) {
            for (Distribution distribution : context.getModel().getActiveDistributions()) {
                for (Artifact artifact : distribution.getArtifacts()) {
                    if (!artifact.isActiveAndSelected()) continue;
                    artifact.getEffectivePath(context, distribution);
                    if (artifact.isOptional(context) && !artifact.resolvedPathExists()) continue;
                    Github.addSubject(context, subjects, artifact, includes, excludes);
                }
            }
        }
        if (github.isDeployables()) {
            for (Deployable deployable : Github.collectDeployables(context)) {
                if (!deployable.isPom() && !deployable.isArtifact()) continue;
                Artifact artifact = Artifact.of((Path)deployable.getLocalPath());
                Github.addSubject(context, subjects, artifact, includes, excludes);
            }
        }
        if (subjects.isEmpty()) {
            context.getLogger().info(RB.$((String)"catalog.no.artifacts", (Object[])new Object[0]));
            context.getLogger().decreaseIndent();
            context.getLogger().restorePrefix();
            return;
        }
        String newContent = String.join((CharSequence)System.lineSeparator(), subjects);
        Path attestationFile = context.getCatalogsDirectory().resolve(github.getType()).resolve(attestationName);
        try {
            String oldContent;
            if (Files.exists(attestationFile, new LinkOption[0]) && newContent.equals(oldContent = new String(Files.readAllBytes(attestationFile), StandardCharsets.UTF_8))) {
                context.getLogger().info(RB.$((String)"catalog.github.not.changed", (Object[])new Object[0]));
                context.getLogger().restorePrefix();
                context.getLogger().decreaseIndent();
                return;
            }
        }
        catch (IOException oldContent) {
            // empty catch block
        }
        try {
            if (StringUtils.isNotBlank((String)newContent)) {
                Files.createDirectories(attestationFile.getParent(), new FileAttribute[0]);
                Files.write(attestationFile, newContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            } else {
                Files.deleteIfExists(attestationFile);
            }
        }
        catch (IOException e) {
            throw new JReleaserException(RB.$((String)"ERROR_unexpected_error_writing_file", (Object[])new Object[]{attestationFile.toAbsolutePath()}), (Throwable)e);
        }
    }

    private static String normalize(String pattern) {
        if (pattern.startsWith(GLOB_PREFIX) || pattern.startsWith(REGEX_PREFIX)) {
            return pattern;
        }
        return GLOB_PREFIX + pattern;
    }

    private static void addSubject(JReleaserContext context, List<String> subjects, Artifact artifact, Set<PathMatcher> includes, Set<PathMatcher> excludes) {
        Path path = artifact.getEffectivePath(context);
        String artifactFileName = path.toString();
        if (includes.stream().anyMatch(matcher -> matcher.matches(path)) && excludes.stream().noneMatch(matcher -> matcher.matches(path))) {
            subjects.add(artifactFileName);
            context.getLogger().debug("- " + artifact.getEffectivePath(context).getFileName());
        }
    }

    private static Set<Deployable> collectDeployables(JReleaserContext context) {
        TreeSet<String> stagingRepositories = new TreeSet<String>();
        TreeSet<Deployable> deployables = new TreeSet<Deployable>();
        Maven maven = context.getModel().getDeploy().getMaven();
        if (!context.getIncludedDeployerTypes().isEmpty()) {
            for (String deployerType : context.getIncludedDeployerTypes()) {
                if (!JReleaserSupport.supportedMavenDeployers().contains(deployerType)) continue;
                Map deployers = maven.findMavenDeployersByType(deployerType);
                if (deployers.isEmpty()) {
                    return deployables;
                }
                if (!context.getIncludedDeployerNames().isEmpty()) {
                    for (String deployerName : context.getIncludedDeployerNames()) {
                        org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer2;
                        if (!deployers.containsKey(deployerName) || !(deployer2 = (org.jreleaser.model.internal.deploy.maven.MavenDeployer)deployers.get(deployerName)).isEnabled()) continue;
                        Github.handleDeployer(context, stagingRepositories, deployables, deployer2);
                    }
                    continue;
                }
                for (org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer3 : deployers.values()) {
                    Github.handleDeployer(context, stagingRepositories, deployables, deployer3);
                }
            }
        } else if (!context.getIncludedDeployerNames().isEmpty()) {
            for (String deployerName : context.getIncludedDeployerNames()) {
                maven.findAllActiveMavenDeployers().stream().filter(a -> deployerName.equals(a.getName())).forEach(deployer -> Github.handleDeployer(context, stagingRepositories, deployables, deployer));
            }
        } else {
            for (org.jreleaser.model.internal.deploy.maven.MavenDeployer deployer4 : maven.findAllActiveMavenDeployers()) {
                if (context.getExcludedDeployerTypes().contains(deployer4.getType()) || context.getExcludedDeployerNames().contains(deployer4.getName())) continue;
                Github.handleDeployer(context, stagingRepositories, deployables, deployer4);
            }
        }
        return deployables;
    }

    private static void handleDeployer(JReleaserContext context, Set<String> stagingRepositories, Set<Deployable> deployables, org.jreleaser.model.internal.deploy.maven.MavenDeployer<?> deployer) {
        MavenDeployer artifactMavenDeployer = ArtifactDeployers.findMavenDeployer(context, deployer);
        for (String stagingRepository : deployer.getStagingRepositories()) {
            if (stagingRepositories.contains(stagingRepository)) continue;
            artifactMavenDeployer.collectDeployables(deployables, stagingRepository);
        }
    }
}

