/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.discourse;

import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.announce.AnnounceException;
import org.jreleaser.model.spi.announce.Announcer;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.sdk.discourse.DiscourseException;
import org.jreleaser.sdk.discourse.DiscourseSdk;
import org.jreleaser.util.StringUtils;

public class DiscourseAnnouncer
implements Announcer<org.jreleaser.model.api.announce.DiscourseAnnouncer> {
    private final JReleaserContext context;
    private final org.jreleaser.model.internal.announce.DiscourseAnnouncer discourse;

    public DiscourseAnnouncer(JReleaserContext context) {
        this.context = context;
        this.discourse = context.getModel().getAnnounce().getDiscourse();
    }

    public org.jreleaser.model.api.announce.DiscourseAnnouncer getAnnouncer() {
        return this.discourse.asImmutable();
    }

    public String getName() {
        return "discourse";
    }

    public boolean isEnabled() {
        return this.discourse.isEnabled();
    }

    public void announce() throws AnnounceException {
        String message = "";
        if (StringUtils.isNotBlank((String)this.discourse.getMessage())) {
            message = this.discourse.getResolvedMessage(this.context);
        } else {
            TemplateContext props = new TemplateContext();
            this.context.getModel().getRelease().getReleaser().fillProps(props, this.context.getModel());
            message = this.discourse.getResolvedMessageTemplate(this.context, props);
        }
        String title = this.discourse.getResolvedTitle(this.context);
        String categoryName = this.discourse.getCategoryName();
        this.context.getLogger().info("title: {}", new Object[]{title});
        this.context.getLogger().debug("message: {}", new Object[]{message});
        this.context.getLogger().debug("categoryName: {}", new Object[]{categoryName});
        try {
            DiscourseSdk sdk = DiscourseSdk.builder(this.context.asImmutable()).host(this.discourse.getHost()).apiKey(this.discourse.getApiKey()).userName(this.discourse.getUsername()).connectTimeout(this.discourse.getConnectTimeout()).readTimeout(this.discourse.getReadTimeout()).dryrun(this.context.isDryrun()).build();
            sdk.createPost(title, message, categoryName);
        }
        catch (DiscourseException e) {
            throw new AnnounceException((Throwable)e);
        }
    }
}

