/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Collection;
import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.GiteaUploader;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class GiteaUploaderValidator {
    private GiteaUploaderValidator() {
    }

    public static void validateGiteaUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, GiteaUploader> gitea = context.getModel().getUpload().getGitea();
        if (!gitea.isEmpty()) {
            context.getLogger().debug("upload.gitea");
        }
        for (Map.Entry<String, GiteaUploader> e : gitea.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            GiteaUploaderValidator.validateGiteaUploader(context, e.getValue(), errors);
        }
    }

    private static void validateGiteaUploader(JReleaserContext context, GiteaUploader uploader, Errors errors) {
        context.getLogger().debug("upload.gitea.{}", new Object[]{uploader.getName()});
        Validator.resolveActivatable(context, (Activatable)uploader, CollectionUtils.listOf((Object[])new String[]{"upload.gitea." + uploader.getName(), "upload.gitea"}), "NEVER");
        if (!uploader.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(uploader.isArtifacts() || uploader.isFiles() || uploader.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{uploader.getType(), uploader.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            uploader.disable();
            return;
        }
        String baseKey1 = "upload.gitea." + uploader.getName();
        String baseKey2 = "upload.gitea";
        String baseKey3 = "gitea." + uploader.getName();
        String baseKey4 = "gitea";
        uploader.setToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".token", baseKey2 + ".token", baseKey3 + ".token", baseKey4 + ".token"}), baseKey1 + ".token", uploader.getToken(), errors, context.isDryrun()));
        uploader.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + ".host", baseKey2 + ".host", baseKey3 + ".host", baseKey4 + ".host"}), baseKey1 + ".host", uploader.getHost(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)uploader.getPackageName())) {
            uploader.setPackageName(uploader.getName());
        }
        if (StringUtils.isBlank((String)uploader.getPackageVersion())) {
            uploader.setPackageVersion("{{projectVersion}}");
        }
        if (StringUtils.isBlank((String)uploader.getOwner())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{baseKey1 + ".owner"}));
        }
        Validator.validateTimeout(uploader);
    }
}

