/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.distributions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.api.distributions.Distribution;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractArtifact;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.model.internal.common.Java;
import org.jreleaser.model.internal.packagers.Packager;
import org.jreleaser.model.internal.project.Project;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.model.internal.validation.packagers.AppImagePackagerValidator;
import org.jreleaser.model.internal.validation.packagers.AsdfPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.BrewPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.ChocolateyPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.DockerPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.FlatpakPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.GofishPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.JbangPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.JibPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.MacportsPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.ScoopPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.SdkmanPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.SnapPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.SpecPackagerValidator;
import org.jreleaser.model.internal.validation.packagers.WingetPackagerValidator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class DistributionsValidator {
    private DistributionsValidator() {
    }

    public static void validateDistributions(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, org.jreleaser.model.internal.distributions.Distribution> distributions = context.getModel().getDistributions();
        if (!distributions.isEmpty()) {
            context.getLogger().debug("distributions");
        }
        for (Map.Entry<String, org.jreleaser.model.internal.distributions.Distribution> e : distributions.entrySet()) {
            org.jreleaser.model.internal.distributions.Distribution distribution = e.getValue();
            if (StringUtils.isBlank((String)distribution.getName())) {
                distribution.setName(e.getKey());
            }
            if (context.isDistributionIncluded(distribution)) {
                if (!mode.validateConfig()) continue;
                DistributionsValidator.validateDistribution(context, distribution, errors);
                continue;
            }
            distribution.setActive(Active.NEVER);
            distribution.resolveEnabled(context.getModel().getProject());
        }
        if (mode.validateConfig()) {
            BrewPackagerValidator.postValidateBrew(context, errors);
            JbangPackagerValidator.postValidateJBang(context, errors);
            SdkmanPackagerValidator.postValidateSdkman(context, errors);
        }
    }

    private static void validateDistribution(JReleaserContext context, org.jreleaser.model.internal.distributions.Distribution distribution, Errors errors) {
        context.getLogger().debug("distribution.{}", new Object[]{distribution.getName()});
        Validator.resolveActivatable(context, (Activatable)distribution, CollectionUtils.listOf((Object[])new String[]{"distributions." + distribution.getName(), "distributions"}), "ALWAYS");
        if (!distribution.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!DistributionsValidator.selectArtifactsByPlatform(context, distribution)) {
            distribution.setActive(Active.NEVER);
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            errors.warning(RB.$((String)"WARNING.validation.distribution.no.artifacts", (Object[])new Object[]{distribution.getName()}));
            distribution.disable();
            return;
        }
        if (StringUtils.isBlank((String)distribution.getName())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution.name"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.error", (Object[])new Object[0]));
            distribution.disable();
            return;
        }
        if (null == distribution.getType()) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"distribution." + distribution.getName() + ".type"}));
            distribution.disable();
            return;
        }
        if (null == distribution.getStereotype()) {
            distribution.setStereotype(context.getModel().getProject().getStereotype());
        }
        if (StringUtils.isBlank((String)distribution.getExecutable().getName())) {
            distribution.getExecutable().setName(distribution.getName());
        }
        if (StringUtils.isBlank((String)distribution.getExecutable().getWindowsExtension())) {
            switch (distribution.getType()) {
                case BINARY: 
                case NATIVE_PACKAGE: 
                case FLAT_BINARY: {
                    distribution.getExecutable().setWindowsExtension("exe");
                    break;
                }
                default: {
                    distribution.getExecutable().setWindowsExtension("bat");
                }
            }
        }
        if (DistributionsValidator.isJavaDistribution(distribution)) {
            context.getLogger().debug("distribution.{}.java", new Object[]{distribution.getName()});
            if (!DistributionsValidator.validateJava(context, distribution, errors)) {
                return;
            }
        }
        if (!distribution.getJava().isEnabled() && DistributionsValidator.isJavaDistribution(distribution)) {
            errors.configuration(RB.$((String)"validation_distributions_java", (Object[])new Object[]{"distribution." + distribution.getName() + ".type", distribution.getType(), "distribution." + distribution.getName() + ".java", "project.java"}));
            return;
        }
        if (null == distribution.getArtifacts() || distribution.getArtifacts().isEmpty()) {
            errors.configuration(RB.$((String)"validation_is_empty", (Object[])new Object[]{"distribution." + distribution.getName() + ".artifacts"}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            distribution.disable();
            return;
        }
        ArrayList<String> tags = new ArrayList<String>();
        tags.addAll(context.getModel().getProject().getTags());
        tags.addAll(distribution.getTags());
        distribution.setTags(tags);
        int i = 0;
        for (Artifact artifact2 : distribution.getArtifacts()) {
            if (!artifact2.isActiveAndSelected()) continue;
            DistributionsValidator.validateArtifact(context, distribution, artifact2, i++, errors);
            if (!distribution.getExtraProperties().containsKey("skipReleaseSignatures") || artifact2.getExtraProperties().containsKey("skipReleaseSignatures")) continue;
            artifact2.getExtraProperties().put("skipReleaseSignatures", distribution.getExtraProperties().get("skipReleaseSignatures"));
        }
        Map<String, List<Artifact>> byPlatform = distribution.getArtifacts().stream().filter(AbstractArtifact::isActiveAndSelected).collect(Collectors.groupingBy(artifact -> StringUtils.isBlank((String)artifact.getPlatform()) ? "<nil>" : artifact.getPlatform()));
        byPlatform.forEach((p, artifacts) -> {
            String platform = "<nil>".equals(p) ? "no" : p;
            artifacts.stream().collect(Collectors.groupingBy(artifact -> FileType.getType((String)artifact.getPath()))).forEach((ext, matches) -> {
                if (matches.size() > 1) {
                    errors.configuration(RB.$((String)"validation_distributions_multiple", (Object[])new Object[]{"distribution." + distribution.getName(), platform, ext}));
                }
            });
        });
        AppImagePackagerValidator.validateAppImage(context, distribution, distribution.getAppImage(), errors);
        AsdfPackagerValidator.validateAsdf(context, distribution, distribution.getAsdf(), errors);
        BrewPackagerValidator.validateBrew(context, distribution, distribution.getBrew(), errors);
        ChocolateyPackagerValidator.validateChocolatey(context, distribution, distribution.getChocolatey(), errors);
        DockerPackagerValidator.validateDocker(context, distribution, distribution.getDocker(), errors);
        FlatpakPackagerValidator.validateFlatpak(context, distribution, distribution.getFlatpak(), errors);
        GofishPackagerValidator.validateGofish(context, distribution, distribution.getGofish(), errors);
        JbangPackagerValidator.validateJbang(context, distribution, distribution.getJbang(), errors);
        JibPackagerValidator.validateJib(context, distribution, distribution.getJib(), errors);
        MacportsPackagerValidator.validateMacports(context, distribution, distribution.getMacports(), errors);
        ScoopPackagerValidator.validateScoop(context, distribution, distribution.getScoop(), errors);
        SdkmanPackagerValidator.validateSdkman(context, distribution, distribution.getSdkman(), errors);
        SnapPackagerValidator.validateSnap(context, distribution, distribution.getSnap(), errors);
        SpecPackagerValidator.validateSpec(context, distribution, distribution.getSpec(), errors);
        WingetPackagerValidator.validateWinget(context, distribution, distribution.getWinget(), errors);
    }

    private static boolean selectArtifactsByPlatform(JReleaserContext context, org.jreleaser.model.internal.distributions.Distribution distribution) {
        boolean activeArtifacts = false;
        for (Artifact artifact : distribution.getArtifacts()) {
            if (!artifact.resolveActiveAndSelected(context)) continue;
            activeArtifacts = true;
        }
        return activeArtifacts;
    }

    private static boolean validateJava(JReleaserContext context, org.jreleaser.model.internal.distributions.Distribution distribution, Errors errors) {
        Project project = context.getModel().getProject();
        Java projectJava = project.getJava();
        Java distributionJava = distribution.getJava();
        if (!distributionJava.isEnabledSet() && projectJava.isSet()) {
            distributionJava.setEnabled(projectJava.isSet());
        }
        if (!distributionJava.isEnabledSet()) {
            distributionJava.setEnabled(distributionJava.isSet());
        }
        if (distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            distributionJava.setEnabled(false);
        }
        if (!distributionJava.isEnabled()) {
            return true;
        }
        if (StringUtils.isBlank((String)distributionJava.getArtifactId())) {
            distributionJava.setArtifactId(distribution.getName());
        }
        if (StringUtils.isBlank((String)distributionJava.getGroupId())) {
            distributionJava.setGroupId(projectJava.getGroupId());
        }
        if (StringUtils.isBlank((String)distributionJava.getVersion())) {
            distributionJava.setVersion(projectJava.getVersion());
        }
        if (StringUtils.isBlank((String)distributionJava.getMainModule())) {
            distributionJava.setMainModule(projectJava.getMainModule());
        }
        if (StringUtils.isBlank((String)distributionJava.getMainClass())) {
            distributionJava.setMainClass(projectJava.getMainClass());
        }
        if (distribution.getType() == Distribution.DistributionType.BINARY) {
            return true;
        }
        if (distributionJava.getOptions().isEmpty()) {
            distributionJava.setOptions(projectJava.getOptions());
        } else {
            distributionJava.addOptions(projectJava.getOptions());
        }
        distributionJava.getJvmOptions().merge(distributionJava.getOptions());
        distributionJava.getJvmOptions().merge(projectJava.getJvmOptions());
        distributionJava.getEnvironmentVariables().merge(projectJava.getEnvironmentVariables());
        boolean valid = true;
        if (StringUtils.isBlank((String)distributionJava.getGroupId())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"distribution." + distribution.getName() + ".java.groupId"}));
            valid = false;
        }
        if (!distributionJava.isMultiProjectSet()) {
            distributionJava.setMultiProject(projectJava.isMultiProject());
        }
        if (!DistributionsValidator.isJavaDistribution(distribution)) {
            errors.configuration(RB.$((String)"validation_distributions_java_types", (Object[])new Object[]{"distribution." + distribution.getName() + ".type", Distribution.JAVA_DISTRIBUTION_TYPES.stream().map(Enum::name).collect(Collectors.joining(", "))}));
            valid = false;
        }
        return valid;
    }

    private static void validateArtifact(JReleaserContext context, org.jreleaser.model.internal.distributions.Distribution distribution, Artifact artifact, int index, Errors errors) {
        if (null == artifact) {
            errors.configuration(RB.$((String)"validation_is_null", (Object[])new Object[]{"distribution." + distribution.getName() + ".artifact[" + index + "]"}));
            return;
        }
        if (StringUtils.isBlank((String)artifact.getPath())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{"distribution." + distribution.getName() + ".artifact[" + index + "].path"}));
        }
        if (StringUtils.isNotBlank((String)artifact.getPlatform()) && !PlatformUtils.isSupported((String)artifact.getPlatform().trim())) {
            context.getLogger().warn(RB.$((String)"validation_distributions_platform", (Object[])new Object[]{distribution.getName(), index, artifact.getPlatform(), System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()}));
        }
    }

    public static void validateArtifactPlatforms(org.jreleaser.model.internal.distributions.Distribution distribution, Packager<?> packager, List<Artifact> candidateArtifacts, Errors errors) {
        if (distribution.getType() == Distribution.DistributionType.BINARY || distribution.getType() == Distribution.DistributionType.FLAT_BINARY || distribution.getType() == Distribution.DistributionType.JLINK || distribution.getType() == Distribution.DistributionType.NATIVE_PACKAGE) {
            AtomicBoolean universal = new AtomicBoolean();
            String noPlatform = "<nil>";
            Map<String, List<Artifact>> byPlatform = candidateArtifacts.stream().peek(artifact -> {
                if ((distribution.getType() == Distribution.DistributionType.BINARY || distribution.getType() == Distribution.DistributionType.FLAT_BINARY) && artifact.extraPropertyIsTrue("universal")) {
                    universal.compareAndSet(false, true);
                }
            }).collect(Collectors.groupingBy(artifact -> StringUtils.isBlank((String)artifact.getPlatform()) ? noPlatform : artifact.getPlatform()));
            if (byPlatform.containsKey(noPlatform) && !universal.get()) {
                errors.configuration(RB.$((String)"validation_distributions_platform_check", (Object[])new Object[]{distribution.getName(), distribution.getType(), packager.getType()}));
            }
            if (byPlatform.keySet().stream().noneMatch(packager::supportsPlatform) && !universal.get()) {
                errors.warning(RB.$((String)"WARNING.validation.packager.no.artifacts", (Object[])new Object[]{distribution.getName(), packager.getType(), packager.getSupportedFileExtensions(distribution.getType())}));
                packager.disable();
            }
        }
    }

    public static void postValidateDistributions(JReleaserContext context, Errors errors) {
        context.getLogger().debug("distributions");
        Map<String, org.jreleaser.model.internal.distributions.Distribution> distributions = context.getModel().getDistributions();
        for (Map.Entry<String, org.jreleaser.model.internal.distributions.Distribution> e : distributions.entrySet()) {
            org.jreleaser.model.internal.distributions.Distribution distribution = e.getValue();
            if (!distribution.isEnabled()) continue;
            DistributionsValidator.postValidateDistribution(context, distribution, errors);
        }
    }

    private static void postValidateDistribution(JReleaserContext context, org.jreleaser.model.internal.distributions.Distribution distribution, Errors errors) {
        context.getLogger().debug("distribution.{}", new Object[]{distribution.getName()});
        ChocolateyPackagerValidator.postValidateChocolatey(context, distribution, distribution.getChocolatey(), errors);
        WingetPackagerValidator.postValidateWinget(context, distribution, distribution.getWinget(), errors);
    }

    public static boolean isJavaDistribution(org.jreleaser.model.internal.distributions.Distribution distribution) {
        return DistributionsValidator.isGraalVMDistribution(distribution) || Distribution.JAVA_DISTRIBUTION_TYPES.contains(distribution.getType());
    }

    public static boolean isGraalVMDistribution(org.jreleaser.model.internal.distributions.Distribution distribution) {
        return distribution.getType() == Distribution.DistributionType.BINARY && StringUtils.isTrue((Object)distribution.getExtraProperties().get("graalVMNativeImage"));
    }
}

