/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.common;

import java.util.Collection;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Http;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;

public final class HttpValidator {
    private static final String PASSWORD = ".password";
    private static final String USERNAME = ".username";

    private HttpValidator() {
    }

    public static void validateHttp(JReleaserContext context, Http http, String prefix, String name, Errors errors) {
        String baseKey1 = prefix + ".http." + name;
        String baseKey2 = prefix + ".http";
        String baseKey3 = "http." + name;
        String baseKey4 = "http";
        switch (http.resolveAuthorization()) {
            case BEARER: {
                http.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + PASSWORD, baseKey2 + PASSWORD, baseKey3 + PASSWORD, baseKey4 + PASSWORD}), baseKey1 + PASSWORD, http.getPassword(), errors, context.isDryrun()));
                break;
            }
            case BASIC: {
                http.setUsername(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + USERNAME, baseKey2 + USERNAME, baseKey3 + USERNAME, baseKey4 + USERNAME}), baseKey1 + USERNAME, http.getUsername(), errors, context.isDryrun()));
                http.setPassword(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{baseKey1 + PASSWORD, baseKey2 + PASSWORD, baseKey3 + PASSWORD, baseKey4 + PASSWORD}), baseKey1 + PASSWORD, http.getPassword(), errors, context.isDryrun()));
                break;
            }
        }
    }
}

