/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.assemble;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Active;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Stereotype;
import org.jreleaser.model.api.assemble.NativeImageAssembler;
import org.jreleaser.model.api.common.Artifact;
import org.jreleaser.model.api.common.Glob;
import org.jreleaser.model.api.common.Java;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.AbstractJavaAssembler;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.AbstractModelObject;
import org.jreleaser.model.internal.common.ArchiveOptions;
import org.jreleaser.model.internal.common.Domain;
import org.jreleaser.model.internal.common.FileSet;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssembler
extends AbstractJavaAssembler<NativeImageAssembler, org.jreleaser.model.api.assemble.NativeImageAssembler> {
    private final List<String> args = new ArrayList<String>();
    private final Set<String> components = new LinkedHashSet<String>();
    private final org.jreleaser.model.internal.common.Artifact graal = new org.jreleaser.model.internal.common.Artifact();
    private final Set<org.jreleaser.model.internal.common.Artifact> graalJdks = new LinkedHashSet<org.jreleaser.model.internal.common.Artifact>();
    private final Upx upx = new Upx();
    private final Linux linux = new Linux();
    private final Windows windows = new Windows();
    private final Osx osx = new Osx();
    private final ArchiveOptions options = new ArchiveOptions();
    private String imageName;
    private String imageNameTransform;
    private Archive.Format archiveFormat;
    @JsonIgnore
    private final org.jreleaser.model.api.assemble.NativeImageAssembler immutable = new org.jreleaser.model.api.assemble.NativeImageAssembler(){
        private Set<? extends Artifact> artifacts;
        private Set<? extends Artifact> graalJdks;
        private List<? extends org.jreleaser.model.api.common.FileSet> fileSets;
        private Set<? extends Artifact> outputs;
        private List<? extends Glob> jars;
        private List<? extends Glob> files;

        public String getImageName() {
            return NativeImageAssembler.this.imageName;
        }

        public String getImageNameTransform() {
            return NativeImageAssembler.this.imageNameTransform;
        }

        public Archive.Format getArchiveFormat() {
            return NativeImageAssembler.this.archiveFormat;
        }

        public org.jreleaser.model.api.common.ArchiveOptions getOptions() {
            return NativeImageAssembler.this.options.asImmutable();
        }

        public Artifact getGraal() {
            return NativeImageAssembler.this.graal.asImmutable();
        }

        public Set<? extends Artifact> getGraalJdks() {
            if (null == this.graalJdks) {
                this.graalJdks = NativeImageAssembler.this.graalJdks.stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.graalJdks;
        }

        public List<String> getArgs() {
            return Collections.unmodifiableList(NativeImageAssembler.this.args);
        }

        public Set<String> getComponents() {
            return Collections.unmodifiableSet(NativeImageAssembler.this.components);
        }

        public NativeImageAssembler.Upx getUpx() {
            return NativeImageAssembler.this.upx.asImmutable();
        }

        public NativeImageAssembler.Linux getLinux() {
            return NativeImageAssembler.this.linux.asImmutable();
        }

        public NativeImageAssembler.Windows getWindows() {
            return NativeImageAssembler.this.windows.asImmutable();
        }

        public NativeImageAssembler.Osx getOsx() {
            return NativeImageAssembler.this.osx.asImmutable();
        }

        public String getExecutable() {
            return NativeImageAssembler.this.getExecutable();
        }

        public String getTemplateDirectory() {
            return NativeImageAssembler.this.getTemplateDirectory();
        }

        public Set<String> getSkipTemplates() {
            return Collections.unmodifiableSet(NativeImageAssembler.this.getSkipTemplates());
        }

        public Java getJava() {
            return NativeImageAssembler.this.getJava().asImmutable();
        }

        public Artifact getMainJar() {
            return NativeImageAssembler.this.getMainJar().asImmutable();
        }

        public List<? extends Glob> getJars() {
            if (null == this.jars) {
                this.jars = NativeImageAssembler.this.getJars().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.jars;
        }

        public Set<? extends Artifact> getArtifacts() {
            if (null == this.artifacts) {
                this.artifacts = NativeImageAssembler.this.getArtifacts().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.artifacts;
        }

        public List<? extends Glob> getFiles() {
            if (null == this.files) {
                this.files = NativeImageAssembler.this.getFiles().stream().map(org.jreleaser.model.internal.common.Glob::asImmutable).collect(Collectors.toList());
            }
            return this.files;
        }

        public Platform getPlatform() {
            return NativeImageAssembler.this.getPlatform().asImmutable();
        }

        public Distribution.DistributionType getDistributionType() {
            return NativeImageAssembler.this.getDistributionType();
        }

        public String getType() {
            return NativeImageAssembler.this.getType();
        }

        public Stereotype getStereotype() {
            return NativeImageAssembler.this.getStereotype();
        }

        public boolean isExported() {
            return NativeImageAssembler.this.isExported();
        }

        public String getName() {
            return NativeImageAssembler.this.getName();
        }

        public List<? extends org.jreleaser.model.api.common.FileSet> getFileSets() {
            if (null == this.fileSets) {
                this.fileSets = NativeImageAssembler.this.getFileSets().stream().map(FileSet::asImmutable).collect(Collectors.toList());
            }
            return this.fileSets;
        }

        public Set<? extends Artifact> getOutputs() {
            if (null == this.outputs) {
                this.outputs = NativeImageAssembler.this.getOutputs().stream().map(org.jreleaser.model.internal.common.Artifact::asImmutable).collect(Collectors.toSet());
            }
            return this.outputs;
        }

        public Active getActive() {
            return NativeImageAssembler.this.getActive();
        }

        public boolean isEnabled() {
            return NativeImageAssembler.this.isEnabled();
        }

        public Map<String, Object> asMap(boolean full) {
            return Collections.unmodifiableMap(NativeImageAssembler.this.asMap(full));
        }

        public String getPrefix() {
            return NativeImageAssembler.this.prefix();
        }

        public Map<String, Object> getExtraProperties() {
            return Collections.unmodifiableMap(NativeImageAssembler.this.getExtraProperties());
        }
    };

    public NativeImageAssembler() {
        super("native-image");
    }

    @Override
    public org.jreleaser.model.api.assemble.NativeImageAssembler asImmutable() {
        return this.immutable;
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.BINARY;
    }

    @Override
    public void merge(NativeImageAssembler source) {
        super.merge(source);
        this.imageName = this.merge(this.imageName, source.imageName);
        this.imageNameTransform = this.merge(this.imageNameTransform, source.imageNameTransform);
        this.archiveFormat = this.merge(this.archiveFormat, source.archiveFormat);
        this.setOptions(source.options);
        this.setGraal(source.graal);
        this.setGraalJdks(this.merge(this.graalJdks, source.graalJdks));
        this.setArgs(this.merge(this.args, source.args));
        this.setComponents(this.merge(this.components, source.components));
        this.setUpx(source.upx);
        this.setLinux(source.linux);
        this.setWindows(source.windows);
        this.setOsx(source.osx);
    }

    public String getResolvedImageName(JReleaserContext context) {
        TemplateContext props = context.getModel().props();
        props.setAll(this.props());
        return Templates.resolveTemplate((String)this.imageName, (TemplateContext)props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        TemplateContext props = context.getModel().props();
        props.setAll(this.props());
        return Templates.resolveTemplate((String)this.imageNameTransform, (TemplateContext)props);
    }

    public PlatformCustomizer getResolvedPlatformCustomizer() {
        String currentPlatform = PlatformUtils.getCurrentFull();
        if (PlatformUtils.isMac((String)currentPlatform)) {
            return this.getOsx();
        }
        if (PlatformUtils.isWindows((String)currentPlatform)) {
            return this.getWindows();
        }
        return this.getLinux();
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Archive.Format getArchiveFormat() {
        return this.archiveFormat;
    }

    public void setArchiveFormat(Archive.Format archiveFormat) {
        this.archiveFormat = archiveFormat;
    }

    public void setArchiveFormat(String archiveFormat) {
        this.archiveFormat = Archive.Format.of((String)archiveFormat);
    }

    public ArchiveOptions getOptions() {
        return this.options;
    }

    public void setOptions(ArchiveOptions options) {
        this.options.merge(options);
    }

    public org.jreleaser.model.internal.common.Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(org.jreleaser.model.internal.common.Artifact graal) {
        this.graal.merge(graal);
    }

    public Set<org.jreleaser.model.internal.common.Artifact> getGraalJdks() {
        return org.jreleaser.model.internal.common.Artifact.sortArtifacts(this.graalJdks);
    }

    public void setGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.clear();
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdks(Set<org.jreleaser.model.internal.common.Artifact> graalJdks) {
        this.graalJdks.addAll(graalJdks);
    }

    public void addGraalJdk(org.jreleaser.model.internal.common.Artifact jdk) {
        if (null != jdk) {
            this.graalJdks.add(jdk);
        }
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public Set<String> getComponents() {
        return this.components;
    }

    public void setComponents(Set<String> components) {
        this.components.clear();
        this.components.addAll(components);
    }

    public Upx getUpx() {
        return this.upx;
    }

    public void setUpx(Upx upx) {
        this.upx.merge(upx);
    }

    public Linux getLinux() {
        return this.linux;
    }

    public void setLinux(Linux linux) {
        this.linux.merge(linux);
    }

    public Windows getWindows() {
        return this.windows;
    }

    public void setWindows(Windows windows) {
        this.windows.merge(windows);
    }

    public Osx getOsx() {
        return this.osx;
    }

    public void setOsx(Osx osx) {
        this.osx.merge(osx);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("archiveFormat", this.archiveFormat);
        props.put("options", this.options.asMap(full));
        LinkedHashMap<String, Map<String, Object>> mappedJdks = new LinkedHashMap<String, Map<String, Object>>();
        int i = 0;
        for (org.jreleaser.model.internal.common.Artifact graalJdk : this.getGraalJdks()) {
            mappedJdks.put("jdk " + i++, graalJdk.asMap(full));
        }
        props.put("graal", this.graal.asMap(full));
        props.put("graalJdks", mappedJdks);
        props.put("args", this.args);
        props.put("components", this.components);
        props.put("upx", this.upx.asMap(full));
        props.putAll(this.linux.asMap(full));
        props.putAll(this.osx.asMap(full));
        props.putAll(this.windows.asMap(full));
    }

    public static final class Osx
    extends AbstractPlatformCustomizer<Osx> {
        private static final long serialVersionUID = 1619426199448547975L;
        @JsonIgnore
        private final NativeImageAssembler.Osx immutable = new NativeImageAssembler.Osx(){
            private static final long serialVersionUID = -4484609486153782109L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Osx() {
            super("osx");
        }

        public NativeImageAssembler.Osx asImmutable() {
            return this.immutable;
        }
    }

    public static final class Windows
    extends AbstractPlatformCustomizer<Windows> {
        private static final long serialVersionUID = -2310019463850744244L;
        @JsonIgnore
        private final NativeImageAssembler.Windows immutable = new NativeImageAssembler.Windows(){
            private static final long serialVersionUID = 1216711581026682524L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Windows() {
            super("windows");
        }

        public NativeImageAssembler.Windows asImmutable() {
            return this.immutable;
        }
    }

    public static final class Linux
    extends AbstractPlatformCustomizer<Linux> {
        private static final long serialVersionUID = -7751015791770722168L;
        @JsonIgnore
        private final NativeImageAssembler.Linux immutable = new NativeImageAssembler.Linux(){
            private static final long serialVersionUID = -4020602674846221641L;

            public String getPlatform() {
                return this.getPlatform();
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(this.getArgs());
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public Linux() {
            super("linux");
        }

        public NativeImageAssembler.Linux asImmutable() {
            return this.immutable;
        }
    }

    public static final class Upx
    extends AbstractActivatable<Upx>
    implements Domain {
        private static final long serialVersionUID = -4962541080085819348L;
        private final List<String> args = new ArrayList<String>();
        private String version;
        @JsonIgnore
        private final NativeImageAssembler.Upx immutable = new NativeImageAssembler.Upx(){
            private static final long serialVersionUID = 3190807504460186043L;

            public String getVersion() {
                return version;
            }

            public List<String> getArgs() {
                return Collections.unmodifiableList(args);
            }

            public Active getActive() {
                return this.getActive();
            }

            public boolean isEnabled() {
                return this.isEnabled();
            }

            public Map<String, Object> asMap(boolean full) {
                return Collections.unmodifiableMap(this.asMap(full));
            }
        };

        public NativeImageAssembler.Upx asImmutable() {
            return this.immutable;
        }

        @Override
        public void merge(Upx source) {
            super.merge(source);
            this.version = this.merge(this.version, source.version);
            this.setArgs(this.merge(this.args, source.args));
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public List<String> getArgs() {
            return this.args;
        }

        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            if (!full && !this.isEnabled()) {
                return Collections.emptyMap();
            }
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            props.put("enabled", this.isEnabled());
            props.put("active", this.getActive());
            props.put("version", this.version);
            return props;
        }
    }

    private static abstract class AbstractPlatformCustomizer<S extends AbstractPlatformCustomizer<S>>
    extends AbstractModelObject<S>
    implements PlatformCustomizer {
        private static final long serialVersionUID = 8640931163688760790L;
        private final List<String> args = new ArrayList<String>();
        private final String platform;

        protected AbstractPlatformCustomizer(String platform) {
            this.platform = platform;
        }

        @Override
        public void merge(S source) {
            this.setArgs(this.merge(this.args, ((AbstractPlatformCustomizer)source).getArgs()));
        }

        @Override
        public List<String> getArgs() {
            return this.args;
        }

        @Override
        public void setArgs(List<String> args) {
            this.args.clear();
            this.args.addAll(args);
        }

        @Override
        public String getPlatform() {
            return this.platform;
        }

        @Override
        public Map<String, Object> asMap(boolean full) {
            LinkedHashMap<String, List<String>> props = new LinkedHashMap<String, List<String>>();
            props.put("args", this.args);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put(this.platform, props);
            return map;
        }
    }

    public static interface PlatformCustomizer
    extends Domain {
        public String getPlatform();

        public List<String> getArgs();

        public void setArgs(List<String> var1);
    }
}

