/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.function.Consumer;

public final class IoUtils {
    private IoUtils() {
    }

    public static Scanner newScanner(InputStream in) {
        return new Scanner(in, StandardCharsets.UTF_8.name());
    }

    public static PrintWriter newPrintWriter(OutputStream out) {
        return IoUtils.newPrintWriter(out, true);
    }

    public static PrintWriter newPrintWriter(OutputStream out, boolean autoFlush) {
        return new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)), autoFlush);
    }

    public static PrintStream newPrintStream(OutputStream out) {
        return IoUtils.newPrintStream(out, true);
    }

    public static PrintStream newPrintStream(OutputStream out, boolean autoFlush) {
        try {
            return new PrintStream(out, autoFlush, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(ByteArrayOutputStream out) {
        try {
            return out.toString(StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void withInputStream(InputStream input, Consumer<? super Character> consumer) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);){
            int ch;
            while ((ch = reader.read()) != -1) {
                consumer.accept(Character.valueOf((char)ch));
            }
        }
    }

    public static void withLines(InputStream input, Consumer<? super String> consumer) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            reader.lines().forEach(consumer);
        }
    }
}

