/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import feign.Request;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jreleaser.util.StringUtils;

public class RestAPIException
extends RuntimeException {
    private static final long serialVersionUID = -3807652106740042028L;
    private final Request request;
    private final int status;
    private final String reason;
    private final String body;
    private final Map<String, Collection<String>> headers;

    public RestAPIException(int status, String reason) {
        this(null, status, reason, Collections.emptyMap());
    }

    public RestAPIException(int status, String reason, String body) {
        this(null, status, reason, body, Collections.emptyMap());
    }

    public RestAPIException(Request request, int status, String reason, Map<String, Collection<String>> headers) {
        this(request, status, reason, "", headers);
    }

    public RestAPIException(Request request, int status, String reason, String body, Map<String, Collection<String>> headers) {
        super(status + ": " + reason + (StringUtils.isNotBlank((String)body) ? System.lineSeparator() + body : ""));
        this.request = request;
        this.status = status;
        this.reason = reason;
        this.body = body;
        this.headers = headers;
    }

    public Request getRequest() {
        return this.request;
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String getBody() {
        return this.body;
    }

    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    public boolean isNotFound() {
        return 404 == this.status;
    }

    public boolean isForbidden() {
        return 403 == this.status;
    }

    public boolean isUnprocessableEntity() {
        return 422 == this.status;
    }
}

