/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.SignatureSubpacketTags;
import org.bouncycastle.bcpg.StreamUtil;
import org.bouncycastle.bcpg.sig.EmbeddedSignature;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class SignatureSubpacketInputStream
extends InputStream
implements SignatureSubpacketTags {
    private final InputStream in;
    private final int limit;

    public SignatureSubpacketInputStream(InputStream inputStream) {
        this(inputStream, StreamUtil.findLimit(inputStream));
    }

    public SignatureSubpacketInputStream(InputStream inputStream, int n) {
        this.in = inputStream;
        this.limit = n;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public SignatureSubpacket readPacket() throws IOException {
        int n = this.read();
        int n2 = 0;
        if (n < 0) {
            return null;
        }
        boolean bl = false;
        if (n < 192) {
            n2 = n;
        } else if (n <= 223) {
            n2 = (n - 192 << 8) + this.in.read() + 192;
        } else if (n == 255) {
            bl = true;
            n2 = this.in.read() << 24 | this.in.read() << 16 | this.in.read() << 8 | this.in.read();
        } else {
            throw new IOException("unexpected length header");
        }
        int n3 = this.in.read();
        if (n3 < 0) {
            throw new EOFException("unexpected EOF reading signature sub packet");
        }
        if (n2 <= 0 || n2 > this.limit && n2 > 2048) {
            throw new EOFException("out of range data found in signature sub packet");
        }
        byte[] byArray = new byte[n2 - 1];
        int n4 = Streams.readFully((InputStream)this.in, (byte[])byArray);
        boolean bl2 = (n3 & 0x80) != 0;
        int n5 = n3 & 0x7F;
        if (n4 != byArray.length) {
            switch (n5) {
                case 2: {
                    byArray = this.checkData(byArray, 4, n4, "Signature Creation Time");
                    break;
                }
                case 16: {
                    byArray = this.checkData(byArray, 8, n4, "Issuer");
                    break;
                }
                case 9: {
                    byArray = this.checkData(byArray, 4, n4, "Signature Key Expiration Time");
                    break;
                }
                case 3: {
                    byArray = this.checkData(byArray, 4, n4, "Signature Expiration Time");
                    break;
                }
                default: {
                    throw new EOFException("truncated subpacket data.");
                }
            }
        }
        switch (n5) {
            case 2: {
                return new SignatureCreationTime(bl2, bl, byArray);
            }
            case 32: {
                return new EmbeddedSignature(bl2, bl, byArray);
            }
            case 9: {
                return new KeyExpirationTime(bl2, bl, byArray);
            }
            case 3: {
                return new SignatureExpirationTime(bl2, bl, byArray);
            }
            case 7: {
                return new Revocable(bl2, bl, byArray);
            }
            case 4: {
                return new Exportable(bl2, bl, byArray);
            }
            case 30: {
                return new Features(bl2, bl, byArray);
            }
            case 16: {
                return new IssuerKeyID(bl2, bl, byArray);
            }
            case 5: {
                return new TrustSignature(bl2, bl, byArray);
            }
            case 11: 
            case 21: 
            case 22: {
                return new PreferredAlgorithms(n5, bl2, bl, byArray);
            }
            case 39: {
                return new PreferredAEADCiphersuites(bl2, bl, byArray);
            }
            case 27: {
                return new KeyFlags(bl2, bl, byArray);
            }
            case 26: {
                return new PolicyURI(bl2, bl, byArray);
            }
            case 25: {
                return new PrimaryUserID(bl2, bl, byArray);
            }
            case 28: {
                return new SignerUserID(bl2, bl, byArray);
            }
            case 20: {
                return new NotationData(bl2, bl, byArray);
            }
            case 6: {
                return new RegularExpression(bl2, bl, byArray);
            }
            case 29: {
                return new RevocationReason(bl2, bl, byArray);
            }
            case 12: {
                return new RevocationKey(bl2, bl, byArray);
            }
            case 31: {
                return new SignatureTarget(bl2, bl, byArray);
            }
            case 33: {
                return new IssuerFingerprint(bl2, bl, byArray);
            }
            case 35: {
                return new IntendedRecipientFingerprint(bl2, bl, byArray);
            }
        }
        return new SignatureSubpacket(n5, bl2, bl, byArray);
    }

    private byte[] checkData(byte[] byArray, int n, int n2, String string) throws EOFException {
        if (n2 != n) {
            throw new EOFException("truncated " + string + " subpacket data.");
        }
        return Arrays.copyOfRange((byte[])byArray, (int)0, (int)n);
    }
}

