/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.bouncycastle.openpgp.PGPException;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserCommand;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.JReleaserModelResolver;
import org.jreleaser.model.JReleaserModelValidator;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.Project;
import org.jreleaser.model.Signing;
import org.jreleaser.model.releaser.spi.Releaser;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.JReleaserException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.SemVer;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.signing.FilesKeyring;
import org.jreleaser.util.signing.InMemoryKeyring;
import org.jreleaser.util.signing.Keyring;
import org.jreleaser.util.signing.SigningException;

public class JReleaserContext {
    private final JReleaserLogger logger;
    private final JReleaserModel model;
    private final Path basedir;
    private final Path outputDirectory;
    private final boolean dryrun;
    private final boolean gitRootSearch;
    private final Mode mode;
    private final Configurer configurer;
    private final Errors errors = new Errors();
    private final List<String> selectedPlatforms = new ArrayList<String>();
    private final List<String> includedAnnouncers = new ArrayList<String>();
    private final List<String> includedAssemblers = new ArrayList<String>();
    private final List<String> includedDistributions = new ArrayList<String>();
    private final List<String> includedPackagers = new ArrayList<String>();
    private final List<String> includedUploaderTypes = new ArrayList<String>();
    private final List<String> includedUploaderNames = new ArrayList<String>();
    private final List<String> excludedAnnouncers = new ArrayList<String>();
    private final List<String> excludedAssemblers = new ArrayList<String>();
    private final List<String> excludedDistributions = new ArrayList<String>();
    private final List<String> excludedPackagers = new ArrayList<String>();
    private final List<String> excludedUploaderTypes = new ArrayList<String>();
    private final List<String> excludedUploaderNames = new ArrayList<String>();
    private String changelog;
    private Releaser releaser;
    private JReleaserCommand command;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JReleaserContext(JReleaserLogger logger, Configurer configurer, Mode mode, JReleaserModel model, Path basedir, Path outputDirectory, boolean dryrun, boolean gitRootSearch, List<String> selectedPlatforms) {
        this.logger = logger;
        this.configurer = configurer;
        this.mode = mode;
        this.model = model;
        this.basedir = basedir;
        this.outputDirectory = outputDirectory;
        this.dryrun = dryrun;
        this.gitRootSearch = gitRootSearch;
        this.selectedPlatforms.addAll(selectedPlatforms.stream().filter(PlatformUtils::isSupported).collect(Collectors.toList()));
        try {
            logger.increaseIndent();
            logger.debug("- baseOutputDirectory set to " + this.getOutputDirectory().getParent());
            logger.debug("- outputDirectory set to " + this.getOutputDirectory());
            logger.debug("- checksumDirectory set to " + this.getChecksumsDirectory());
            logger.debug("- signaturesDirectory set to " + this.getSignaturesDirectory());
            logger.debug("- prepareDirectory set to " + this.getPrepareDirectory());
            logger.debug("- packageDirectory set to " + this.getPackageDirectory());
            logger.debug("- assembleDirectory set to " + this.getAssembleDirectory());
            logger.debug("- artifactsDirectory set to " + this.getArtifactsDirectory());
        }
        finally {
            logger.decreaseIndent();
        }
        ArrayList<String> unmatchedPlatforms = new ArrayList<String>(selectedPlatforms);
        unmatchedPlatforms.removeAll(this.selectedPlatforms);
        if (!unmatchedPlatforms.isEmpty()) {
            logger.warn(RB.$((String)"context.platform.selection.active", (Object[])new Object[0]));
            logger.error(RB.$((String)"context.platform.selection.no.match", (Object[])new Object[0]), new Object[]{unmatchedPlatforms});
            logger.error(RB.$((String)"context.platform.selection.valid", (Object[])new Object[0]), new Object[]{System.lineSeparator(), PlatformUtils.getSupportedOsNames(), System.lineSeparator(), PlatformUtils.getSupportedOsArchs()});
            throw new JReleaserException(RB.$((String)"context.platform.selection.unmatched", (Object[])new Object[]{unmatchedPlatforms}));
        }
        if (!this.selectedPlatforms.isEmpty()) {
            logger.warn(RB.$((String)"context.platform.selection.active", (Object[])new Object[0]));
            logger.warn(RB.$((String)"context.platform.selection.artifacts", (Object[])new Object[0]), new Object[]{this.selectedPlatforms});
        }
    }

    public Path relativize(Path basedir, Path other) {
        return basedir.toAbsolutePath().relativize(other.toAbsolutePath());
    }

    public Path relativizeToBasedir(Path other) {
        return this.relativize(this.basedir, other);
    }

    public Errors validateModel() {
        if (this.errors.hasErrors()) {
            return this.errors;
        }
        this.model.getEnvironment().initProps(this);
        this.logger.info(RB.$((String)"context.configuration.validation", (Object[])new Object[0]));
        if (this.mode.validateConfig()) {
            this.adjustDistributions();
        }
        try {
            JReleaserModelValidator.validate(this, this.mode, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        if (this.errors.hasWarnings()) {
            this.logger.warn("== JReleaser ==");
            this.errors.logWarnings(this.logger);
        }
        if (this.errors.hasErrors()) {
            this.logger.error("== JReleaser ==");
            this.errors.logErrors(this.logger);
        }
        return this.errors;
    }

    private void adjustDistributions() {
        this.logger.debug(RB.$((String)"context.adjust.assemblies", (Object[])new Object[0]));
        try {
            JReleaserModelValidator.validate(this, Mode.ASSEMBLE, this.errors);
            JReleaserModelResolver.resolve(this, this.errors);
        }
        catch (Exception e) {
            this.logger.trace((Throwable)e);
            this.errors.configuration(e.toString());
        }
        for (Assembler assembler : this.model.getAssemble().findAllAssemblers()) {
            if (!assembler.isExported()) continue;
            Distribution distribution = this.model.getDistributions().get(assembler.getName());
            if (null == distribution) {
                distribution = new Distribution();
                distribution.setType(assembler.getDistributionType());
                distribution.setName(assembler.getName());
                this.model.getDistributions().put(assembler.getName(), distribution);
            }
            distribution.setName(assembler.getName());
            distribution.setType(assembler.getDistributionType());
            distribution.setActive(assembler.getActive());
            if (assembler instanceof JavaAssembler) {
                distribution.getExecutable().setName(((JavaAssembler)assembler).getExecutable());
                distribution.setJava(((JavaAssembler)assembler).getJava());
            }
            this.mergeArtifacts(assembler, distribution);
            LinkedHashMap<String, Object> extraProperties = new LinkedHashMap<String, Object>(distribution.getExtraProperties());
            extraProperties.putAll(assembler.getExtraProperties());
            distribution.mergeExtraProperties(extraProperties);
        }
    }

    private void mergeArtifacts(Assembler assembler, Distribution distribution) {
        for (Artifact incoming : assembler.getOutputs()) {
            Optional<Artifact> artifact = distribution.getArtifacts().stream().filter(a -> {
                if (this.isPlatformSelected(incoming)) {
                    incoming.activate();
                }
                if (this.isPlatformSelected((Artifact)a)) {
                    a.activate();
                }
                if (incoming.isActive() && a.isActive()) {
                    Path p1 = incoming.getResolvedPath(this, assembler);
                    Path p2 = a.getResolvedPath(this, distribution);
                    return p1.equals(p2);
                }
                return false;
            }).findFirst();
            if (artifact.isPresent()) {
                artifact.get().merge(incoming);
                continue;
            }
            distribution.addArtifact(incoming);
        }
    }

    public boolean isPlatformSelected(Artifact artifact) {
        return this.isPlatformSelected(artifact.getPlatform());
    }

    public boolean isPlatformSelected(String platform) {
        if (StringUtils.isBlank((String)platform) || this.selectedPlatforms.isEmpty()) {
            return true;
        }
        return this.selectedPlatforms.stream().anyMatch(selected -> PlatformUtils.isCompatible((String)selected, (String)platform));
    }

    public JReleaserLogger getLogger() {
        return this.logger;
    }

    public Configurer getConfigurer() {
        return this.configurer;
    }

    public Mode getMode() {
        return this.mode;
    }

    public JReleaserModel getModel() {
        return this.model;
    }

    public Path getBasedir() {
        return this.basedir;
    }

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public Path getChecksumsDirectory() {
        return this.outputDirectory.resolve("checksums");
    }

    public Path getSignaturesDirectory() {
        return this.outputDirectory.resolve("signatures");
    }

    public Path getPrepareDirectory() {
        return this.outputDirectory.resolve("prepare");
    }

    public Path getPackageDirectory() {
        return this.outputDirectory.resolve("package");
    }

    public Path getAssembleDirectory() {
        return this.outputDirectory.resolve("assemble");
    }

    public Path getArtifactsDirectory() {
        return this.outputDirectory.resolve("artifacts");
    }

    public boolean isDryrun() {
        return this.dryrun;
    }

    public boolean isGitRootSearch() {
        return this.gitRootSearch;
    }

    public String getChangelog() {
        return this.changelog;
    }

    public void setChangelog(String changelog) {
        this.changelog = changelog;
    }

    public Releaser getReleaser() {
        return this.releaser;
    }

    public void setReleaser(Releaser releaser) {
        this.releaser = releaser;
    }

    private List<String> normalize(List<String> list) {
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> tmp = new ArrayList<String>(list);
        for (int i = 0; i < tmp.size(); ++i) {
            String s = ((String)tmp.get(i)).trim();
            if (!s.contains("-")) {
                s = StringUtils.getHyphenatedName((String)s);
            }
            tmp.set(i, s.toLowerCase());
        }
        return tmp;
    }

    public List<String> getIncludedAnnouncers() {
        return this.includedAnnouncers;
    }

    public void setIncludedAnnouncers(List<String> includedAnnouncers) {
        this.includedAnnouncers.clear();
        this.includedAnnouncers.addAll(this.normalize(includedAnnouncers));
    }

    public List<String> getIncludedAssemblers() {
        return this.includedAssemblers;
    }

    public void setIncludedAssemblers(List<String> includedAssemblerTypes) {
        this.includedAssemblers.clear();
        this.includedAssemblers.addAll(this.normalize(includedAssemblerTypes));
    }

    public List<String> getIncludedDistributions() {
        return this.includedDistributions;
    }

    public void setIncludedDistributions(List<String> includedDistributions) {
        this.includedDistributions.clear();
        this.includedDistributions.addAll(includedDistributions);
    }

    public List<String> getIncludedPackagers() {
        return this.includedPackagers;
    }

    public void setIncludedPackagers(List<String> includedPackagers) {
        this.includedPackagers.clear();
        this.includedPackagers.addAll(includedPackagers);
    }

    public List<String> getIncludedUploaderTypes() {
        return this.includedUploaderTypes;
    }

    public void setIncludedUploaderTypes(List<String> includedUploaderTypes) {
        this.includedUploaderTypes.clear();
        this.includedUploaderTypes.addAll(this.normalize(includedUploaderTypes));
    }

    public List<String> getIncludedUploaderNames() {
        return this.includedUploaderNames;
    }

    public void setIncludedUploaderNames(List<String> includedUploaderNames) {
        this.includedUploaderNames.clear();
        this.includedUploaderNames.addAll(includedUploaderNames);
    }

    public List<String> getExcludedAnnouncers() {
        return this.excludedAnnouncers;
    }

    public void setExcludedAnnouncers(List<String> excludedAnnouncers) {
        this.excludedAnnouncers.clear();
        this.excludedAnnouncers.addAll(this.normalize(excludedAnnouncers));
    }

    public List<String> getExcludedAssemblers() {
        return this.excludedAssemblers;
    }

    public void setExcludedAssemblers(List<String> excludedAssemblerTypes) {
        this.excludedAssemblers.clear();
        this.excludedAssemblers.addAll(this.normalize(excludedAssemblerTypes));
    }

    public List<String> getExcludedDistributions() {
        return this.excludedDistributions;
    }

    public void setExcludedDistributions(List<String> excludedDistributions) {
        this.excludedDistributions.clear();
        this.excludedDistributions.addAll(excludedDistributions);
    }

    public List<String> getExcludedPackagers() {
        return this.excludedPackagers;
    }

    public void setExcludedPackagers(List<String> excludedPackagers) {
        this.excludedPackagers.clear();
        this.excludedPackagers.addAll(this.normalize(excludedPackagers));
    }

    public List<String> getExcludedUploaderTypes() {
        return this.excludedUploaderTypes;
    }

    public void setExcludedUploaderTypes(List<String> excludedUploaderTypes) {
        this.excludedUploaderTypes.clear();
        this.excludedUploaderTypes.addAll(this.normalize(excludedUploaderTypes));
    }

    public List<String> getExcludedUploaderNames() {
        return this.excludedUploaderNames;
    }

    public void setExcludedUploaderNames(List<String> excludedUploaderNames) {
        this.excludedUploaderNames.clear();
        this.excludedUploaderNames.addAll(excludedUploaderNames);
    }

    public JReleaserCommand getCommand() {
        return this.command;
    }

    public void setCommand(JReleaserCommand command) {
        this.command = command;
    }

    public Map<String, Object> props() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.model.props());
        props.put("baseOutputDirectory", this.getOutputDirectory().getParent());
        props.put("outputDirectory", this.getOutputDirectory());
        props.put("checksumDirectory", this.getChecksumsDirectory());
        props.put("signaturesDirectory", this.getSignaturesDirectory());
        props.put("prepareDirectory", this.getPrepareDirectory());
        props.put("packageDirectory", this.getPackageDirectory());
        props.put("assembleDirectory", this.getAssembleDirectory());
        props.put("artifactsDirectory", this.getArtifactsDirectory());
        return props;
    }

    public Map<String, Object> fullProps() {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.props());
        props.putAll(this.model.props());
        return props;
    }

    public String toString() {
        return "JReleaserContext[basedir=" + this.basedir.toAbsolutePath() + ", outputDirectory=" + this.outputDirectory.toAbsolutePath() + ", dryrun=" + this.dryrun + ", gitRootSearch=" + this.gitRootSearch + ", mode=" + (Object)((Object)this.mode) + "]";
    }

    public void report() {
        Project project = this.model.getProject();
        SortedProperties props = new SortedProperties();
        props.put("timestamp", this.model.getTimestamp());
        props.put("platform", PlatformUtils.getCurrentFull());
        props.put("platformReplaced", this.model.getPlatform().applyReplacements(PlatformUtils.getCurrentFull()));
        if (this.model.getCommit() != null) {
            props.put("commitShortHash", this.model.getCommit().getShortHash());
            props.put("commitFullHash", this.model.getCommit().getFullHash());
        }
        props.put("projectName", project.getName());
        props.put("projectVersion", project.getVersion());
        props.put("projectSnapshot", String.valueOf(project.isSnapshot()));
        if (this.model.getCommit() != null) {
            GitService gitService = this.model.getRelease().getGitService();
            props.put("tagName", gitService.getEffectiveTagName(this.model));
            if (gitService.isReleaseSupported()) {
                props.put("releaseName", gitService.getEffectiveReleaseName());
                props.put("milestoneName", gitService.getMilestone().getEffectiveName());
            }
        }
        props.put("javaVersion", System.getProperty("java.version"));
        Map<String, Object> resolvedExtraProperties = project.getResolvedExtraProperties();
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMajor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMinor")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionPatch")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionNumber")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionPrerelease")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionTag")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionBuild")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionOptional")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionYear")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMonth")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionDay")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionWeek")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionMicro")), resolvedExtraProperties, (Properties)props);
        CollectionUtils.safePut((String)(project.getPrefix() + StringUtils.capitalize((String)"versionModifier")), resolvedExtraProperties, (Properties)props);
        Path output = this.getOutputDirectory().resolve("output.properties");
        try (FileOutputStream out = new FileOutputStream(output.toFile());){
            this.logger.info(RB.$((String)"context.writing.properties", (Object[])new Object[0]), new Object[]{this.relativizeToBasedir(output)});
            props.store(out, "JReleaser " + JReleaserVersion.getPlainVersion());
        }
        catch (IOException ignored) {
            this.logger.warn(RB.$((String)"context.writing.properties.error", (Object[])new Object[0]), new Object[]{this.relativizeToBasedir(output)});
        }
    }

    public void nag(String version, String message) {
        this.logger.warn(message + " since {}. This warning will become an error in a future release.", new Object[]{version});
    }

    public Keyring createKeyring() throws SigningException {
        try {
            if (this.model.getSigning().getMode() == Signing.Mode.FILE) {
                return new FilesKeyring(this.basedir.resolve(this.model.getSigning().getResolvedPublicKey()), this.basedir.resolve(this.model.getSigning().getResolvedSecretKey())).initialize(this.model.getSigning().isArmored().booleanValue());
            }
            return new InMemoryKeyring(this.model.getSigning().getResolvedPublicKey().getBytes(), this.model.getSigning().getResolvedSecretKey().getBytes()).initialize(this.model.getSigning().isArmored().booleanValue());
        }
        catch (IOException | PGPException e) {
            throw new SigningException(RB.$((String)"ERROR_signing_init_keyring", (Object[])new Object[0]), e);
        }
    }

    public boolean isDistributionIncluded(Distribution distribution) {
        String distributionName = distribution.getName();
        if (!this.includedDistributions.isEmpty()) {
            return this.includedDistributions.contains(distributionName);
        }
        if (!this.excludedDistributions.isEmpty()) {
            return !this.excludedDistributions.contains(distributionName);
        }
        return true;
    }

    private static class IteratorEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<? extends E> iterator;

        public IteratorEnumeration(Iterator<? extends E> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public E nextElement() {
            return this.iterator.next();
        }
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            int javaMajorVersion = SemVer.javaMajorVersion();
            if (javaMajorVersion < 11) {
                return super.entrySet();
            }
            TreeMap<String, Object> map = new TreeMap<String, Object>();
            for (Object k : this.keySet()) {
                map.put(String.valueOf(k), this.get(k));
            }
            return map.entrySet();
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            int javaMajorVersion = SemVer.javaMajorVersion();
            if (javaMajorVersion >= 11) {
                return super.keys();
            }
            Set<Object> keySet = this.keySet();
            ArrayList<String> keys = new ArrayList<String>(keySet.size());
            for (Object key : keySet) {
                keys.add(key.toString());
            }
            Collections.sort(keys);
            return new IteratorEnumeration<Object>(keys.iterator());
        }
    }

    public static enum Configurer {
        CLI("CLI flags"),
        CLI_YAML("CLI yaml DSL"),
        CLI_TOML("CLI toml DSL"),
        CLI_JSON("CLI json DSL"),
        MAVEN("Maven DSL"),
        GRADLE("Gradle DSL");

        private final String dsl;

        private Configurer(String dsl) {
            this.dsl = dsl;
        }

        public String toString() {
            return this.dsl;
        }
    }

    public static enum Mode {
        CONFIG,
        ASSEMBLE,
        FULL,
        CHANGELOG;


        public boolean validateAssembly() {
            return this == ASSEMBLE;
        }

        public boolean validateConfig() {
            return this == CONFIG || this == FULL;
        }

        public boolean validatePaths() {
            return this == FULL;
        }
    }
}

