/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.bundle.RB;
import org.jreleaser.model.Active;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Sdkman;
import org.jreleaser.model.SdkmanAnnouncer;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class SdkmanAnnouncerValidator
extends Validator {
    public static void validateSdkmanAnnouncer(JReleaserContext context, SdkmanAnnouncer sdkman, Errors errors) {
        context.getModel().getActiveDistributions().stream().filter(d -> d.getSdkman().isEnabled()).findFirst().ifPresent(distribution -> sdkman.setActive(Active.ALWAYS));
        if (!sdkman.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        if (!context.getModel().getRelease().getGitService().isReleaseSupported()) {
            sdkman.disable();
            return;
        }
        context.getLogger().debug("announce.sdkman");
        sdkman.setConsumerKey(SdkmanAnnouncerValidator.checkProperty(context, "SDKMAN_CONSUMER_KEY", "sdkman.consumerKey", sdkman.getConsumerKey(), errors, context.isDryrun()));
        sdkman.setConsumerToken(SdkmanAnnouncerValidator.checkProperty(context, "SDKMAN_CONSUMER_TOKEN", "sdkman.consumerToken", sdkman.getConsumerToken(), errors, context.isDryrun()));
        Sdkman sdkmanPackager = context.getModel().getPackagers().getSdkman();
        if (StringUtils.isBlank((String)sdkman.getConsumerKey()) && sdkmanPackager.isEnabled()) {
            sdkman.setConsumerKey(sdkmanPackager.getConsumerKey());
        }
        if (StringUtils.isBlank((String)sdkman.getConsumerToken()) && sdkmanPackager.isEnabled()) {
            sdkman.setConsumerToken(sdkmanPackager.getConsumerToken());
        }
        if (StringUtils.isBlank((String)sdkman.getReleaseNotesUrl())) {
            sdkman.setReleaseNotesUrl(context.getModel().getRelease().getGitService().getReleaseNotesUrl());
        }
        if (context.getModel().getActiveDistributions().isEmpty()) {
            context.getLogger().warn(RB.$((String)"validation_skdman_disable", (Object[])new Object[0]));
            sdkman.disable();
        }
        if (null == sdkman.getCommand()) {
            sdkman.setCommand(Sdkman.Command.MAJOR);
        }
        SdkmanAnnouncerValidator.validateTimeout(sdkman);
    }
}

