/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Active;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Files;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;

public abstract class FilesValidator
extends Validator {
    public static void validateFiles(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        if (!mode.validateConfig()) {
            return;
        }
        context.getLogger().debug("files");
        Files files = context.getModel().getFiles();
        if (!files.isActiveSet()) {
            files.setActive(Active.ALWAYS);
        }
        if (!files.resolveEnabled(context.getModel().getProject())) {
            return;
        }
        files.getArtifacts().forEach(artifact -> {
            if (context.isPlatformSelected((Artifact)artifact)) {
                artifact.activate();
            }
        });
        FilesValidator.validateGlobs(context, files.getGlobs(), "files.glob", errors);
    }
}

