/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.assemblers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.model.assembler.spi.AssemblerProcessingException;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public final class AssemblerUtils {
    private static final String KEY_JAVA_VERSION = "JAVA_VERSION";

    private AssemblerUtils() {
    }

    public static String readJavaVersion(Path path) throws AssemblerProcessingException {
        Path release = path.resolve("release");
        if (!Files.exists(release, new LinkOption[0])) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_jdk_release", (Object[])new Object[]{path.toAbsolutePath()}));
        }
        try {
            Properties props = new Properties();
            props.load(Files.newInputStream(release, new OpenOption[0]));
            if (props.containsKey(KEY_JAVA_VERSION)) {
                String version = props.getProperty(KEY_JAVA_VERSION);
                if (version.startsWith("\"") && version.endsWith("\"")) {
                    return version.substring(1, version.length() - 1);
                }
                return version;
            }
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_jdk_release_file", (Object[])new Object[]{release.toAbsolutePath()}));
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_invalid_jdk_release_file", (Object[])new Object[]{release.toAbsolutePath()}), (Throwable)e);
        }
    }

    public static Set<Path> copyJars(JReleaserContext context, JavaAssembler assembler, Path jarsDirectory, String platform) throws AssemblerProcessingException {
        LinkedHashSet<Path> paths = new LinkedHashSet<Path>();
        if (StringUtils.isBlank((String)platform)) {
            paths.add(assembler.getMainJar().getEffectivePath(context, (Assembler)assembler));
        }
        for (Glob glob : assembler.getJars()) {
            if (!StringUtils.isBlank((String)platform) || !StringUtils.isBlank((String)glob.getPlatform())) {
                if (!StringUtils.isNotBlank((String)platform) || !PlatformUtils.isCompatible((String)platform, (String)glob.getPlatform())) continue;
            }
            glob.getResolvedArtifacts(context).stream().map(artifact -> artifact.getResolvedPath(context, (Assembler)assembler)).forEach(paths::add);
        }
        try {
            Files.createDirectories(jarsDirectory, new FileAttribute[0]);
            for (Path path : paths) {
                context.getLogger().debug(RB.$((String)"assembler.copying", (Object[])new Object[0]), new Object[]{path.getFileName()});
                Files.copy(path, jarsDirectory.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new AssemblerProcessingException(RB.$((String)"ERROR_assembler_copying_jars", (Object[])new Object[0]), (Throwable)e);
        }
        return paths;
    }

    public static Path maybeAdjust(Path path) {
        if (PlatformUtils.isWindows()) {
            return Paths.get(path.toString().replace("/", File.separator), new String[0]);
        }
        return path;
    }

    public static String maybeAdjust(String path) {
        if (PlatformUtils.isWindows()) {
            return path.replace("/", File.separator);
        }
        return path;
    }
}

