/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.commons;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Client;
import feign.Feign;
import feign.Request;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormData;
import feign.form.FormEncoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.apache.tika.mime.MediaType;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserModelPrinter;
import org.jreleaser.model.JReleaserVersion;
import org.jreleaser.model.announcer.spi.AnnounceException;
import org.jreleaser.model.uploader.spi.UploadException;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.util.JReleaserLogger;
import org.jreleaser.util.StringUtils;

public final class ClientUtils {
    private static final Tika TIKA = new Tika();

    private ClientUtils() {
    }

    public static FormData toFormData(Path asset) throws IOException {
        return FormData.builder().fileName(asset.getFileName().toString()).contentType(MediaType.parse((String)TIKA.detect(asset)).toString()).data(Files.readAllBytes(asset)).build();
    }

    public static Feign.Builder builder(JReleaserLogger logger, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        Feign.Builder builder = Feign.builder();
        if (Boolean.getBoolean("jreleaser.disableSslValidation")) {
            logger.warn(RB.$((String)"warn_ssl_disabled", (Object[])new Object[0]));
            builder = builder.client((Client)new Client.Default(ClientUtils.nonValidatingSSLSocketFactory(), (HostnameVerifier)new NonValidatingHostnameVerifier()));
        }
        return builder.encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder())).decoder((Decoder)new JacksonDecoder()).requestInterceptor(template -> template.header("User-Agent", new String[]{"JReleaser/" + JReleaserVersion.getPlainVersion()})).errorDecoder((methodKey, response) -> new RestAPIException(response.request(), response.status(), response.reason(), response.headers())).options(new Request.Options((long)connectTimeout, TimeUnit.SECONDS, (long)readTimeout, TimeUnit.SECONDS, true));
    }

    public static void webhook(JReleaserLogger logger, String webhookUrl, int connectTimeout, int readTimeout, Object message) throws AnnounceException {
        if (message instanceof String) {
            ClientUtils.webhook(logger, webhookUrl, connectTimeout, readTimeout, (String)message);
        }
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            ClientUtils.webhook(logger, webhookUrl, connectTimeout, readTimeout, objectMapper.writeValueAsString(message));
        }
        catch (JsonProcessingException e) {
            throw new AnnounceException((Throwable)e);
        }
    }

    public static void webhook(JReleaserLogger logger, String webhookUrl, int connectTimeout, int readTimeout, String message) throws AnnounceException {
        try {
            URL url = new URL(webhookUrl);
            logger.debug(RB.$((String)"webhook.connection.open", (Object[])new Object[0]));
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            logger.debug(RB.$((String)"webhook.connection.configure", (Object[])new Object[0]));
            connection.setConnectTimeout(connectTimeout * 1000);
            connection.setReadTimeout(readTimeout * 1000);
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Accept", "application/json");
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            connection.setDoOutput(true);
            logger.debug(RB.$((String)"webhook.message.send", (Object[])new Object[0]));
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = message.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            logger.debug(RB.$((String)"webhook.response.handle", (Object[])new Object[0]));
            int status = connection.getResponseCode();
            if (status >= 400) {
                String reason = connection.getResponseMessage();
                InputStreamReader reader = new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
                message = IOUtils.toString((Reader)reader);
                StringBuilder b = new StringBuilder("Webhook replied with: ").append(status);
                if (StringUtils.isNotBlank((String)reason)) {
                    b.append(" reason: ").append(reason).append(",");
                }
                if (StringUtils.isNotBlank((String)message)) {
                    b.append(message);
                }
                throw new AnnounceException(b.toString());
            }
        }
        catch (IOException e) {
            logger.trace((Throwable)e);
            throw new AnnounceException((Throwable)e);
        }
    }

    public static void postFile(JReleaserLogger logger, String url, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        headers.put("METHOD", "POST");
        ClientUtils.uploadFile(logger, url, connectTimeout, readTimeout, data, headers);
    }

    public static void putFile(JReleaserLogger logger, String url, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        headers.put("METHOD", "PUT");
        headers.put("Expect", "100-continue");
        ClientUtils.uploadFile(logger, url, connectTimeout, readTimeout, data, headers);
    }

    private static void uploadFile(JReleaserLogger logger, String url, int connectTimeout, int readTimeout, FormData data, Map<String, String> headers) throws UploadException {
        try {
            URL theUrl = new URL(url);
            logger.debug("url: {}", new Object[]{theUrl});
            logger.debug(RB.$((String)"webhook.connection.open", (Object[])new Object[0]));
            HttpURLConnection connection = (HttpURLConnection)theUrl.openConnection();
            logger.debug(RB.$((String)"webhook.connection.configure", (Object[])new Object[0]));
            connection.setConnectTimeout(connectTimeout * 1000);
            connection.setReadTimeout(readTimeout * 1000);
            connection.setAllowUserInteraction(false);
            connection.setInstanceFollowRedirects(true);
            connection.setRequestMethod(headers.remove("METHOD"));
            connection.addRequestProperty("Accept", "*/*");
            connection.addRequestProperty("User-Agent", "JReleaser/" + JReleaserVersion.getPlainVersion());
            connection.addRequestProperty("Content-Length", data.getData().length + "");
            connection.setRequestProperty("Content-Type", data.getContentType());
            headers.forEach(connection::setRequestProperty);
            connection.getRequestProperties().forEach((k, v) -> {
                if (JReleaserModelPrinter.isSecret((String)k)) {
                    logger.debug("{}: {}", new Object[]{k, "************"});
                } else {
                    logger.debug("{}: {}", new Object[]{k, v});
                }
            });
            connection.setDoOutput(true);
            logger.debug(RB.$((String)"webhook.data.send", (Object[])new Object[0]));
            try (OutputStream os = connection.getOutputStream();){
                os.write(data.getData(), 0, data.getData().length);
                os.flush();
            }
            logger.debug(RB.$((String)"webhook.response.handle", (Object[])new Object[0]));
            int status = connection.getResponseCode();
            if (status >= 400) {
                String reason = connection.getResponseMessage();
                InputStreamReader reader = new InputStreamReader(connection.getErrorStream(), StandardCharsets.UTF_8);
                String message = IOUtils.toString((Reader)reader);
                StringBuilder b = new StringBuilder("Got ").append(status);
                if (StringUtils.isNotBlank((String)reason)) {
                    b.append(" reason: ").append(reason).append(",");
                }
                if (StringUtils.isNotBlank((String)message)) {
                    b.append(message);
                }
                throw new UploadException(b.toString());
            }
        }
        catch (IOException e) {
            logger.trace((Throwable)e);
            throw new UploadException((Throwable)e);
        }
    }

    private static SSLSocketFactory nonValidatingSSLSocketFactory() {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new NonValidatingTrustManager()}, null);
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static class NonValidatingHostnameVerifier
    implements HostnameVerifier {
        private NonValidatingHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    private static class NonValidatingTrustManager
    implements X509TrustManager {
        private static final X509Certificate[] EMPTY_CERTIFICATES = new X509Certificate[0];

        private NonValidatingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_CERTIFICATES;
        }
    }
}

