/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Assembler;
import org.jreleaser.model.CommitAuthor;
import org.jreleaser.model.CommitAuthorAware;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Environment;
import org.jreleaser.model.FileSet;
import org.jreleaser.model.GitService;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.OwnerAware;
import org.jreleaser.model.Packager;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.model.TimeoutAware;
import org.jreleaser.util.Env;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

class Validator {
    Validator() {
    }

    static String checkProperty(JReleaserContext context, String key, String property, String value, Errors errors) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
    }

    static String checkProperty(JReleaserContext context, String key, String property, String value, Errors errors, boolean dryrun) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        return Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)(dryrun ? new Errors() : errors));
    }

    static String checkProperty(JReleaserContext context, String key, String property, String value, String defaultValue) {
        if (StringUtils.isNotBlank((String)value)) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : defaultValue;
    }

    static boolean checkProperty(JReleaserContext context, String key, String property, Boolean value, boolean defaultValue) {
        if (null != value) {
            return value;
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? Boolean.parseBoolean(result) : defaultValue;
    }

    static <T extends Enum<T>> String checkProperty(JReleaserContext context, String key, String property, T value, T defaultValue) {
        if (null != value) {
            return value.name();
        }
        Environment environment = context.getModel().getEnvironment();
        String dsl = context.getConfigurer().toString();
        String configFilePath = environment.getPropertiesFile().toAbsolutePath().normalize().toString();
        Errors errors = new Errors();
        String result = Env.check((String)key, (String)environment.getVariable(key), (String)property, (String)dsl, (String)configFilePath, (Errors)errors);
        return !errors.hasErrors() ? result : (null != defaultValue ? defaultValue.name() : null);
    }

    static void validateOwner(OwnerAware self, OwnerAware other) {
        if (StringUtils.isBlank((String)self.getOwner())) {
            self.setOwner(other.getOwner());
        }
    }

    static void validateContinueOnError(Packager self, Packager other) {
        if (!self.isContinueOnErrorSet()) {
            self.setContinueOnError(other.isContinueOnError());
        }
    }

    static void validateCommitAuthor(CommitAuthorAware self, CommitAuthorAware other) {
        CommitAuthor author = new CommitAuthor();
        author.setName(self.getCommitAuthor().getName());
        author.setEmail(self.getCommitAuthor().getEmail());
        if (StringUtils.isBlank((String)author.getName())) {
            author.setName(other.getCommitAuthor().getName());
        }
        if (StringUtils.isBlank((String)author.getEmail())) {
            author.setEmail(other.getCommitAuthor().getEmail());
        }
        self.setCommitAuthor(author);
    }

    static void validateTimeout(TimeoutAware self) {
        if (self.getConnectTimeout() <= 0 || self.getConnectTimeout() > 300) {
            self.setConnectTimeout(20);
        }
        if (self.getReadTimeout() <= 0 || self.getReadTimeout() > 300) {
            self.setReadTimeout(60);
        }
    }

    static void validateTap(JReleaserContext context, Distribution distribution, RepositoryTap tap, RepositoryTap parentTap, String property) {
        Validator.validateOwner(tap, parentTap);
        if (StringUtils.isBlank((String)tap.getCommitMessage()) && StringUtils.isNotBlank((String)parentTap.getCommitMessage())) {
            tap.setCommitMessage(parentTap.getCommitMessage());
        }
        if (StringUtils.isBlank((String)tap.getCommitMessage())) {
            tap.setCommitMessage("{{distributionName}} {{tagName}}");
        }
        if (StringUtils.isBlank((String)tap.getTagName()) && StringUtils.isNotBlank((String)parentTap.getTagName())) {
            tap.setTagName(parentTap.getTagName());
        }
        if (StringUtils.isBlank((String)tap.getBranch()) && StringUtils.isNotBlank((String)parentTap.getBranch())) {
            tap.setBranch(parentTap.getBranch());
        }
        if (StringUtils.isBlank((String)tap.getName()) && StringUtils.isNotBlank((String)parentTap.getName())) {
            tap.setName(parentTap.getName());
        }
        if (StringUtils.isBlank((String)tap.getUsername()) && StringUtils.isNotBlank((String)parentTap.getUsername())) {
            tap.setUsername(parentTap.getUsername());
        }
        if (StringUtils.isBlank((String)tap.getToken()) && StringUtils.isNotBlank((String)parentTap.getToken())) {
            tap.setToken(parentTap.getToken());
        }
        GitService service = context.getModel().getRelease().getGitService();
        tap.setUsername(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_USERNAME", "distribution." + distribution.getName() + "." + property + ".username", tap.getUsername(), service.getResolvedUsername()));
        tap.setToken(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_TOKEN", "distribution." + distribution.getName() + "." + property + ".token", tap.getToken(), service.getResolvedToken()));
        tap.setBranch(Validator.checkProperty(context, Env.toVar((String)(tap.getBasename() + "_" + service.getServiceName())) + "_BRANCH", "distribution." + distribution.getName() + "." + property + ".branch", tap.getBranch(), "HEAD"));
    }

    static void validateGlobs(JReleaserContext context, Collection<Glob> globs, String property, Errors errors) {
        int i = 0;
        for (Glob glob : globs) {
            if (StringUtils.isNotBlank((String)glob.getPattern())) continue;
            boolean isBaseDir = false;
            if (StringUtils.isBlank((String)glob.getDirectory())) {
                glob.setDirectory(".");
                isBaseDir = true;
            }
            boolean includeAll = false;
            if (StringUtils.isBlank((String)glob.getInclude())) {
                glob.setInclude("*");
                includeAll = true;
            }
            if (!StringUtils.isBlank((String)glob.getExclude()) || !includeAll || !isBaseDir) continue;
            errors.configuration(RB.$((String)"validation_must_define_pattern", (Object[])new Object[]{property + "[" + i + "]"}));
        }
    }

    static void validateFileSet(JReleaserContext context, JReleaserContext.Mode mode, Assembler assembler, FileSet fileSet, int index, Errors errors) {
        if (mode != JReleaserContext.Mode.ASSEMBLE) {
            return;
        }
        if (StringUtils.isBlank((String)fileSet.getInput())) {
            errors.configuration(RB.$((String)"validation_must_not_be_null", (Object[])new Object[]{assembler.getType() + "." + assembler.getName() + ".fileSet[" + index + "].input"}));
        }
    }
}

