/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.Jlink;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class JlinkResolver
extends Validator {
    public static void resolveJlinkOutputs(JReleaserContext context, Errors errors) {
        context.getLogger().debug("jlink");
        for (Jlink jlink : context.getModel().getAssemble().getActiveJlinks()) {
            if (!jlink.isExported()) continue;
            JlinkResolver.resolveJlinkOutputs(context, jlink, errors);
        }
    }

    private static void resolveJlinkOutputs(JReleaserContext context, Jlink jlink, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(jlink.getName()).resolve(jlink.getType());
        String imageName = jlink.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)jlink.getImageNameTransform())) {
            imageName = jlink.getResolvedImageNameTransform(context);
        }
        for (Artifact targetJdk : jlink.getTargetJdks()) {
            if (!context.isPlatformSelected(targetJdk)) continue;
            String platform = targetJdk.getPlatform();
            String platformReplaced = jlink.getPlatform().applyReplacements(platform);
            String str = targetJdk.getExtraProperties().getOrDefault("archiveFormat", "ZIP").toString();
            Archive.Format archiveFormat = Archive.Format.of(str);
            Path image = baseOutputDirectory.resolve(imageName + "-" + platformReplaced + "." + archiveFormat.extension()).toAbsolutePath();
            if (!Files.exists(image, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{jlink.getType(), jlink.getName(), jlink.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(image, platform);
            artifact.setExtraProperties(jlink.getExtraProperties());
            artifact.activate();
            jlink.addOutput(artifact);
        }
    }
}

