/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jreleaser.model.AbstractRepositoryPackager;
import org.jreleaser.model.AbstractRepositoryTap;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.RepositoryTap;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.FileType;
import org.jreleaser.util.PlatformUtils;
import org.jreleaser.util.StringUtils;

public class Spec
extends AbstractRepositoryPackager {
    public static final String TYPE = "spec";
    public static final String SKIP_SPEC = "skipSpec";
    private static final Map<Distribution.DistributionType, Set<String>> SUPPORTED = new LinkedHashMap<Distribution.DistributionType, Set<String>>();
    private final List<String> requires = new ArrayList<String>();
    private final SpecRepository repository = new SpecRepository();
    private String packageName;
    private String release;

    public Spec() {
        super(TYPE);
    }

    void setAll(Spec spec) {
        super.setAll(spec);
        this.packageName = spec.packageName;
        this.release = spec.release;
        this.setRepository(spec.repository);
        this.setRequires(spec.requires);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public SpecRepository getRepository() {
        return this.repository;
    }

    public void setRepository(SpecRepository repository) {
        this.repository.setAll(repository);
    }

    public List<String> getRequires() {
        return this.requires;
    }

    public void setRequires(List<String> requires) {
        this.requires.clear();
        this.requires.addAll(requires);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("packageName", this.packageName);
        props.put("release", this.release);
        props.put("requires", this.requires);
        props.put("repository", this.repository.asMap(full));
    }

    @Override
    public RepositoryTap getRepositoryTap() {
        return this.repository;
    }

    @Override
    public boolean supportsPlatform(String platform) {
        return StringUtils.isBlank((String)platform) || PlatformUtils.isLinux((String)platform) && PlatformUtils.isIntel((String)platform) && !PlatformUtils.isAlpineLinux((String)platform);
    }

    @Override
    public boolean supportsDistribution(Distribution distribution) {
        return SUPPORTED.containsKey((Object)distribution.getType());
    }

    @Override
    public Set<String> getSupportedExtensions(Distribution distribution) {
        return SUPPORTED.getOrDefault((Object)distribution.getType(), Collections.emptySet());
    }

    @Override
    protected boolean isNotSkipped(Artifact artifact) {
        return StringUtils.isFalse((Object)artifact.getExtraProperties().get(SKIP_SPEC));
    }

    static {
        Set extensions = CollectionUtils.newSet((Object[])new String[]{FileType.TAR_BZ2.extension(), FileType.TAR_GZ.extension(), FileType.TAR_XZ.extension(), FileType.TBZ2.extension(), FileType.TGZ.extension(), FileType.TXZ.extension(), FileType.TAR.extension(), FileType.ZIP.extension()});
        SUPPORTED.put(Distribution.DistributionType.BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JAVA_BINARY, extensions);
        SUPPORTED.put(Distribution.DistributionType.JLINK, extensions);
        SUPPORTED.put(Distribution.DistributionType.NATIVE_IMAGE, extensions);
    }

    public static class SpecRepository
    extends AbstractRepositoryTap {
        public SpecRepository() {
            super(Spec.TYPE, Spec.TYPE);
        }
    }
}

