/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.io.IOException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.Algorithm;

public class ChecksumUtils {
    private ChecksumUtils() {
    }

    public static String checksum(Algorithm algorithm, byte[] data) throws IOException {
        switch (algorithm) {
            case MD2: {
                return DigestUtils.md2Hex((byte[])data);
            }
            case MD5: {
                return DigestUtils.md5Hex((byte[])data);
            }
            case RMD160: {
                RIPEMD160Digest digest = new RIPEMD160Digest();
                byte[] output = new byte[digest.getDigestSize()];
                digest.update(data, 0, data.length);
                digest.doFinal(output, 0);
                return Hex.encodeHexString((byte[])output);
            }
            case SHA_1: {
                return DigestUtils.sha1Hex((byte[])data);
            }
            case SHA_256: {
                return DigestUtils.sha256Hex((byte[])data);
            }
            case SHA_384: {
                return DigestUtils.sha384Hex((byte[])data);
            }
            case SHA_512: {
                return DigestUtils.sha512Hex((byte[])data);
            }
            case SHA3_224: {
                return DigestUtils.sha3_224Hex((byte[])data);
            }
            case SHA3_256: {
                return DigestUtils.sha3_256Hex((byte[])data);
            }
            case SHA3_384: {
                return DigestUtils.sha3_384Hex((byte[])data);
            }
            case SHA3_512: {
                return DigestUtils.sha3_512Hex((byte[])data);
            }
        }
        throw new IOException(RB.$("ERROR_unsupported_algorithm", algorithm.name()));
    }
}

