/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jreleaser.model.Domain;
import org.jreleaser.model.ExtraProperties;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.util.Artifacts;

public class FileSet
implements Domain,
ExtraProperties {
    private final Map<String, Object> extraProperties = new LinkedHashMap<String, Object>();
    private final Set<String> includes = new LinkedHashSet<String>();
    private final Set<String> excludes = new LinkedHashSet<String>();
    private String input;
    private String output;

    void setAll(FileSet fileSet) {
        this.input = fileSet.input;
        this.output = fileSet.output;
        this.setIncludes(fileSet.includes);
        this.setExcludes(fileSet.excludes);
        this.setExtraProperties(fileSet.extraProperties);
    }

    @Override
    public String getPrefix() {
        return "artifact";
    }

    public String getResolvedInput(JReleaserContext context) {
        return Artifacts.resolveForFileSet(this.input, context, this);
    }

    public String getResolvedOutput(JReleaserContext context) {
        return Artifacts.resolveForFileSet(this.output, context, this);
    }

    public Set<String> getResolvedIncludes(JReleaserContext context) {
        return this.includes.stream().map(s -> Artifacts.resolveForFileSet(s, context, this)).collect(Collectors.toSet());
    }

    public Set<String> getResolvedExcludes(JReleaserContext context) {
        return this.excludes.stream().map(s -> Artifacts.resolveForFileSet(s, context, this)).collect(Collectors.toSet());
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setIncludes(Set<String> includes) {
        this.includes.clear();
        this.includes.addAll(includes);
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Set<String> excludes) {
        this.excludes.clear();
        this.excludes.addAll(excludes);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    @Override
    public Map<String, Object> getExtraProperties() {
        return this.extraProperties;
    }

    @Override
    public void setExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.clear();
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public void addExtraProperties(Map<String, Object> extraProperties) {
        this.extraProperties.putAll(extraProperties);
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("input", this.input);
        props.put("output", this.output);
        props.put("includes", this.includes);
        props.put("excludes", this.excludes);
        props.put("extraProperties", this.getResolvedExtraProperties());
        return props;
    }
}

