/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.Map;
import org.jreleaser.model.AbstractAssembler;
import org.jreleaser.model.Java;
import org.jreleaser.model.JavaAssembler;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;
import org.jreleaser.util.Version;

abstract class AbstractJavaAssembler
extends AbstractAssembler
implements JavaAssembler {
    private final Java java = new Java();
    protected String executable;
    protected String templateDirectory;

    protected AbstractJavaAssembler(String type) {
        super(type);
    }

    void setAll(AbstractJavaAssembler assembler) {
        super.setAll(assembler);
        this.executable = assembler.executable;
        this.templateDirectory = assembler.templateDirectory;
        this.setJava(assembler.java);
    }

    @Override
    public Map<String, Object> props() {
        Map<String, Object> props = super.props();
        props.put("distributionExecutable", this.executable);
        props.putAll(this.java.getResolvedExtraProperties());
        CollectionUtils.safePut((String)"distributionJavaGroupId", (Object)this.java.getGroupId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaArtifactId", (Object)this.java.getArtifactId(), props, (boolean)true);
        CollectionUtils.safePut((String)"distributionJavaMainClass", (Object)this.java.getMainClass(), props, (boolean)true);
        if (StringUtils.isNotBlank((String)this.java.getVersion())) {
            props.put("distributionJavaVersion", this.java.getVersion());
            Version jv = Version.of((String)this.java.getVersion());
            CollectionUtils.safePut((String)"distributionJavaVersionMajor", (Object)jv.getMajor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionMinor", (Object)jv.getMinor(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionPatch", (Object)jv.getPatch(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionTag", (Object)jv.getTag(), props, (boolean)true);
            CollectionUtils.safePut((String)"distributionJavaVersionBuild", (Object)jv.getBuild(), props, (boolean)true);
        } else {
            props.put("distributionJavaVersion", "");
            props.put("distributionJavaVersionMajor", "");
            props.put("distributionJavaVersionMinor", "");
            props.put("distributionJavaVersionPatch", "");
            props.put("distributionJavaVersionTag", "");
            props.put("distributionJavaVersionBuild", "");
        }
        return props;
    }

    @Override
    public String getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(String executable) {
        this.executable = executable;
    }

    @Override
    public String getTemplateDirectory() {
        return this.templateDirectory;
    }

    @Override
    public void setTemplateDirectory(String templateDirectory) {
        this.templateDirectory = templateDirectory;
    }

    @Override
    public Java getJava() {
        return this.java;
    }

    @Override
    public void setJava(Java java) {
        this.java.setAll(java);
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        props.put("executable", this.executable);
        props.put("templateDirectory", this.templateDirectory);
        props.put("extraProperties", this.getResolvedExtraProperties());
        if (this.java.isEnabled()) {
            props.put("java", this.java.asMap(full));
        }
    }
}

