/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.engine.distribution;

import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserException;
import org.jreleaser.model.Tool;
import org.jreleaser.model.tool.spi.ToolProcessor;
import org.jreleaser.model.tool.spi.ToolProcessorFactory;

public class ToolProcessors {
    public static <T extends Tool> ToolProcessor<T> findProcessor(JReleaserContext context, T tool) {
        Map<String, ToolProcessor> processors = StreamSupport.stream(ServiceLoader.load(ToolProcessorFactory.class, ToolProcessors.class.getClassLoader()).spliterator(), false).collect(Collectors.toMap(ToolProcessorFactory::getName, factory -> factory.getToolProcessor(context)));
        if (processors.containsKey(tool.getName())) {
            ToolProcessor toolProcessor = processors.get(tool.getName());
            toolProcessor.setTool(tool);
            return toolProcessor;
        }
        throw new JReleaserException(RB.$((String)"ERROR_unsupported_tool", (Object[])new Object[]{tool.getName()}));
    }
}

