/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.cli;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jreleaser.cli.AbstractPlatformAwareModelCommand;
import org.jreleaser.cli.HaltExecutionException;
import org.jreleaser.engine.context.ModelAutoConfigurer;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.UpdateSection;
import org.jreleaser.workflow.Workflows;
import picocli.CommandLine;

@CommandLine.Command(name="release")
public class Release
extends AbstractPlatformAwareModelCommand {
    @CommandLine.Option(names={"-y", "--dryrun"})
    boolean dryrun;
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..1", headingKey="auto-config.header")
    AutoConfigGroup autoConfigGroup;

    @Override
    protected void execute() {
        if (null == this.autoConfigGroup || !this.autoConfigGroup.autoConfig) {
            super.execute();
            return;
        }
        this.basedir();
        this.initLogger();
        JReleaserContext context = ModelAutoConfigurer.builder().logger(this.logger).basedir(this.actualBasedir).outputDirectory(this.getOutputDirectory()).dryrun(this.dryrun()).gitRootSearch(this.gitRootSearch).projectName(this.autoConfigGroup.projectName).projectVersion(this.autoConfigGroup.projectVersion).projectVersionPattern(this.autoConfigGroup.projectVersionPattern).projectSnapshotPattern(this.autoConfigGroup.projectSnapshotPattern).projectSnapshotLabel(this.autoConfigGroup.projectSnapshotLabel).projectSnapshotFullChangelog(this.autoConfigGroup.projectSnapshotFullChangelog).tagName(this.autoConfigGroup.tagName).previousTagName(this.autoConfigGroup.previousTagName).releaseName(this.autoConfigGroup.releaseName).milestoneName(this.autoConfigGroup.milestoneName).branch(this.autoConfigGroup.branch).prerelease(this.autoConfigGroup.prerelease).prereleasePattern(this.autoConfigGroup.prereleasePattern).draft(this.autoConfigGroup.draft).overwrite(this.autoConfigGroup.overwrite).update(this.autoConfigGroup.update).updateSections(this.collectUpdateSections()).skipTag(this.autoConfigGroup.skipTag).skipRelease(this.autoConfigGroup.skipRelease).changelog(this.autoConfigGroup.changelog).changelogFormatted(this.autoConfigGroup.changelogFormatted).username(this.autoConfigGroup.username).commitAuthorName(this.autoConfigGroup.commitAuthorName).commitAuthorEmail(this.autoConfigGroup.commitAuthorEmail).signing(this.autoConfigGroup.signing).armored(this.autoConfigGroup.armored).files(this.collectFiles()).globs(this.collectGlobs()).selectedPlatforms(this.collectSelectedPlatforms()).autoConfigure();
        this.doExecute(context);
    }

    private List<String> collectFiles() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.autoConfigGroup.files != null && this.autoConfigGroup.files.length > 0) {
            Collections.addAll(list, this.autoConfigGroup.files);
        }
        return list;
    }

    private List<String> collectGlobs() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.autoConfigGroup.globs != null && this.autoConfigGroup.globs.length > 0) {
            Collections.addAll(list, this.autoConfigGroup.globs);
        }
        return list;
    }

    private Set<UpdateSection> collectUpdateSections() {
        LinkedHashSet<UpdateSection> set = new LinkedHashSet<UpdateSection>();
        if (this.autoConfigGroup.updateSections != null && this.autoConfigGroup.updateSections.length > 0) {
            for (String updateSection : this.autoConfigGroup.updateSections) {
                set.add(UpdateSection.of((String)updateSection.trim()));
            }
        }
        return set;
    }

    private void basedir() {
        Path path = this.actualBasedir = null != this.basedir ? this.basedir : Paths.get(".", new String[0]).normalize();
        if (!Files.exists(this.actualBasedir, new LinkOption[0])) {
            throw this.halt(String.format(this.bundle.getString("ERROR_missing_required_option"), "--basedir=<basedir>"));
        }
    }

    @Override
    protected void doExecute(JReleaserContext context) {
        Workflows.release((JReleaserContext)context).execute();
    }

    @Override
    protected boolean dryrun() {
        return this.dryrun;
    }

    private HaltExecutionException halt(String message) throws HaltExecutionException {
        this.spec.commandLine().getErr().println(this.spec.commandLine().getColorScheme().errorText(message));
        this.spec.commandLine().usage(this.parent.out);
        throw new HaltExecutionException();
    }

    static class AutoConfigGroup {
        @CommandLine.Option(names={"--auto-config"})
        boolean autoConfig;
        @CommandLine.Option(names={"--project-name"})
        String projectName;
        @CommandLine.Option(names={"--project-version"})
        String projectVersion;
        @CommandLine.Option(names={"--project-version-pattern"})
        String projectVersionPattern;
        @CommandLine.Option(names={"--project-snapshot-pattern"})
        String projectSnapshotPattern;
        @CommandLine.Option(names={"--project-snapshot-label"})
        String projectSnapshotLabel;
        @CommandLine.Option(names={"--project-snapshot-full-changelog"})
        boolean projectSnapshotFullChangelog;
        @CommandLine.Option(names={"--tag-name"})
        String tagName;
        @CommandLine.Option(names={"--previous-tag-name"})
        String previousTagName;
        @CommandLine.Option(names={"--release-name"})
        String releaseName;
        @CommandLine.Option(names={"--milestone-name"})
        String milestoneName;
        @CommandLine.Option(names={"--prerelease"})
        boolean prerelease;
        @CommandLine.Option(names={"--prerelease-pattern"})
        String prereleasePattern;
        @CommandLine.Option(names={"--draft"})
        boolean draft;
        @CommandLine.Option(names={"--overwrite"})
        boolean overwrite;
        @CommandLine.Option(names={"--update"})
        boolean update;
        @CommandLine.Option(names={"--update-section"}, paramLabel="<section>")
        String[] updateSections;
        @CommandLine.Option(names={"--skip-tag"})
        boolean skipTag;
        @CommandLine.Option(names={"--skip-release"})
        boolean skipRelease;
        @CommandLine.Option(names={"--branch"})
        String branch;
        @CommandLine.Option(names={"--changelog"})
        String changelog;
        @CommandLine.Option(names={"--changelog-formatted"})
        boolean changelogFormatted;
        @CommandLine.Option(names={"--username"})
        String username;
        @CommandLine.Option(names={"--commit-author-name"})
        String commitAuthorName;
        @CommandLine.Option(names={"--commit-author-email"})
        String commitAuthorEmail;
        @CommandLine.Option(names={"--signing-enabled"})
        boolean signing;
        @CommandLine.Option(names={"--signing-armored"})
        boolean armored;
        @CommandLine.Option(names={"--file"}, paramLabel="<file>")
        String[] files;
        @CommandLine.Option(names={"--glob"}, paramLabel="<glob>")
        String[] globs;

        AutoConfigGroup() {
        }
    }
}

