/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.exceptions.MarkedVerificationException;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.plugins.quality.TargetJdk;
import org.gradle.api.plugins.quality.internal.PmdActionParameters;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.util.internal.GUtil;
import org.gradle.util.internal.VersionNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PmdInvoker
implements Action<AntBuilderDelegate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PmdInvoker.class);
    private static final List<String> BASIC = ImmutableList.of((Object)"basic");
    private static final List<String> JAVA_BASIC = ImmutableList.of((Object)"java-basic");
    private static final List<String> ERROR_PRONE = ImmutableList.of((Object)"category/java/errorprone.xml");
    private final PmdActionParameters parameters;

    PmdInvoker(PmdActionParameters parameters) {
        this.parameters = parameters;
    }

    public void execute(AntBuilderDelegate ant) {
        FileCollection pmdClasspath = this.parameters.getPmdClasspath().filter((Spec)new FileExistFilter());
        if (((Boolean)this.parameters.getIncrementalAnalysis().get()).booleanValue()) {
            SystemProperties.getInstance().withSystemProperty("java.class.path", GUtil.asPath((Iterable)pmdClasspath), () -> {
                PmdInvoker.runPmd(ant, this.parameters);
                return null;
            });
        } else {
            PmdInvoker.runPmd(ant, this.parameters);
        }
    }

    private static void runPmd(AntBuilderDelegate ant, PmdActionParameters parameters) {
        int maxFailures;
        VersionNumber version = PmdInvoker.determinePmdVersion(Thread.currentThread().getContextClassLoader());
        HashMap<String, Object> antPmdArgs = new HashMap<String, Object>((Map<String, Object>)ImmutableMap.builder().put((Object)"failOnRuleViolation", (Object)false).put((Object)"failuresPropertyName", (Object)"pmdFailureCount").put((Object)"minimumPriority", parameters.getRulesMinimumPriority().get()).build());
        List<String> ruleSets = (List<String>)parameters.getRuleSets().get();
        String htmlFormat = "html";
        if (version.compareTo(VersionNumber.parse((String)"5.0.0")) < 0) {
            antPmdArgs.put("targetjdk", ((TargetJdk)((Object)parameters.getTargetJdk().get())).getName());
            htmlFormat = "betterhtml";
            if (ruleSets.equals(JAVA_BASIC) || ruleSets.equals(ERROR_PRONE)) {
                ruleSets = BASIC;
            }
            if (((Boolean)parameters.getIncrementalAnalysis().get()).booleanValue()) {
                PmdInvoker.assertUnsupportedIncrementalAnalysis(version);
            }
        } else if (version.compareTo(VersionNumber.parse((String)"6.0.0")) < 0) {
            if (ruleSets.equals(ERROR_PRONE)) {
                ruleSets = JAVA_BASIC;
            }
            if (((Boolean)parameters.getIncrementalAnalysis().get()).booleanValue()) {
                PmdInvoker.assertUnsupportedIncrementalAnalysis(version);
            }
            antPmdArgs.put("threads", parameters.getThreads().get());
        } else {
            if (((Boolean)parameters.getIncrementalAnalysis().get()).booleanValue()) {
                antPmdArgs.put("cacheLocation", ((RegularFile)parameters.getIncrementalCacheFile().get()).getAsFile());
            } else if (version.compareTo(VersionNumber.parse((String)"6.2.0")) >= 0) {
                antPmdArgs.put("noCache", true);
            }
            antPmdArgs.put("threads", parameters.getThreads().get());
        }
        if ((maxFailures = ((Integer)parameters.getMaxFailures().get()).intValue()) < 0) {
            throw new GradleException(String.format("Invalid maxFailures %s. Valid range is >= 0.", maxFailures));
        }
        String finalHtmlFormat = htmlFormat;
        List<String> finalRuleSets = ruleSets;
        List reports = (List)parameters.getEnabledReports().get();
        ant.taskdef((Map)ImmutableMap.of((Object)"name", (Object)"pmd", (Object)"classname", (Object)"net.sourceforge.pmd.ant.PMDTask"));
        ant.invokeMethod("pmd", antPmdArgs, () -> {
            parameters.getSource().addToAntBuilder((Object)ant, "fileset", FileCollection.AntType.FileSet);
            finalRuleSets.forEach(rule -> ant.invokeMethod("ruleset", rule));
            parameters.getRuleSetConfigFiles().forEach(ruleSetConfig -> ant.invokeMethod("ruleset", ruleSetConfig));
            FileCollection auxClasspath = parameters.getAuxClasspath().filter((Spec)new FileExistFilter());
            if (!auxClasspath.isEmpty()) {
                auxClasspath.addToAntBuilder((Object)ant, "auxclasspath", FileCollection.AntType.ResourceCollection);
            }
            reports.forEach(report -> {
                File file = (File)report.getOutputLocation().getAsFile().get();
                Preconditions.checkArgument((boolean)file.getParentFile().exists(), (Object)("Parent directory of report file '" + file + "' does not exist."));
                String type = ((String)report.getName().get()).equals("html") ? finalHtmlFormat : (String)report.getName().get();
                ant.invokeMethod("formatter", (Object)ImmutableMap.of((Object)"type", (Object)type, (Object)"toFile", (Object)file));
            });
            if (((Boolean)parameters.getConsoleOutput().get()).booleanValue()) {
                String consoleOutputType = "text";
                if (((Boolean)parameters.getStdOutIsAttachedToTerminal().get()).booleanValue()) {
                    consoleOutputType = "textcolor";
                }
                PmdInvoker.disableSaveStreams(ant);
                ant.invokeMethod("formatter", (Object)ImmutableMap.of((Object)"type", (Object)consoleOutputType, (Object)"toConsole", (Object)true));
            }
        });
        String failureCount = (String)ant.getProjectProperties().get("pmdFailureCount");
        if (failureCount != null) {
            PmdActionParameters.EnabledReport report;
            String message = String.format("%s PMD rule violations were found.", failureCount);
            PmdActionParameters.EnabledReport enabledReport = report = reports.isEmpty() ? null : (PmdActionParameters.EnabledReport)reports.get(0);
            if (report != null) {
                String reportUrl = new ConsoleRenderer().asClickableFileUrl((File)report.getOutputLocation().getAsFile().get());
                message = message + " See the report at: " + reportUrl;
            }
            if (((Boolean)parameters.getIgnoreFailures().get()).booleanValue() || Integer.parseInt(failureCount) <= maxFailures) {
                LOGGER.warn(message);
            } else {
                throw new MarkedVerificationException(message);
            }
        }
    }

    private static void disableSaveStreams(AntBuilderDelegate ant) {
        try {
            ant.getBuilder().getClass().getMethod("setSaveStreams", Boolean.TYPE).invoke(ant.getBuilder(), false);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static VersionNumber determinePmdVersion(ClassLoader antLoader) {
        Class<?> pmdVersion;
        try {
            pmdVersion = antLoader.loadClass("net.sourceforge.pmd.PMDVersion");
        }
        catch (ClassNotFoundException e) {
            try {
                pmdVersion = antLoader.loadClass("net.sourceforge.pmd.PMD");
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
        }
        try {
            Field versionField = pmdVersion.getDeclaredField("VERSION");
            return VersionNumber.parse((String)((String)Cast.castNullable(String.class, (Object)versionField.get(null))));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static void assertUnsupportedIncrementalAnalysis(VersionNumber version) {
        throw new GradleException("Incremental analysis only supports PMD 6.0.0 and newer. Please upgrade from PMD " + version + " or disable incremental analysis.");
    }

    private static class FileExistFilter
    implements Spec<File> {
        private FileExistFilter() {
        }

        public boolean isSatisfiedBy(File element) {
            return element.exists();
        }
    }
}

