/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class EncodedStream {
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static class EncodedOutput
    extends OutputStream {
        private final OutputStream delegate;

        public EncodedOutput(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(HEX_DIGIT[b >> 4 & 0xF]);
            this.delegate.write(HEX_DIGIT[b & 0xF]);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static class EncodedInput
    extends InputStream {
        private final InputStream delegate;

        public EncodedInput(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            int byte1 = this.delegate.read();
            if (byte1 < 0) {
                return -1;
            }
            int byte2 = this.delegate.read();
            if (byte2 < 0) {
                throw new IOException("Unable to decode, expected 2 bytes but received only 1 byte. It seems the stream was not encoded correctly.");
            }
            return EncodedInput.hexToByte(byte1) << 4 | EncodedInput.hexToByte(byte2);
        }

        public static int hexToByte(int s) throws IOException {
            if (s >= 48 && s <= 57) {
                return s - 48;
            }
            if (s >= 97 && s <= 102) {
                return s - 97 + 10;
            }
            throw new IOException(String.format("Unexpected value %s received. It seems the stream was not encoded correctly.", s));
        }
    }
}

