/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.buildconfiguration.tasks;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.jvm.inspection.JvmVendor;
import org.gradle.internal.util.PropertiesUtils;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.util.internal.GFileUtils;

public class UpdateDaemonJvmModifier {
    public static void updateJvmCriteria(File propertiesFile, JavaVersion toolchainVersion, @Nullable JvmVendor toolchainVendor, @Nullable JvmImplementation toolchainImplementation) {
        UpdateDaemonJvmModifier.validateToolchainVersion(toolchainVersion);
        Properties daemonJvmProperties = new Properties();
        daemonJvmProperties.put("toolchainVersion", toolchainVersion.getMajorVersion());
        if (toolchainVendor != null) {
            daemonJvmProperties.put("toolchainVendor", toolchainVendor.getKnownVendor().name());
        }
        if (toolchainImplementation != null) {
            daemonJvmProperties.put("toolchainImplementation", toolchainImplementation.toString());
        }
        GFileUtils.parentMkdirs((File)propertiesFile);
        try {
            PropertiesUtils.store((Properties)daemonJvmProperties, (File)propertiesFile, (String)"This file is generated by updateDaemonJvm");
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private static void validateToolchainVersion(JavaVersion version) {
        JavaVersion minimumSupportedVersion = JavaVersion.VERSION_1_8;
        if (version.compareTo((Enum)minimumSupportedVersion) < 0) {
            String exceptionMessage = String.format("Unsupported Java version '%s' provided for the 'jvm-version' option. Gradle can only run with Java %s and above.", version.getMajorVersion(), minimumSupportedVersion.getMajorVersion());
            throw new IllegalArgumentException(exceptionMessage);
        }
    }
}

