/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.toolchain;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.Predicate;
import org.gradle.api.GradleException;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JavaInstallationRegistry;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadataComparator;
import org.gradle.internal.jvm.inspection.JvmToolchainMetadata;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.jvm.toolchain.internal.JvmInstallationMetadataMatcher;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;

public class DaemonJavaToolchainQueryService {
    private final JavaInstallationRegistry javaInstallationRegistry;
    private final File currentJavaHome;

    public DaemonJavaToolchainQueryService(JavaInstallationRegistry javaInstallationRegistry) {
        this(javaInstallationRegistry, Jvm.current().getJavaHome());
    }

    @VisibleForTesting
    public DaemonJavaToolchainQueryService(JavaInstallationRegistry javaInstallationRegistry, File currentJavaHome) {
        this.javaInstallationRegistry = javaInstallationRegistry;
        this.currentJavaHome = currentJavaHome;
    }

    public JvmInstallationMetadata findMatchingToolchain(DaemonJvmCriteria.Spec toolchainSpec) throws GradleException {
        Optional<JvmToolchainMetadata> installation = this.locateToolchain(toolchainSpec);
        if (!installation.isPresent()) {
            String exceptionMessage = String.format("Cannot find a Java installation on your machine (%s) matching the Daemon JVM defined requirements: %s.", OperatingSystem.current(), toolchainSpec);
            throw new GradleException(exceptionMessage);
        }
        return installation.get().metadata;
    }

    private Optional<JvmToolchainMetadata> locateToolchain(DaemonJvmCriteria.Spec toolchainSpec) {
        JvmInstallationMetadataMatcher matcher = new JvmInstallationMetadataMatcher(toolchainSpec.getJavaVersion(), toolchainSpec.getVendorSpec(), toolchainSpec.getJvmImplementation());
        JvmInstallationMetadataComparator metadataComparator = new JvmInstallationMetadataComparator(this.currentJavaHome);
        return this.javaInstallationRegistry.toolchains().stream().filter(result -> result.metadata.isValidInstallation()).filter(arg_0 -> DaemonJavaToolchainQueryService.lambda$locateToolchain$1((Predicate)matcher, arg_0)).min(Comparator.comparing(result -> result.metadata, metadataComparator));
    }

    private static /* synthetic */ boolean lambda$locateToolchain$1(Predicate matcher, JvmToolchainMetadata result) {
        return matcher.test(result.metadata);
    }
}

