/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.daemon.client.DaemonClientServices;
import org.gradle.launcher.daemon.client.SingleUseDaemonClientServices;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.toolchain.DaemonJvmCriteria;

@ServiceScope(value={Scope.Global.class})
public class DaemonClientFactory {
    private final ServiceRegistry sharedServices;

    public DaemonClientFactory(ServiceRegistry sharedServices) {
        this.sharedServices = sharedServices;
    }

    public ServiceRegistry createBuildClientServices(ServiceLookup clientLoggingServices, DaemonParameters daemonParameters, DaemonRequestContext requestContext, InputStream stdin) {
        DefaultServiceRegistry loggingServices = this.createLoggingServices(clientLoggingServices);
        return new DaemonClientServices((ServiceRegistry)loggingServices, daemonParameters, requestContext, stdin);
    }

    public ServiceRegistry createSingleUseDaemonClientServices(ServiceLookup clientLoggingServices, DaemonParameters daemonParameters, DaemonRequestContext requestContext, InputStream stdin) {
        DefaultServiceRegistry loggingServices = this.createLoggingServices(clientLoggingServices);
        return new SingleUseDaemonClientServices((ServiceRegistry)loggingServices, daemonParameters, requestContext, stdin);
    }

    private DefaultServiceRegistry createLoggingServices(ServiceLookup clientLoggingServices) {
        DefaultServiceRegistry loggingServices = new DefaultServiceRegistry(new ServiceRegistry[]{this.sharedServices});
        loggingServices.add(OutputEventListener.class, clientLoggingServices.get(OutputEventListener.class));
        loggingServices.add(GlobalUserInputReceiver.class, clientLoggingServices.get(GlobalUserInputReceiver.class));
        return loggingServices;
    }

    public ServiceRegistry createMessageDaemonServices(ServiceLookup clientLoggingServices, DaemonParameters daemonParameters) {
        return this.createBuildClientServices(clientLoggingServices, daemonParameters, new DaemonRequestContext(new DaemonJvmCriteria.LauncherJvm(), Collections.emptyList(), false, NativeServices.NativeServicesMode.NOT_SET, DaemonParameters.Priority.NORMAL), new ByteArrayInputStream(new byte[0]));
    }
}

