/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.extensions.impl;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.components.ComponentManager;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.LoadingOrder;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginAware;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.PluginDescriptor;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import org.jetbrains.kotlin.com.intellij.openapi.extensions.impl.ImplementationClassResolver;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.kotlin.com.intellij.util.XmlElement;
import org.jetbrains.kotlin.com.intellij.util.xmlb.XmlSerializer;

class XmlExtensionAdapter
extends ExtensionComponentAdapter {
    @Nullable
    private XmlElement extensionElement;
    private static final Object NOT_APPLICABLE = new Object();
    private volatile Object extensionInstance;
    private boolean initializing;

    XmlExtensionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable XmlElement extensionElement, @NotNull ImplementationClassResolver implementationClassResolver) {
        if (implementationClassName == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(0);
        }
        if (pluginDescriptor == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(1);
        }
        if (order == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(2);
        }
        if (implementationClassResolver == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(3);
        }
        super(implementationClassName, pluginDescriptor, orderId, order, implementationClassResolver);
        this.extensionElement = extensionElement;
    }

    @Override
    final synchronized boolean isInstanceCreated() {
        return this.extensionInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T createInstance(@NotNull ComponentManager componentManager) {
        Object instance2;
        if (componentManager == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(4);
        }
        if ((instance2 = this.extensionInstance) != null) {
            Object object;
            if (instance2 == NOT_APPLICABLE) {
                object = null;
                return (T)object;
            }
            object = instance2;
            return (T)object;
        }
        XmlExtensionAdapter xmlExtensionAdapter = this;
        synchronized (xmlExtensionAdapter) {
            instance2 = this.extensionInstance;
            if (instance2 != null) {
                return (T)(instance2 == NOT_APPLICABLE ? null : instance2);
            }
            if (this.initializing) {
                throw componentManager.createError("Cyclic extension initialization: " + this, this.pluginDescriptor.getPluginId());
            }
            try {
                XmlElement element;
                this.initializing = true;
                Class<?> aClass = this.implementationClassResolver.resolveImplementationClass(componentManager, this);
                instance2 = this.instantiateClass(aClass, componentManager);
                if (instance2 instanceof PluginAware) {
                    ((PluginAware)instance2).setPluginDescriptor(this.pluginDescriptor);
                }
                if ((element = this.extensionElement) != null) {
                    XmlSerializer.getBeanBinding(instance2.getClass()).deserializeInto(instance2, element);
                    this.extensionElement = null;
                }
                this.extensionInstance = instance2;
            }
            catch (ExtensionNotApplicableException e) {
                this.extensionInstance = NOT_APPLICABLE;
                this.extensionElement = null;
                T t = null;
                return t;
            }
            catch (ProcessCanceledException e) {
                throw e;
                catch (Throwable e2) {
                    throw componentManager.createError("Cannot create extension (class=" + this.getAssignableToClassName() + ")", e2, this.pluginDescriptor.getPluginId(), null);
                }
            }
            finally {
                this.initializing = false;
            }
            return (T)instance2;
        }
    }

    @NotNull
    protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
        if (aClass == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(5);
        }
        if (componentManager == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(6);
        }
        T t = componentManager.instantiateClass(aClass, this.pluginDescriptor.getPluginId());
        if (t == null) {
            XmlExtensionAdapter.$$$reportNull$$$0(7);
        }
        return t;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementationClassResolver";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/XmlExtensionAdapter";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "instantiateClass";
                break;
            }
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    static final class SimpleConstructorInjectionAdapter
    extends XmlExtensionAdapter {
        SimpleConstructorInjectionAdapter(@NotNull String implementationClassName, @NotNull PluginDescriptor pluginDescriptor, @Nullable String orderId, @NotNull LoadingOrder order, @Nullable XmlElement extensionElement, @NotNull ImplementationClassResolver implementationClassResolver) {
            if (implementationClassName == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(1);
            }
            if (order == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(2);
            }
            if (implementationClassResolver == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(3);
            }
            super(implementationClassName, pluginDescriptor, orderId, order, extensionElement, implementationClassResolver);
        }

        @Override
        @NotNull
        protected <T> T instantiateClass(@NotNull Class<T> aClass, @NotNull ComponentManager componentManager) {
            if (aClass == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(4);
            }
            if (componentManager == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(5);
            }
            if (!aClass.getName().equals("org.jetbrains.kotlin.asJava.finder.JavaElementFinder")) {
                T t;
                try {
                    t = super.instantiateClass(aClass, componentManager);
                }
                catch (ExtensionNotApplicableException | ProcessCanceledException e) {
                    throw e;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (!(cause instanceof NoSuchMethodException) && !(cause instanceof IllegalArgumentException)) {
                        throw e;
                    }
                    ExtensionPointImpl.LOG.error("Cannot create extension without pico container (class=" + aClass.getName() + ", constructors=" + Arrays.toString(aClass.getDeclaredConstructors()) + "), please remove extra constructor parameters", e);
                }
                if (t == null) {
                    SimpleConstructorInjectionAdapter.$$$reportNull$$$0(6);
                }
                return t;
            }
            T t = componentManager.instantiateClassWithConstructorInjection(aClass, aClass, this.pluginDescriptor.getPluginId());
            if (t == null) {
                SimpleConstructorInjectionAdapter.$$$reportNull$$$0(7);
            }
            return t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClassName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "order";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implementationClassResolver";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentManager";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/com/intellij/openapi/extensions/impl/XmlExtensionAdapter$SimpleConstructorInjectionAdapter";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "instantiateClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "instantiateClass";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

