/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm;

import org.gradle.internal.jvm.Jvm;
import org.gradle.util.GradleVersion;

public class UnsupportedJavaRuntimeException
extends RuntimeException {
    public UnsupportedJavaRuntimeException(String message) {
        super(message);
    }

    public static void assertUsingVersion(String component, int minVersion) throws UnsupportedJavaRuntimeException {
        Integer current = Jvm.current().getJavaVersionMajor();
        if (current == null || current >= minVersion) {
            return;
        }
        throw new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. You are currently using Java %s.", component, GradleVersion.current().getVersion(), minVersion, current));
    }

    public static void assertUsingVersion(String component, int minVersion, int configuredVersion) throws UnsupportedJavaRuntimeException {
        if (configuredVersion >= minVersion) {
            return;
        }
        throw new UnsupportedJavaRuntimeException(String.format("%s %s requires Java %s or later to run. Your build is currently configured to use Java %s.", component, GradleVersion.current().getVersion(), minVersion, configuredVersion));
    }
}

