/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.gradle.api.NonNullApi;
import org.gradle.internal.build.event.types.DefaultInternalProblemAggregation;
import org.gradle.internal.build.event.types.DefaultInternalProblemContextDetails;
import org.gradle.internal.build.event.types.DefaultProblemAggregationDetails;
import org.gradle.internal.build.event.types.DefaultProblemDescriptor;
import org.gradle.internal.build.event.types.DefaultProblemEvent;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.internal.protocol.InternalProblemAggregationVersion2;
import org.gradle.tooling.internal.protocol.InternalProblemDetails;
import org.gradle.tooling.internal.protocol.InternalProblemEvent;
import org.gradle.tooling.internal.protocol.events.InternalProblemDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.protocol.problem.InternalBasicProblemDetails;
import org.gradle.tooling.internal.protocol.problem.InternalBasicProblemDetailsVersion2;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

@NonNullApi
public class AggregatingProblemConsumer {
    private final Multimap<String, InternalProblemEvent> seenProblems = ArrayListMultimap.create();
    private final ProgressEventConsumer progressEventConsumer;
    private final Supplier<OperationIdentifier> operationIdentifierSupplier;
    private int thresholdForIntermediateSummary = 10000;

    AggregatingProblemConsumer(ProgressEventConsumer progressEventConsumer, Supplier<OperationIdentifier> operationIdentifierSupplier) {
        this.progressEventConsumer = progressEventConsumer;
        this.operationIdentifierSupplier = operationIdentifierSupplier;
    }

    void setThresholdForIntermediateSummary(int thresholdForIntermediateSummary) {
        this.thresholdForIntermediateSummary = thresholdForIntermediateSummary;
    }

    void sendProblemSummaries() {
        List<InternalProblemAggregationVersion2> problemSummaries = this.createSummaries();
        if (problemSummaries.isEmpty()) {
            this.seenProblems.clear();
            return;
        }
        problemSummaries.forEach(summary -> {
            List problemContextDetails = summary.getProblemContextDetails();
            this.progressEventConsumer.progress((InternalProgressEvent)new DefaultProblemEvent((InternalProblemDescriptor)new DefaultProblemDescriptor(this.operationIdentifierSupplier.get(), CurrentBuildOperationRef.instance().getId()), (InternalProblemDetails)new DefaultProblemAggregationDetails(summary.getLabel(), summary.getCategory(), summary.getSeverity(), summary.getDocumentationLink(), (List)problemContextDetails.stream().skip(1L).collect(ImmutableList.toImmutableList()))));
        });
        this.seenProblems.clear();
    }

    private List<InternalProblemAggregationVersion2> createSummaries() {
        return (List)this.seenProblems.asMap().values().stream().map(ImmutableList::copyOf).filter(values -> values.size() > 1).map(AggregatingProblemConsumer::createProblemAggregation).collect(ImmutableList.toImmutableList());
    }

    private static DefaultInternalProblemAggregation createProblemAggregation(List<InternalProblemEvent> aggregatedEvents) {
        InternalBasicProblemDetails firstProblem = (InternalBasicProblemDetails)aggregatedEvents.iterator().next().getDetails();
        List aggregatedContextDetails = (List)aggregatedEvents.stream().map(event -> {
            InternalBasicProblemDetailsVersion2 details = (InternalBasicProblemDetailsVersion2)event.getDetails();
            return new DefaultInternalProblemContextDetails(details.getAdditionalData(), details.getDetails(), details.getLocations(), details.getSolutions(), details.getFailure());
        }).collect(ImmutableList.toImmutableList());
        return new DefaultInternalProblemAggregation(firstProblem.getCategory(), firstProblem.getLabel(), firstProblem.getSeverity(), firstProblem.getDocumentationLink(), aggregatedContextDetails);
    }

    void emit(InternalProblemEvent problem) {
        InternalProblemDetails details = problem.getDetails();
        if (!(details instanceof InternalBasicProblemDetails)) {
            return;
        }
        InternalBasicProblemDetails basicDetails = (InternalBasicProblemDetails)details;
        String aggregationKey = basicDetails.getCategory().getCategory() + ";" + basicDetails.getLabel().getLabel();
        this.sendProgress(problem, aggregationKey);
        if (this.seenProblems.size() > this.thresholdForIntermediateSummary) {
            this.sendProblemSummaries();
        }
    }

    private void sendProgress(InternalProblemEvent problem, String aggregationKey) {
        Collection seenProblem = this.seenProblems.get((Object)aggregationKey);
        if (seenProblem.isEmpty()) {
            this.seenProblems.put((Object)aggregationKey, (Object)problem);
            this.progressEventConsumer.progress((InternalProgressEvent)problem);
        } else {
            seenProblem.add(problem);
        }
    }
}

