/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.TaskDependencyUtil;
import org.gradle.api.tasks.TaskDependency;

public interface WorkDependencyResolver<T> {
    public static final WorkDependencyResolver<Task> TASK_AS_TASK = new WorkDependencyResolver<Task>(){

        @Override
        public boolean resolve(Task originalTask, Object node, Action<? super Task> resolveAction) {
            if (node instanceof TaskDependency) {
                TaskDependency taskDependency = (TaskDependency)node;
                Set<? extends Task> dependenciesForInternalUse = TaskDependencyUtil.getDependenciesForInternalUse(taskDependency, originalTask);
                for (Task task : dependenciesForInternalUse) {
                    resolveAction.execute((Object)task);
                }
                return true;
            }
            if (node instanceof Task) {
                resolveAction.execute((Object)((Task)node));
                return true;
            }
            return false;
        }
    };

    public boolean resolve(Task var1, Object var2, Action<? super T> var3);
}

