/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util.internal;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.OptionalInt;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.gradle.internal.IoActions;

public class JarUtil {
    public static final String MULTI_RELEASE_ATTRIBUTE = "Multi-Release";
    private static final Pattern VERSIONED_JAR_ENTRY_PATH = Pattern.compile("^META-INF/versions/(\\d+)/.+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean extractZipEntry(File jarFile, String entryName, File extractToFile) throws IOException {
        boolean entryExtracted = false;
        ZipInputStream zipStream = null;
        BufferedOutputStream extractTargetStream = null;
        try {
            zipStream = new ZipInputStream(new FileInputStream(jarFile));
            extractTargetStream = new BufferedOutputStream(new FileOutputStream(extractToFile));
            boolean classFileExtracted = false;
            boolean zipStreamEndReached = false;
            while (!classFileExtracted && !zipStreamEndReached) {
                ZipEntry candidateZipEntry = zipStream.getNextEntry();
                if (candidateZipEntry == null) {
                    zipStreamEndReached = true;
                    continue;
                }
                if (!candidateZipEntry.getName().equals(entryName)) continue;
                IOUtils.copy((InputStream)zipStream, (OutputStream)extractTargetStream);
                classFileExtracted = true;
                entryExtracted = true;
            }
        }
        catch (Throwable throwable) {
            IoActions.closeQuietly(zipStream);
            IoActions.closeQuietly(extractTargetStream);
            throw throwable;
        }
        IoActions.closeQuietly((Closeable)zipStream);
        IoActions.closeQuietly((Closeable)extractTargetStream);
        return entryExtracted;
    }

    public static boolean isManifestName(String jarEntryName) {
        return jarEntryName.equals("META-INF/MANIFEST.MF");
    }

    public static Manifest readManifest(byte[] content) throws IOException {
        return new Manifest(new ByteArrayInputStream(content));
    }

    public static boolean isMultiReleaseJarManifest(Manifest manifest) {
        return Boolean.parseBoolean(JarUtil.getManifestMainAttribute(manifest, MULTI_RELEASE_ATTRIBUTE));
    }

    @Nullable
    private static String getManifestMainAttribute(Manifest manifest, String name) {
        return manifest.getMainAttributes().getValue(name);
    }

    public static OptionalInt getVersionedDirectoryMajorVersion(String entryPath) {
        Matcher match = VERSIONED_JAR_ENTRY_PATH.matcher(entryPath);
        if (match.matches()) {
            try {
                int version = Integer.parseInt(match.group(1));
                return OptionalInt.of(version);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return OptionalInt.empty();
    }

    public static String toVersionedPath(int version, String basePath) {
        return String.format("META-INF/versions/%d/%s", version, basePath);
    }
}

