/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.configurations.ConflictResolution;
import org.gradle.api.internal.artifacts.dsl.ModuleReplacementsData;
import org.gradle.api.internal.artifacts.ivyservice.clientmodule.ClientModuleResolver;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.CachingDependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionApplicator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionComparator;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionParser;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.RootComponentMetadataBuilder;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyMetadataFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolutionstrategy.CapabilitiesResolutionInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.LatestModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ModuleConflictResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ProjectDependencyForcingResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.DependencyGraphBuilder;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.CapabilitiesConflictHandler;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.LastCandidateCapabilityResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.conflicts.UserConfiguredCapabilityResolver;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorFactory;
import org.gradle.api.specs.Spec;
import org.gradle.internal.ImmutableActionSet;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveStateFactory;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.resolve.resolver.ComponentMetaDataResolver;
import org.gradle.internal.resolve.resolver.DependencyToComponentIdResolver;

public class DependencyGraphResolver {
    private final DependencyMetadataFactory dependencyMetadataFactory;
    private final VersionComparator versionComparator;
    private final VersionParser versionParser;
    private final InstantiatorFactory instantiatorFactory;
    private final ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory;
    private final ModuleComponentGraphResolveStateFactory moduleResolveStateFactory;
    private final DependencyGraphBuilder dependencyGraphBuilder;

    @Inject
    public DependencyGraphResolver(DependencyMetadataFactory dependencyMetadataFactory, VersionComparator versionComparator, VersionParser versionParser, InstantiatorFactory instantiatorFactory, ComponentSelectionDescriptorFactory componentSelectionDescriptorFactory, ModuleComponentGraphResolveStateFactory moduleResolveStateFactory, DependencyGraphBuilder dependencyGraphBuilder) {
        this.dependencyMetadataFactory = dependencyMetadataFactory;
        this.versionComparator = versionComparator;
        this.versionParser = versionParser;
        this.instantiatorFactory = instantiatorFactory;
        this.componentSelectionDescriptorFactory = componentSelectionDescriptorFactory;
        this.moduleResolveStateFactory = moduleResolveStateFactory;
        this.dependencyGraphBuilder = dependencyGraphBuilder;
    }

    public void resolve(RootComponentMetadataBuilder.RootComponentState rootComponent, List<? extends DependencyMetadata> syntheticDependencies, Spec<? super DependencyMetadata> edgeFilter, ComponentSelectorConverter componentSelectorConverter, DependencyToComponentIdResolver componentIdResolver, ComponentMetaDataResolver componentMetaDataResolver, ModuleReplacementsData moduleReplacements, ImmutableActionSet<DependencySubstitutionInternal> dependencySubstitutionRule, ConflictResolution conflictResolution, CapabilitiesResolutionInternal capabilitiesResolutionRules, boolean failingOnDynamicVersions, boolean failingOnChangingVersions, DependencyGraphVisitor modelVisitor) {
        ClientModuleResolver clientModuleResolver = new ClientModuleResolver(componentMetaDataResolver, this.dependencyMetadataFactory, this.moduleResolveStateFactory);
        DependencySubstitutionApplicator substitutionApplicator = this.createDependencySubstitutionApplicator(dependencySubstitutionRule);
        ModuleConflictResolver<ComponentState> moduleConflictResolver = this.createModuleConflictResolver(conflictResolution);
        List<CapabilitiesConflictHandler.Resolver> capabilityConflictResolvers = DependencyGraphResolver.createCapabilityConflictResolvers(capabilitiesResolutionRules);
        this.dependencyGraphBuilder.resolve(rootComponent, syntheticDependencies, edgeFilter, componentSelectorConverter, componentIdResolver, clientModuleResolver, moduleReplacements, substitutionApplicator, moduleConflictResolver, capabilityConflictResolvers, conflictResolution, failingOnDynamicVersions, failingOnChangingVersions, modelVisitor);
    }

    private DependencySubstitutionApplicator createDependencySubstitutionApplicator(ImmutableActionSet<DependencySubstitutionInternal> dependencySubstitutionRule) {
        if (dependencySubstitutionRule.isEmpty()) {
            return DependencySubstitutionApplicator.NO_OP;
        }
        return new CachingDependencySubstitutionApplicator(new DefaultDependencySubstitutionApplicator(this.componentSelectionDescriptorFactory, (Action<? super DependencySubstitutionInternal>)dependencySubstitutionRule, this.instantiatorFactory));
    }

    private ModuleConflictResolver<ComponentState> createModuleConflictResolver(ConflictResolution conflictResolution) {
        LatestModuleConflictResolver<ComponentState> moduleConflictResolver = new LatestModuleConflictResolver<ComponentState>(this.versionComparator, this.versionParser);
        if (conflictResolution != ConflictResolution.preferProjectModules) {
            return moduleConflictResolver;
        }
        return new ProjectDependencyForcingResolver<ComponentState>(moduleConflictResolver);
    }

    private static List<CapabilitiesConflictHandler.Resolver> createCapabilityConflictResolvers(CapabilitiesResolutionInternal capabilitiesResolutionRules) {
        return ImmutableList.of((Object)new LastCandidateCapabilityResolver(), (Object)new UserConfiguredCapabilityResolver(capabilitiesResolutionRules), (Object)new LastCandidateCapabilityResolver());
    }
}

