/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import java.util.HashSet;
import java.util.LinkedHashSet;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.gradle.api.internal.artifacts.ProjectComponentIdentifierInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.artifacts.result.DefaultResolvedComponentResult;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.internal.Actions;
import org.gradle.internal.component.local.model.ProjectComponentSelectorInternal;
import org.gradle.util.Path;

public class VersionMappingComponentDependencyResolver
implements ComponentDependencyResolver {
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ResolvedComponentResult root;

    public VersionMappingComponentDependencyResolver(ProjectDependencyPublicationResolver projectDependencyResolver, ResolvedComponentResult root) {
        this.projectDependencyResolver = projectDependencyResolver;
        this.root = root;
    }

    @Override
    @Nullable
    public ResolvedCoordinates resolveComponentCoordinates(ExternalDependency dependency) {
        return this.resolveModule(dependency.getGroup(), dependency.getName());
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(ProjectDependency dependency) {
        Path identityPath = ((ProjectDependencyInternal)dependency).getIdentityPath();
        ModuleVersionIdentifier coordinates = (ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath);
        ModuleVersionIdentifier resolved = this.maybeResolveVersion(coordinates.getGroup(), coordinates.getName(), identityPath);
        return ResolvedCoordinates.create(resolved != null ? resolved : coordinates);
    }

    @Override
    @Nullable
    public ResolvedCoordinates resolveComponentCoordinates(DependencyConstraint dependency) {
        return this.resolveModule(dependency.getGroup(), dependency.getName());
    }

    @Override
    public ResolvedCoordinates resolveComponentCoordinates(DefaultProjectDependencyConstraint dependency) {
        return this.resolveComponentCoordinates(dependency.getProjectDependency());
    }

    @Nullable
    public ResolvedCoordinates resolveModule(String group, String name) {
        ModuleVersionIdentifier resolved = this.maybeResolveVersion(group, name, null);
        if (resolved != null) {
            return ResolvedCoordinates.create(resolved);
        }
        return null;
    }

    @Nullable
    public ModuleVersionIdentifier maybeResolveVersion(String group, String module, @Nullable Path identityPath) {
        LinkedHashSet resolvedComponentResults = new LinkedHashSet();
        DefaultResolvedComponentResult.eachElement((ResolvedComponentResult)this.root, (Action)Actions.doNothing(), (Action)Actions.doNothing(), resolvedComponentResults);
        for (ResolvedComponentResult selected : resolvedComponentResults) {
            ModuleVersionIdentifier moduleVersion = selected.getModuleVersion();
            if (moduleVersion == null || !group.equals(moduleVersion.getGroup()) || !module.equals(moduleVersion.getName())) continue;
            return moduleVersion;
        }
        LinkedHashSet allDependencies = new LinkedHashSet();
        DefaultResolvedComponentResult.eachElement((ResolvedComponentResult)this.root, (Action)Actions.doNothing(), allDependencies::add, new HashSet());
        for (DependencyResult dependencyResult : allDependencies) {
            ProjectComponentSelectorInternal pcs;
            ModuleComponentSelector requested;
            if (!(dependencyResult instanceof ResolvedDependencyResult)) continue;
            ComponentSelector rcs = dependencyResult.getRequested();
            ResolvedComponentResult selected = ((ResolvedDependencyResult)dependencyResult).getSelected();
            if (!(rcs instanceof ModuleComponentSelector ? (requested = (ModuleComponentSelector)rcs).getGroup().equals(group) && requested.getModule().equals(module) : rcs instanceof ProjectComponentSelector && (pcs = (ProjectComponentSelectorInternal)rcs).getIdentityPath().equals((Object)identityPath))) continue;
            return this.getModuleVersionId(selected);
        }
        return null;
    }

    @Nullable
    private ModuleVersionIdentifier getModuleVersionId(ResolvedComponentResult selected) {
        if (selected.getId() instanceof ProjectComponentIdentifier) {
            Path identityPath = ((ProjectComponentIdentifierInternal)selected.getId()).getIdentityPath();
            return (ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath);
        }
        return selected.getModuleVersion();
    }
}

