/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.providers.impl;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtBinaryModule;
import org.jetbrains.kotlin.com.intellij.ide.highlighter.JavaClassFileType;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.StandardFileSystems;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VfsUtilCore;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.impl.jar.CoreJarFileSystem;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0015H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\"\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/analysis/providers/impl/AbstractDeclarationFromBinaryModuleProvider;", "", "jarFileSystem", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "getJarFileSystem", "()Lcom/intellij/openapi/vfs/impl/jar/CoreJarFileSystem;", "packagePartProvider", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "getPackagePartProvider", "()Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "scope", "Lorg/jetbrains/kotlin/com/intellij/psi/search/GlobalSearchScope;", "getScope", "()Lcom/intellij/psi/search/GlobalSearchScope;", "findRoot", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "rootPath", "Ljava/nio/file/Path;", "fs", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFileSystem;", "isCompiledFile", "", "virtualFile", "relativeFqName", "", "root", "virtualFilesFromKotlinModule", "", "binaryModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtBinaryModule;", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "virtualFilesFromModule", "isPackageName", "analysis-api-providers"})
@SourceDebugExtension(value={"SMAP\nAbstractDeclarationFromBinaryModuleProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractDeclarationFromBinaryModuleProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/AbstractDeclarationFromBinaryModuleProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,156:1\n1360#2:157\n1446#2,2:158\n1855#2,2:160\n1448#2,3:162\n1360#2:165\n1446#2,5:166\n*S KotlinDebug\n*F\n+ 1 AbstractDeclarationFromBinaryModuleProvider.kt\norg/jetbrains/kotlin/analysis/providers/impl/AbstractDeclarationFromBinaryModuleProvider\n*L\n47#1:157\n47#1:158,2\n50#1:160,2\n47#1:162,3\n84#1:165\n84#1:166,5\n*E\n"})
public interface AbstractDeclarationFromBinaryModuleProvider {
    @NotNull
    public GlobalSearchScope getScope();

    @NotNull
    public PackagePartProvider getPackagePartProvider();

    @NotNull
    public CoreJarFileSystem getJarFileSystem();

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Set<VirtualFile> virtualFilesFromKotlinModule(@NotNull KtBinaryModule binaryModule, @NotNull FqName fqName2) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)binaryModule, (String)"binaryModule");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        String string2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String fqNameString = string2;
        List<String> packageParts2 = this.getPackagePartProvider().findPackageParts(fqNameString);
        if (!((Collection)packageParts2).isEmpty()) {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = binaryModule.getBinaryRoots();
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Set set2;
                block7: {
                    Path rootPath = (Path)element$iv$iv;
                    boolean bl = false;
                    if (!Files.isRegularFile(rootPath, new LinkOption[0]) || !StringsKt.contains$default((CharSequence)((Object)rootPath).toString(), (CharSequence)".jar", (boolean)false, (int)2, null)) {
                        set2 = SetsKt.emptySet();
                    } else {
                        Set set3;
                        Set $this$virtualFilesFromKotlinModule_u24lambda_u242_u24lambda_u241 = set3 = SetsKt.createSetBuilder();
                        boolean bl2 = false;
                        Iterable $this$forEach$iv = packageParts2;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            VirtualFile virtualFile2;
                            String packagePart = (String)element$iv;
                            boolean bl3 = false;
                            if (this.getJarFileSystem().refreshAndFindFileByPath(rootPath.toAbsolutePath() + "!/" + packagePart + ".class") == null) {
                                Set set4;
                                set2 = set4 = SetsKt.emptySet();
                                break block7;
                            }
                            Intrinsics.checkNotNull((Object)virtualFile2);
                            $this$virtualFilesFromKotlinModule_u24lambda_u242_u24lambda_u241.add(virtualFile2);
                        }
                        set2 = SetsKt.build((Set)set3);
                    }
                }
                Iterable list$iv$iv = set2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Set<VirtualFile> virtualFilesFromModule(@NotNull KtBinaryModule binaryModule, @NotNull FqName fqName2, boolean isPackageName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)binaryModule, (String)"binaryModule");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        String string2 = fqName2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String fqNameString = string2;
        VirtualFileSystem fs = StandardFileSystems.local();
        Iterable $this$flatMap$iv = binaryModule.getBinaryRoots();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Set set;
            Path rootPath = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)fs);
            if (this.findRoot(rootPath, fs) == null) {
                set = SetsKt.emptySet();
            } else {
                VirtualFile root2;
                Set files2 = new LinkedHashSet();
                VfsUtilCore.iterateChildrenRecursively(root2, arg_0 -> AbstractDeclarationFromBinaryModuleProvider.virtualFilesFromModule$lambda$5$lambda$3(root2, this, fqNameString, isPackageName, arg_0), arg_0 -> AbstractDeclarationFromBinaryModuleProvider.virtualFilesFromModule$lambda$5$lambda$4(this, files2, arg_0));
                set = files2;
            }
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private VirtualFile findRoot(Path rootPath, VirtualFileSystem fs) {
        return Files.isRegularFile(rootPath, new LinkOption[0]) && StringsKt.contains$default((CharSequence)((Object)rootPath).toString(), (CharSequence)".jar", (boolean)false, (int)2, null) ? this.getJarFileSystem().refreshAndFindFileByPath(rootPath.toAbsolutePath() + "!/") : fs.findFileByPath(((Object)rootPath.toAbsolutePath()).toString());
    }

    private String relativeFqName(VirtualFile root2, VirtualFile virtualFile2) {
        String string2;
        if (root2.isDirectory()) {
            List list2;
            List $this$relativeFqName_u24lambda_u246 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            VirtualFile cur = virtualFile2;
            while (!Intrinsics.areEqual((Object)cur, (Object)root2)) {
                $this$relativeFqName_u24lambda_u246.add(cur.getNameWithoutExtension());
                Intrinsics.checkNotNullExpressionValue((Object)cur.getParent(), (String)"getParent(...)");
            }
            List fragments2 = CollectionsKt.build((List)list2);
            string2 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)fragments2), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
        } else {
            String string3 = virtualFile2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            String[] stringArray = new String[]{"!/"};
            string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)string3, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            if (string2 == null || (string2 = StringsKt.replace$default((String)string2, (String)"/", (String)".", (boolean)false, (int)4, null)) == null) {
                string2 = "!/";
            }
        }
        return string2;
    }

    private boolean isCompiledFile(VirtualFile virtualFile2) {
        boolean bl;
        String string2 = virtualFile2.getExtension();
        if (string2 != null) {
            String string3 = JavaClassFileType.INSTANCE.getDefaultExtension();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefaultExtension(...)");
            bl = StringsKt.endsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
        } else {
            bl = false;
        }
        return bl;
    }

    private static boolean virtualFilesFromModule$lambda$5$lambda$3(VirtualFile $root, AbstractDeclarationFromBinaryModuleProvider this$0, String $fqNameString, boolean $isPackageName, VirtualFile it) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$fqNameString, (String)"$fqNameString");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)$root)) {
            return true;
        }
        String relativeFqName = this$0.relativeFqName($root, it);
        if (it.isDirectory() && StringsKt.startsWith$default((String)$fqNameString, (String)relativeFqName, (boolean)false, (int)2, null)) {
            return true;
        }
        if ($isPackageName) {
            VirtualFile virtualFile2 = it.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
            bl = StringsKt.endsWith$default((String)this$0.relativeFqName($root, virtualFile2), (String)$fqNameString, (boolean)false, (int)2, null);
        } else {
            bl = Intrinsics.areEqual((Object)relativeFqName, (Object)$fqNameString);
        }
        return bl;
    }

    private static boolean virtualFilesFromModule$lambda$5$lambda$4(AbstractDeclarationFromBinaryModuleProvider this$0, Set $files, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$files, (String)"$files");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isDirectory() && this$0.isCompiledFile(it) && this$0.getScope().contains(it)) {
            $files.add(it);
        }
        return true;
    }
}

