/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publisher;

import java.util.concurrent.Callable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.DefaultIvyArtifactRepository;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.transport.NetworkOperationBackOffAndRetry;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublisher;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;

public class DependencyResolverIvyPublisher
implements IvyPublisher {
    private final NetworkOperationBackOffAndRetry<Void> networkOperationBackOffAndRetry = new NetworkOperationBackOffAndRetry();

    @Override
    public void publish(IvyNormalizedPublication publication, IvyArtifactRepository repository) {
        IvyResolver publisher = ((DefaultIvyArtifactRepository)repository).createPublisher();
        ModuleComponentIdentifier moduleVersionIdentifier = DefaultModuleComponentIdentifier.newId((ModuleVersionIdentifier)publication.getCoordinates());
        for (IvyArtifact artifact : publication.getAllArtifacts()) {
            DefaultModuleComponentArtifactMetadata artifactMetadata = new DefaultModuleComponentArtifactMetadata(moduleVersionIdentifier, this.createIvyArtifact(artifact));
            this.publish(publisher, artifact, (ModuleComponentArtifactMetadata)artifactMetadata);
        }
    }

    private void publish(final IvyResolver publisher, final IvyArtifact artifact, final ModuleComponentArtifactMetadata artifactMetadata) {
        this.networkOperationBackOffAndRetry.withBackoffAndRetry((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                publisher.publish(artifactMetadata, artifact.getFile());
                return null;
            }

            public String toString() {
                return "Publish " + artifactMetadata;
            }
        });
    }

    private IvyArtifactName createIvyArtifact(IvyArtifact artifact) {
        return new DefaultIvyArtifactName(artifact.getName(), artifact.getType(), artifact.getExtension(), artifact.getClassifier());
    }
}

