/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import com.google.common.collect.ImmutableSet;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.MethodHandleInvocation;

public abstract class AbstractCallInterceptor
implements CallInterceptor {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandle INTERCEPTOR;
    private final Set<InterceptScope> interceptScopes;

    protected AbstractCallInterceptor(InterceptScope ... interceptScopes) {
        this.interceptScopes = ImmutableSet.copyOf((Object[])interceptScopes);
    }

    @Override
    public MethodHandle decorateMethodHandle(MethodHandle original, MethodHandles.Lookup caller, int flags) {
        MethodHandle spreader = original.asSpreader(Object[].class, original.type().parameterCount());
        MethodHandle decorated = MethodHandles.insertArguments(INTERCEPTOR, 0, this, spreader, flags, caller.lookupClass().getName());
        return decorated.asCollector(Object[].class, original.type().parameterCount()).asType(original.type());
    }

    @Nullable
    private Object interceptMethodHandle(MethodHandle original, int flags, String consumer, Object[] args) throws Throwable {
        boolean isSpread = (flags & 0x10) != 0;
        return this.intercept(new MethodHandleInvocation(original, args, isSpread), consumer);
    }

    @Override
    public Set<InterceptScope> getInterceptScopes() {
        return this.interceptScopes;
    }

    static {
        try {
            INTERCEPTOR = LOOKUP.findVirtual(AbstractCallInterceptor.class, "interceptMethodHandle", MethodType.methodType(Object.class, MethodHandle.class, Integer.TYPE, String.class, Object[].class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new GradleException("Failed to set up an interceptor method", (Throwable)e);
        }
    }
}

