/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.provider.Provider;

public class FreezableAttributeContainer
implements AttributeContainerInternal {
    private final Describable owner;
    private AttributeContainerInternal delegate;

    public FreezableAttributeContainer(AttributeContainerInternal delegate, Describable owner) {
        this.delegate = delegate;
        this.owner = owner;
    }

    public void freeze() {
        this.delegate = this.delegate.asImmutable();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public ImmutableAttributes asImmutable() {
        return this.delegate.asImmutable();
    }

    public Map<Attribute<?>, ?> asMap() {
        return this.delegate.asMap();
    }

    public Set<Attribute<?>> keySet() {
        return this.delegate.keySet();
    }

    public <T> AttributeContainer attribute(Attribute<T> key, T value) {
        this.assertMutable();
        this.delegate.attribute(key, value);
        return this;
    }

    public <T> AttributeContainer attributeProvider(Attribute<T> key, Provider<? extends T> provider) {
        this.assertMutable();
        this.delegate.attributeProvider(key, provider);
        return this;
    }

    @Nullable
    public <T> T getAttribute(Attribute<T> key) {
        return (T)this.delegate.getAttribute(key);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean contains(Attribute<?> key) {
        return this.delegate.contains(key);
    }

    public AttributeContainer getAttributes() {
        return this;
    }

    private void assertMutable() {
        if (this.delegate instanceof ImmutableAttributes) {
            throw new IllegalStateException(String.format("Cannot change attributes of %s after it has been locked for mutation", this.owner.getDisplayName()));
        }
    }
}

