/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Incubating;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRolesForMigration;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationArtifact;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.internal.Cast;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SignOperation;
import org.gradle.plugins.signing.Signature;
import org.gradle.plugins.signing.SignatureSpec;
import org.gradle.plugins.signing.internal.SignOperationInternal;
import org.gradle.plugins.signing.signatory.Signatory;
import org.gradle.plugins.signing.signatory.SignatoryProvider;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSignatoryProvider;
import org.gradle.plugins.signing.signatory.internal.pgp.InMemoryPgpSignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatoryProvider;
import org.gradle.plugins.signing.type.DefaultSignatureTypeProvider;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.SignatureTypeProvider;
import org.gradle.util.internal.DeferredUtil;

public abstract class SigningExtension {
    public static final String DEFAULT_CONFIGURATION_NAME = "signatures";
    private final Project project;
    private Configuration configuration;
    private Object required = true;
    private SignatureTypeProvider signatureTypes;
    private SignatoryProvider<?> signatories;

    public SigningExtension(Project project) {
        this.project = project;
        this.configuration = this.getDefaultConfiguration();
        this.signatureTypes = this.createSignatureTypeProvider();
        this.signatories = this.createSignatoryProvider();
        project.getTasks().withType(Sign.class, this::addSignatureSpecConventions);
    }

    public final Project getProject() {
        return this.project;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setRequired(Object required) {
        this.required = required;
    }

    @ToBeReplacedByLazyProperty
    public boolean isRequired() {
        return DefaultTypeTransformation.castToBoolean((Object)this.force(this.required));
    }

    protected Configuration getDefaultConfiguration() {
        RoleBasedConfigurationContainerInternal configurations = ((ProjectInternal)this.project).getConfigurations();
        Configuration configuration = (Configuration)configurations.findByName(DEFAULT_CONFIGURATION_NAME);
        return configuration != null ? configuration : configurations.migratingUnlocked(DEFAULT_CONFIGURATION_NAME, ConfigurationRolesForMigration.LEGACY_TO_CONSUMABLE);
    }

    protected SignatureTypeProvider createSignatureTypeProvider() {
        return new DefaultSignatureTypeProvider();
    }

    protected SignatoryProvider<?> createSignatoryProvider() {
        return new PgpSignatoryProvider();
    }

    public SignatoryProvider<?> signatories(Closure<?> closure) {
        this.signatories.configure(this, closure);
        return this.signatories;
    }

    @ToBeReplacedByLazyProperty
    public Signatory getSignatory() {
        return this.signatories.getDefaultSignatory(this.project);
    }

    @ToBeReplacedByLazyProperty
    public SignatureType getSignatureType() {
        return this.signatureTypes.getDefaultType();
    }

    public void setSignatureTypes(SignatureTypeProvider signatureTypes) {
        this.signatureTypes = signatureTypes;
    }

    @ToBeReplacedByLazyProperty
    public SignatureTypeProvider getSignatureTypes() {
        return this.signatureTypes;
    }

    public void setSignatories(SignatoryProvider<?> signatories) {
        this.signatories = signatories;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void useGpgCmd() {
        this.setSignatories(new GnupgSignatoryProvider());
    }

    public void useInMemoryPgpKeys(@Nullable String defaultSecretKey, @Nullable String defaultPassword) {
        this.setSignatories(new InMemoryPgpSignatoryProvider(defaultSecretKey, defaultPassword));
    }

    public void useInMemoryPgpKeys(@Nullable String defaultKeyId, @Nullable String defaultSecretKey, @Nullable String defaultPassword) {
        this.setSignatories(new InMemoryPgpSignatoryProvider(defaultKeyId, defaultSecretKey, defaultPassword));
    }

    @ToBeReplacedByLazyProperty
    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected void addSignatureSpecConventions(SignatureSpec spec) {
        if (!(spec instanceof IConventionAware)) {
            throw new InvalidUserDataException("Cannot add conventions to signature spec '" + spec + "' as it is not convention aware");
        }
        ConventionMapping conventionMapping = ((IConventionAware)spec).getConventionMapping();
        conventionMapping.map("signatory", this::getSignatory);
        conventionMapping.map("signatureType", this::getSignatureType);
        conventionMapping.map("required", this::isRequired);
    }

    public List<Sign> sign(Task ... tasks) {
        ArrayList<Sign> result = new ArrayList<Sign>(tasks.length);
        for (Task taskToSign : tasks) {
            result.add(this.createSignTaskFor(taskToSign.getName(), (Action<Sign>)((Action)task -> {
                task.setDescription("Signs the archive produced by the '" + taskToSign.getName() + "' task.");
                task.sign(taskToSign);
            })));
        }
        return result;
    }

    public List<Sign> sign(Configuration ... configurations) {
        ArrayList<Sign> result = new ArrayList<Sign>(configurations.length);
        for (Configuration configurationToSign : configurations) {
            result.add(this.createSignTaskFor(configurationToSign.getName(), (Action<Sign>)((Action)task -> {
                task.setDescription("Signs all artifacts in the '" + configurationToSign.getName() + "' configuration.");
                task.sign(configurationToSign);
            })));
        }
        return result;
    }

    public List<Sign> sign(Publication ... publications) {
        ArrayList<Sign> result = new ArrayList<Sign>(publications.length);
        for (Publication publication : publications) {
            result.add(this.createSignTaskFor((PublicationInternal)publication));
        }
        return result;
    }

    public List<Sign> sign(DomainObjectCollection<Publication> publications) {
        ArrayList<Sign> result = new ArrayList<Sign>();
        publications.all(publication -> result.add(this.createSignTaskFor((PublicationInternal)publication)));
        publications.whenObjectRemoved(publication -> {
            TaskContainer tasks = this.project.getTasks();
            Task task = tasks.getByName(this.determineSignTaskNameForPublication((Publication)publication));
            task.setEnabled(false);
            result.remove(task);
        });
        return result;
    }

    private <T extends PublicationArtifact> Sign createSignTaskFor(PublicationInternal<T> publicationToSign) {
        String signTaskName = this.determineSignTaskNameForPublication((Publication)publicationToSign);
        if (this.project.getTasks().getNames().contains(signTaskName)) {
            return (Sign)this.project.getTasks().named(signTaskName, Sign.class).get();
        }
        Sign signTask = (Sign)this.project.getTasks().create(signTaskName, Sign.class, task -> {
            task.setDescription("Signs all artifacts in the '" + publicationToSign.getName() + "' publication.");
            task.sign(new Publication[]{publicationToSign});
        });
        HashMap artifacts = new HashMap();
        signTask.getSignatures().all(signature -> {
            PublicationArtifact artifact = publicationToSign.addDerivedArtifact((PublicationArtifact)Cast.uncheckedNonnullCast((Object)signature.getSource()), (PublicationInternal.DerivedArtifact)new DefaultDerivedArtifactFile((Signature)((Object)signature), signTask));
            artifact.builtBy(new Object[]{signTask});
            artifacts.put(signature, artifact);
        });
        signTask.getSignatures().whenObjectRemoved(signature -> {
            PublicationArtifact artifact = (PublicationArtifact)artifacts.remove(signature);
            publicationToSign.removeDerivedArtifact(artifact);
        });
        return signTask;
    }

    private String determineSignTaskNameForPublication(Publication publication) {
        return "sign" + StringGroovyMethods.capitalize((CharSequence)publication.getName()) + "Publication";
    }

    private Sign createSignTaskFor(CharSequence name, Action<Sign> taskConfiguration) {
        String signTaskName = "sign" + StringGroovyMethods.capitalize((CharSequence)name);
        if (this.project.getTasks().getNames().contains(signTaskName)) {
            return (Sign)this.project.getTasks().named(signTaskName, Sign.class).get();
        }
        Sign signTask = (Sign)this.project.getTasks().create(signTaskName, Sign.class, taskConfiguration);
        this.addSignaturesToConfiguration(signTask, this.getConfiguration());
        return signTask;
    }

    protected Object addSignaturesToConfiguration(Sign task, Configuration configuration) {
        task.getSignatures().all(sig -> configuration.getArtifacts().add((Object)sig));
        return task.getSignatures().whenObjectRemoved(sig -> configuration.getArtifacts().remove((Object)sig));
    }

    public SignOperation sign(PublishArtifact ... publishArtifacts) {
        return this.doSignOperation((Action<SignOperation>)((Action)operation -> operation.sign(publishArtifacts)));
    }

    public SignOperation sign(File ... files) {
        return this.doSignOperation((Action<SignOperation>)((Action)operation -> operation.sign(files)));
    }

    public SignOperation sign(String classifier, File ... files) {
        return this.doSignOperation((Action<SignOperation>)((Action)operation -> operation.sign(classifier, files)));
    }

    public SignOperation sign(@DelegatesTo(value=SignOperation.class) Closure<?> closure) {
        return this.doSignOperation(closure);
    }

    @Incubating
    public SignOperation sign(Action<SignOperation> setup) {
        return this.doSignOperation(setup);
    }

    protected SignOperation doSignOperation(@DelegatesTo(value=SignOperation.class) Closure<?> setup) {
        return this.doSignOperation((Action<SignOperation>)((Action)operation -> operation.configure(setup)));
    }

    protected SignOperation doSignOperation(Action<SignOperation> setup) {
        SignOperation operation = (SignOperation)this.objectFactory().newInstance(SignOperationInternal.class, new Object[0]);
        this.addSignatureSpecConventions(operation);
        setup.execute((Object)operation);
        operation.execute();
        return operation;
    }

    private ObjectFactory objectFactory() {
        return this.project.getObjects();
    }

    @ToBeReplacedByLazyProperty
    public SignatoryProvider<?> getSignatories() {
        return this.signatories;
    }

    private Object force(Object maybeCallable) {
        return DeferredUtil.unpack((Object)maybeCallable);
    }

    private static class DefaultDerivedArtifactFile
    implements PublicationInternal.DerivedArtifact {
        private final Signature signature;
        private final Sign signTask;

        public DefaultDerivedArtifactFile(Signature signature, Sign signTask) {
            this.signature = signature;
            this.signTask = signTask;
        }

        public File create() {
            return this.signature.getFile();
        }

        public boolean shouldBePublished() {
            return this.signTask.isEnabled() && this.signTask.getOnlyIf().isSatisfiedBy((Object)this.signTask);
        }
    }
}

