/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.workers.internal;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.gradle.api.Transformer;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.events.LogLevelChangeEvent;
import org.gradle.internal.logging.events.OutputEvent;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.os.OperatingSystem;
import org.gradle.internal.session.BuildSessionLifecycleListener;
import org.gradle.process.internal.health.memory.MemoryHolder;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.workers.internal.DaemonForkOptions;
import org.gradle.workers.internal.KeepAliveMode;
import org.gradle.workers.internal.WorkerDaemonClient;
import org.gradle.workers.internal.WorkerDaemonExpiration;
import org.gradle.workers.internal.WorkerDaemonStarter;

public class WorkerDaemonClientsManager
implements Stoppable {
    private static final Logger LOGGER = Logging.getLogger(WorkerDaemonClientsManager.class);
    private final Object lock = new Object();
    private final List<WorkerDaemonClient> allClients = new ArrayList<WorkerDaemonClient>();
    private final List<WorkerDaemonClient> idleClients = new ArrayList<WorkerDaemonClient>();
    private final WorkerDaemonStarter workerDaemonStarter;
    private final ListenerManager listenerManager;
    private final LoggingManagerInternal loggingManager;
    private final OsMemoryInfo memoryInfo;
    private final BuildSessionLifecycleListener stopSessionScopeWorkers;
    private final OutputEventListener logLevelChangeEventListener;
    private final WorkerDaemonExpiration workerDaemonExpiration;
    private final MemoryManager memoryManager;
    private volatile LogLevel currentLogLevel;
    private static final Consumer<WorkerDaemonClient> STOP_CLIENT = WorkerDaemonClient::stop;
    private static final Consumer<WorkerDaemonClient> KILL_CLIENT = WorkerDaemonClient::kill;

    public WorkerDaemonClientsManager(WorkerDaemonStarter workerDaemonStarter, ListenerManager listenerManager, LoggingManagerInternal loggingManager, MemoryManager memoryManager, OsMemoryInfo memoryInfo) {
        this.workerDaemonStarter = workerDaemonStarter;
        this.listenerManager = listenerManager;
        this.loggingManager = loggingManager;
        this.memoryInfo = memoryInfo;
        this.stopSessionScopeWorkers = new StopSessionScopedWorkers();
        listenerManager.addListener((Object)this.stopSessionScopeWorkers);
        this.logLevelChangeEventListener = new LogLevelChangeEventListener();
        loggingManager.addOutputEventListener(this.logLevelChangeEventListener);
        this.currentLogLevel = loggingManager.getLevel();
        this.memoryManager = memoryManager;
        this.workerDaemonExpiration = new WorkerDaemonExpiration(this, this.getTotalPhysicalMemory());
        memoryManager.addMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
    }

    public WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions) {
        return this.reserveIdleClient(forkOptions, this.idleClients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WorkerDaemonClient reserveIdleClient(DaemonForkOptions forkOptions, List<WorkerDaemonClient> clients) {
        Object object = this.lock;
        synchronized (object) {
            Iterator<WorkerDaemonClient> it = clients.iterator();
            while (it.hasNext()) {
                WorkerDaemonClient candidate = it.next();
                if (candidate.isFailed()) {
                    WorkerDaemonClientsManager.emitUnexpectedWorkerFailureWarning(candidate);
                    it.remove();
                    continue;
                }
                if (!candidate.isCompatibleWith(forkOptions)) continue;
                it.remove();
                if (candidate.getLogLevel() != this.currentLogLevel) {
                    LOGGER.info("Log level has changed, stopping idle worker daemon with out-of-date log level.");
                    candidate.stop();
                    continue;
                }
                return candidate;
            }
            return null;
        }
    }

    private static void emitUnexpectedWorkerFailureWarning(WorkerDaemonClient candidate) {
        if (candidate.getExitCode().isPresent()) {
            int exitCode = candidate.getExitCode().get();
            if (OperatingSystem.current().isUnix() && exitCode > 127) {
                LOGGER.warn("Worker daemon '" + candidate.getDisplayName() + "' exited unexpectedly after being killed with signal " + (exitCode - 128) + ".  This is likely because an external process has killed the worker.");
            } else {
                LOGGER.warn("Worker daemon '" + candidate.getDisplayName() + "' exited unexpectedly with exit code " + exitCode + ".");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerDaemonClient reserveNewClient(DaemonForkOptions forkOptions) {
        WorkerDaemonClient client = this.workerDaemonStarter.startDaemon(forkOptions);
        Object object = this.lock;
        synchronized (object) {
            this.allClients.add(client);
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(WorkerDaemonClient client) {
        Object object = this.lock;
        synchronized (object) {
            if (!client.isFailed()) {
                this.idleClients.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.stopAllWorkers();
            this.listenerManager.removeListener((Object)this.stopSessionScopeWorkers);
            this.memoryManager.removeMemoryHolder((MemoryHolder)this.workerDaemonExpiration);
        }
        this.loggingManager.removeOutputEventListener(this.logLevelChangeEventListener);
    }

    private long getTotalPhysicalMemory() {
        try {
            return this.memoryInfo.getOsSnapshot().getPhysicalMemory().getTotal();
        }
        catch (UnsupportedOperationException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void selectIdleClientsToStop(Transformer<List<WorkerDaemonClient>, List<WorkerDaemonClient>> selectionFunction) {
        Object object = this.lock;
        synchronized (object) {
            List sortedClients = CollectionUtils.sort(this.idleClients, Comparator.comparingInt(WorkerDaemonClient::getUses));
            List clientsToStop = (List)selectionFunction.transform(new ArrayList(sortedClients));
            if (!clientsToStop.isEmpty()) {
                this.stopWorkers(clientsToStop);
            }
        }
    }

    private void stopWorkers(List<WorkerDaemonClient> clientsToStop) {
        this.stopWorkers(clientsToStop, STOP_CLIENT);
    }

    private void stopWorkers(List<WorkerDaemonClient> clientsToStop, Consumer<WorkerDaemonClient> stopAction) {
        if (clientsToStop.size() > 0) {
            int clientCount = clientsToStop.size();
            LOGGER.debug("Stopping {} worker daemon(s).", (Object)clientCount);
            int failureCount = 0;
            for (WorkerDaemonClient client : clientsToStop) {
                try {
                    if (client.isFailed()) {
                        WorkerDaemonClientsManager.emitUnexpectedWorkerFailureWarning(client);
                        continue;
                    }
                    stopAction.accept(client);
                }
                catch (Exception e) {
                    ++failureCount;
                    LOGGER.warn("Failed to stop worker daemon '" + client.getDisplayName() + "'", (Throwable)e);
                }
            }
            this.idleClients.removeAll(clientsToStop);
            this.allClients.removeAll(clientsToStop);
            if (failureCount > 0) {
                LOGGER.info("Stopped {} worker daemon(s).  {} worker daemons had failures while stopping.", (Object)clientCount, (Object)failureCount);
            } else {
                LOGGER.info("Stopped {} worker daemon(s).", (Object)clientCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopAllWorkers(Consumer<WorkerDaemonClient> stopClientAction) {
        Object object = this.lock;
        synchronized (object) {
            this.stopWorkers(this.allClients, stopClientAction);
            this.allClients.clear();
            this.idleClients.clear();
        }
    }

    public void stopAllWorkers() {
        this.stopAllWorkers(STOP_CLIENT);
    }

    public void killAllWorkers() {
        this.stopAllWorkers(KILL_CLIENT);
    }

    private class StopSessionScopedWorkers
    implements BuildSessionLifecycleListener {
        private StopSessionScopedWorkers() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeComplete() {
            Object object = WorkerDaemonClientsManager.this.lock;
            synchronized (object) {
                List sessionScopedClients = CollectionUtils.filter((List)WorkerDaemonClientsManager.this.allClients, client -> client.getKeepAliveMode() == KeepAliveMode.SESSION);
                WorkerDaemonClientsManager.this.stopWorkers(sessionScopedClients);
            }
        }
    }

    private class LogLevelChangeEventListener
    implements OutputEventListener {
        private LogLevelChangeEventListener() {
        }

        public void onOutput(OutputEvent event) {
            if (event instanceof LogLevelChangeEvent) {
                LogLevelChangeEvent logLevelChangeEvent = (LogLevelChangeEvent)event;
                WorkerDaemonClientsManager.this.currentLogLevel = logLevelChangeEvent.getNewLogLevel();
            }
        }
    }
}

