/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories.descriptor;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.artifacts.repositories.descriptor.RepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.descriptor.UrlRepositoryDescriptor;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResolver;
import org.gradle.api.internal.artifacts.repositories.resolver.IvyResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.M2ResourcePattern;
import org.gradle.api.internal.artifacts.repositories.resolver.ResourcePattern;

public final class IvyRepositoryDescriptor
extends UrlRepositoryDescriptor {
    private final ImmutableList<String> ivyPatterns;
    private final ImmutableList<ResourcePattern> ivyResources;
    private final ImmutableList<String> artifactPatterns;
    private final ImmutableList<ResourcePattern> artifactResources;
    private final String layoutType;
    private final boolean m2Compatible;

    private IvyRepositoryDescriptor(String id, String name, URI url, ImmutableList<String> metadataSources, boolean authenticated, ImmutableList<String> authenticationSchemes, ImmutableList<String> ivyPatterns, ImmutableList<ResourcePattern> ivyResources, ImmutableList<String> artifactPatterns, ImmutableList<ResourcePattern> artifactResources, String layoutType, boolean m2Compatible) {
        super(id, name, url, metadataSources, authenticated, authenticationSchemes);
        this.ivyPatterns = ivyPatterns;
        this.ivyResources = ivyResources;
        this.artifactPatterns = artifactPatterns;
        this.artifactResources = artifactResources;
        this.layoutType = layoutType;
        this.m2Compatible = m2Compatible;
    }

    @Override
    public ImmutableList<ResourcePattern> getMetadataResources() {
        return this.ivyResources;
    }

    @Override
    public ImmutableList<ResourcePattern> getArtifactResources() {
        return this.artifactResources;
    }

    @Override
    public RepositoryDescriptor.Type getType() {
        return RepositoryDescriptor.Type.IVY;
    }

    public List<String> getArtifactPatterns() {
        return this.artifactPatterns;
    }

    public boolean isM2Compatible() {
        return this.m2Compatible;
    }

    @Override
    protected void addProperties(ImmutableSortedMap.Builder<String, Object> builder) {
        super.addProperties(builder);
        builder.put((Object)Property.IVY_PATTERNS.name(), this.ivyPatterns);
        builder.put((Object)Property.ARTIFACT_PATTERNS.name(), this.artifactPatterns);
        builder.put((Object)Property.LAYOUT_TYPE.name(), (Object)this.layoutType);
        builder.put((Object)Property.M2_COMPATIBLE.name(), (Object)this.m2Compatible);
    }

    public static class Builder
    extends UrlRepositoryDescriptor.Builder<Builder> {
        private final List<String> ivyPatterns = new ArrayList<String>();
        private final List<String> artifactPatterns = new ArrayList<String>();
        private String layoutType;
        private Boolean m2Compatible;
        private final List<Resource> ivyResources = new ArrayList<Resource>();
        private final List<Resource> artifactResources = new ArrayList<Resource>();

        public Builder(String name, URI url) {
            super(name, url);
        }

        public void addIvyPattern(String declaredPattern) {
            this.ivyPatterns.add(declaredPattern);
        }

        public void addIvyResource(@Nullable URI baseUri, String pattern) {
            if (baseUri != null) {
                this.ivyResources.add(new Resource(baseUri, pattern));
            }
        }

        public void addArtifactPattern(String declaredPattern) {
            this.artifactPatterns.add(declaredPattern);
        }

        public void addArtifactResource(@Nullable URI rootUri, String pattern) {
            if (rootUri != null) {
                this.artifactResources.add(new Resource(rootUri, pattern));
            }
        }

        public Builder setLayoutType(String layoutType) {
            this.layoutType = layoutType;
            return this;
        }

        public Builder setM2Compatible(boolean m2Compatible) {
            this.m2Compatible = m2Compatible;
            return this;
        }

        public IvyRepositoryDescriptor create() {
            Preconditions.checkNotNull((Object)this.m2Compatible);
            Preconditions.checkNotNull((Object)this.metadataSources);
            ImmutableList.Builder ivyResourcesBuilder = ImmutableList.builderWithExpectedSize((int)this.ivyPatterns.size());
            for (Resource resource : this.ivyResources) {
                ivyResourcesBuilder.add((Object)this.toResourcePattern(resource.baseUri, resource.pattern));
            }
            ImmutableList.Builder artifactResourcesBuilder = ImmutableList.builderWithExpectedSize((int)(this.artifactPatterns.size() + this.artifactResources.size()));
            for (Resource resource : this.artifactResources) {
                artifactResourcesBuilder.add((Object)this.toResourcePattern(resource.baseUri, resource.pattern));
            }
            ImmutableList immutableList = ivyResourcesBuilder.build();
            ImmutableList effectiveArtifactResources = artifactResourcesBuilder.build();
            String id = this.calculateId(IvyResolver.class, (List<ResourcePattern>)immutableList, (List<ResourcePattern>)effectiveArtifactResources, (List<String>)this.metadataSources, hasher -> hasher.putBoolean(this.m2Compatible.booleanValue()));
            return new IvyRepositoryDescriptor(id, (String)Preconditions.checkNotNull((Object)this.name), this.url, this.metadataSources, (Boolean)Preconditions.checkNotNull((Object)this.authenticated), (ImmutableList)Preconditions.checkNotNull((Object)this.authenticationSchemes), ImmutableList.copyOf(this.ivyPatterns), immutableList, ImmutableList.copyOf(this.artifactPatterns), effectiveArtifactResources, (String)Preconditions.checkNotNull((Object)this.layoutType), this.m2Compatible);
        }

        private ResourcePattern toResourcePattern(URI baseUri, String pattern) {
            return this.m2Compatible != false ? new M2ResourcePattern(baseUri, pattern) : new IvyResourcePattern(baseUri, pattern);
        }
    }

    @NonNullApi
    private static class Resource {
        final URI baseUri;
        final String pattern;

        public Resource(URI baseUri, String pattern) {
            this.baseUri = baseUri;
            this.pattern = pattern;
        }
    }

    private static enum Property {
        IVY_PATTERNS,
        ARTIFACT_PATTERNS,
        LAYOUT_TYPE,
        M2_COMPATIBLE;

    }
}

