/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.LongQueue;
import org.junit.Assert;
import org.junit.Test;

public class LongQueueTest {
    @Test
    public void addFirstAndLastTest() {
        LongQueue queue = new LongQueue();
        queue.addFirst(1L);
        queue.addLast(2L);
        queue.addFirst(3L);
        queue.addLast(4L);
        Assert.assertEquals((long)0L, (long)queue.indexOf(3L));
        Assert.assertEquals((long)1L, (long)queue.indexOf(1L));
        Assert.assertEquals((long)2L, (long)queue.indexOf(2L));
        Assert.assertEquals((long)3L, (long)queue.indexOf(4L));
    }

    @Test
    public void removeLastTest() {
        LongQueue queue = new LongQueue();
        queue.addLast(1L);
        queue.addLast(2L);
        queue.addLast(3L);
        queue.addLast(4L);
        Assert.assertEquals((long)4L, (long)queue.size);
        Assert.assertEquals((long)3L, (long)queue.indexOf(4L));
        Assert.assertEquals((long)4L, (long)queue.removeLast());
        Assert.assertEquals((long)3L, (long)queue.size);
        Assert.assertEquals((long)2L, (long)queue.indexOf(3L));
        Assert.assertEquals((long)3L, (long)queue.removeLast());
        Assert.assertEquals((long)2L, (long)queue.size);
        Assert.assertEquals((long)1L, (long)queue.indexOf(2L));
        Assert.assertEquals((long)2L, (long)queue.removeLast());
        Assert.assertEquals((long)1L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(1L));
        Assert.assertEquals((long)1L, (long)queue.removeLast());
        Assert.assertEquals((long)0L, (long)queue.size);
    }

    @Test
    public void removeFirstTest() {
        LongQueue queue = new LongQueue();
        queue.addLast(1L);
        queue.addLast(2L);
        queue.addLast(3L);
        queue.addLast(4L);
        Assert.assertEquals((long)4L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(1L));
        Assert.assertEquals((long)1L, (long)queue.removeFirst());
        Assert.assertEquals((long)3L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(2L));
        Assert.assertEquals((long)2L, (long)queue.removeFirst());
        Assert.assertEquals((long)2L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(3L));
        Assert.assertEquals((long)3L, (long)queue.removeFirst());
        Assert.assertEquals((long)1L, (long)queue.size);
        Assert.assertEquals((long)0L, (long)queue.indexOf(4L));
        Assert.assertEquals((long)4L, (long)queue.removeFirst());
        Assert.assertEquals((long)0L, (long)queue.size);
    }

    @Test
    public void resizableQueueTest() {
        LongQueue q = new LongQueue(8);
        Assert.assertTrue((String)"New queue is not empty!", (q.size == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            int size;
            int j = 0;
            while (j < i) {
                try {
                    q.addLast(j);
                }
                catch (IllegalStateException e) {
                    Assert.fail((String)("Failed to add element " + j + " (" + i + ")"));
                }
                long peeked = q.last();
                Assert.assertTrue((String)("peekLast shows " + peeked + ", should be " + j + " (" + i + ")"), (peeked == (long)j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (j + 1) + " but is " + size + " (" + i + ")"), (size == j + 1 ? 1 : 0) != 0);
                ++j;
            }
            if (i != 0) {
                long peek = q.first();
                Assert.assertTrue((String)("First thing is not zero but " + peek + " (" + i + ")"), (peek == 0L ? 1 : 0) != 0);
            }
            j = 0;
            while (j < i) {
                long pop = q.removeFirst();
                Assert.assertTrue((String)("Popped should be " + j + " but is " + pop + " (" + i + ")"), (pop == (long)j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (i - 1 - j) + " but is " + size + " (" + i + ")"), (size == i - 1 - j ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((String)("Not empty after cycle " + i), (q.size == 0 ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 56) {
            q.addLast(42L);
            ++i;
        }
        q.clear();
        Assert.assertTrue((String)"Clear did not clear properly", (q.size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void resizableDequeTest() {
        LongQueue q = new LongQueue(8);
        Assert.assertTrue((String)"New deque is not empty!", (q.size == 0 ? 1 : 0) != 0);
        int i = 0;
        while (i < 100) {
            int size;
            int j = 0;
            while (j < i) {
                try {
                    q.addFirst(j);
                }
                catch (IllegalStateException e) {
                    Assert.fail((String)("Failed to add element " + j + " (" + i + ")"));
                }
                long peeked = q.first();
                Assert.assertTrue((String)("peek shows " + peeked + ", should be " + j + " (" + i + ")"), (peeked == (long)j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (j + 1) + " but is " + size + " (" + i + ")"), (size == j + 1 ? 1 : 0) != 0);
                ++j;
            }
            if (i != 0) {
                long peek = q.last();
                Assert.assertTrue((String)("Last thing is not zero but " + peek + " (" + i + ")"), (peek == 0L ? 1 : 0) != 0);
            }
            j = 0;
            while (j < i) {
                long pop = q.removeLast();
                Assert.assertTrue((String)("Popped should be " + j + " but is " + pop + " (" + i + ")"), (pop == (long)j ? 1 : 0) != 0);
                size = q.size;
                Assert.assertTrue((String)("Size should be " + (i - 1 - j) + " but is " + size + " (" + i + ")"), (size == i - 1 - j ? 1 : 0) != 0);
                ++j;
            }
            Assert.assertTrue((String)("Not empty after cycle " + i), (q.size == 0 ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 56) {
            q.addFirst(42L);
            ++i;
        }
        q.clear();
        Assert.assertTrue((String)"Clear did not clear properly", (q.size == 0 ? 1 : 0) != 0);
    }

    @Test
    public void getTest() {
        LongQueue q = new LongQueue(7);
        int i = 0;
        while (i < 5) {
            int j = 0;
            while (j < 4) {
                q.addLast(j);
                ++j;
            }
            Assert.assertEquals((String)("get(0) is not equal to peek (" + i + ")"), (long)q.get(0), (long)q.first());
            Assert.assertEquals((String)("get(size-1) is not equal to peekLast (" + i + ")"), (long)q.get(q.size - 1), (long)q.last());
            j = 0;
            while (j < 4) {
                Assert.assertTrue((q.get(j) == (long)j ? 1 : 0) != 0);
                ++j;
            }
            j = 0;
            while (j < 3) {
                q.removeFirst();
                Assert.assertEquals((String)("get(0) is not equal to peek (" + i + ")"), (long)q.get(0), (long)q.first());
                ++j;
            }
            q.removeFirst();
            assert (q.size == 0);
            try {
                q.get(0);
                Assert.fail((String)"get() on empty queue did not throw");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Test
    public void removeTest() {
        LongQueue q = new LongQueue();
        int j = 0;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0L, 1L, 2L, 3L, 4L, 5L, 6L);
        q.removeIndex(0);
        this.assertValues(q, 1L, 2L, 3L, 4L, 5L, 6L);
        q.removeIndex(1);
        this.assertValues(q, 1L, 3L, 4L, 5L, 6L);
        q.removeIndex(4);
        this.assertValues(q, 1L, 3L, 4L, 5L);
        q.removeIndex(2);
        this.assertValues(q, 1L, 3L, 5L);
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0L, 1L, 2L, 3L, 4L, 5L, 6L);
        q.removeIndex(1);
        this.assertValues(q, 0L, 2L, 3L, 4L, 5L, 6L);
        q.removeIndex(0);
        this.assertValues(q, 2L, 3L, 4L, 5L, 6L);
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        this.assertValues(q, 0L, 1L, 2L, 3L, 4L, 5L, 6L);
        q.removeIndex(5);
        this.assertValues(q, 0L, 1L, 2L, 3L, 4L, 6L);
        q.removeIndex(5);
        this.assertValues(q, 0L, 1L, 2L, 3L, 4L);
    }

    @Test
    public void indexOfTest() {
        LongQueue q = new LongQueue();
        int j = 0;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        j = 0;
        while (j <= 6) {
            Assert.assertEquals((long)q.indexOf(j), (long)j);
            ++j;
        }
        q.clear();
        j = 2;
        while (j >= 0) {
            q.addFirst(j);
            --j;
        }
        j = 3;
        while (j <= 6) {
            q.addLast(j);
            ++j;
        }
        j = 0;
        while (j <= 6) {
            Assert.assertEquals((long)q.indexOf(j), (long)j);
            ++j;
        }
    }

    @Test
    public void toStringTest() {
        LongQueue q = new LongQueue(1);
        Assert.assertTrue((boolean)q.toString().equals("[]"));
        q.addLast(4L);
        Assert.assertTrue((boolean)q.toString().equals("[4]"));
        q.addLast(5L);
        q.addLast(6L);
        q.addLast(7L);
        Assert.assertTrue((boolean)q.toString().equals("[4, 5, 6, 7]"));
    }

    @Test
    public void hashEqualsTest() {
        LongQueue q1 = new LongQueue();
        LongQueue q2 = new LongQueue();
        this.assertEqualsAndHash(q1, q2);
        q1.addFirst(1L);
        Assert.assertNotEquals((Object)q1, (Object)q2);
        q2.addFirst(1L);
        this.assertEqualsAndHash(q1, q2);
        q1.clear();
        q1.addLast(1L);
        q1.addLast(2L);
        q2.addLast(2L);
        this.assertEqualsAndHash(q1, q2);
        int i = 0;
        while (i < 100) {
            q1.addLast(i);
            q1.addLast(i);
            q1.removeFirst();
            Assert.assertNotEquals((Object)q1, (Object)q2);
            q2.addLast(i);
            q2.addLast(i);
            q2.removeFirst();
            this.assertEqualsAndHash(q1, q2);
            ++i;
        }
    }

    private void assertEqualsAndHash(LongQueue q1, LongQueue q2) {
        Assert.assertEquals((Object)q1, (Object)q2);
        Assert.assertEquals((String)"Hash codes are not equal", (long)q1.hashCode(), (long)q2.hashCode());
    }

    private void assertValues(LongQueue q, long ... values) {
        int i = 0;
        int n = values.length;
        while (i < n) {
            Assert.assertEquals((long)values[i], (long)q.get(i));
            ++i;
        }
    }
}

