/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.model;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterAbilityCard;
import com.esotericsoftware.gloomhavenhelper.model.MonsterAbility;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterStats;
import java.util.regex.Matcher;

public class Line {
    private static final ObjectMap<String, String> tokenText = new ObjectMap(64);
    private static String and;
    public final String line;
    public BitmapFont font;
    public final Array<LinePart> parts = new Array();
    public float x;
    public float y;
    public float width;
    public float height;
    public float spaceTop;

    public Line(String line, String previous, int id, Color color, float wrapWidth, int align) {
        char first;
        if (line == null) {
            throw new IllegalArgumentException("line cannot be null.");
        }
        this.line = line;
        if (line.charAt(0) == '!') {
            line = line.substring(1);
        }
        if ((first = line.charAt(0)) == '*') {
            this.font = color == Color.BLACK ? App.plainSmall : App.plainSmallOutline;
            line = line.substring(1);
            this.height = 10.0f;
            this.spaceTop = id < 0 ? 10 : 27;
            if (previous.equals("NORMAL:") || previous.equals("ELITE:") || previous.startsWith("*")) {
                this.spaceTop -= 16.0f;
            }
        } else if (line.charAt(0) == '^') {
            this.font = color == Color.BLACK ? App.plainMedium : App.plainMediumOutline;
            line = line.substring(1);
            this.height = 15.0f;
            this.spaceTop = 12.0f;
            if (id == 62) {
                this.spaceTop -= 1.0f;
            }
            if (id == 171) {
                this.spaceTop -= 2.0f;
            }
            if (id == 179) {
                this.spaceTop -= 1.0f;
            }
        } else {
            this.font = App.plainLargeOutline;
            this.height = 18.0f;
            this.spaceTop = previous.endsWith(and) ? 15 : 24;
            if (id == 62) {
                this.spaceTop -= 7.0f;
            }
            if (id == 171) {
                this.spaceTop -= 6.0f;
            }
            if (id == 172) {
                this.spaceTop -= 7.0f;
            }
            if (id == 174) {
                this.spaceTop -= 7.0f;
            }
            if (id == 179) {
                this.spaceTop -= 3.0f;
            }
            if (id >= 375 && id <= 377) {
                this.spaceTop -= 3.0f;
            }
            if (line.equals("ELITE:")) {
                color = App.eliteGold;
            }
            if (previous.equals("NORMAL:") || previous.equals("ELITE:")) {
                this.spaceTop -= 10.0f;
            }
        }
        if (line.indexOf(37) == -1) {
            this.addTextPart(line, color, wrapWidth, align);
            return;
        }
        try {
            Matcher matcher = MonsterAbilityCard.statsPattern.matcher(line);
            if (matcher.matches()) {
                String name;
                int end = line.indexOf(" + ");
                if (end == -1) {
                    end = line.indexOf(" - ");
                }
                end += 3;
                int n = line.length();
                while (end < n) {
                    char c = line.charAt(end);
                    if (c < '0' || c > '9') break;
                    ++end;
                }
                if (end == n) {
                    this.addParts(line, color, id);
                } else {
                    this.addParts(line.substring(0, end), color, id);
                    this.addParts(line.substring(end), color, id);
                }
                if (App.eclipse && matcher.group(2) == null && !(name = matcher.group(1)).equals("shield") && !name.equals("range")) {
                    throw new RuntimeException();
                }
            } else {
                this.addParts(line, color, id);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error parsing line: " + line, ex);
        }
    }

    private void addParts(String line, Color color, int id) {
        boolean inToken = false;
        int i = 0;
        int s = 0;
        int n = line.length();
        while (i < n) {
            char c = line.charAt(i);
            if (c == '%') {
                if (inToken) {
                    this.addIconPart(line.substring(s, i), id, color);
                    inToken = false;
                    s = i + 1;
                } else {
                    if (i - s > 0) {
                        this.addTextPart(line.substring(s, i), color, 0.0f, 0);
                    }
                    inToken = true;
                    s = i + 1;
                }
            }
            ++i;
        }
        if (i - s > 0) {
            this.addTextPart(line.substring(s, i), color, 0.0f, 0);
        }
    }

    private boolean isSmall() {
        return this.font == App.plainSmall || this.font == App.plainSmallOutline;
    }

    private boolean isMedium() {
        return this.font == App.plainMedium || this.font == App.plainMediumOutline;
    }

    private void addTextPart(String value, Color color, float wrapWidth, int align) {
        if (value == null) {
            return;
        }
        TextPart text = new TextPart(value, this.font, color);
        if (wrapWidth > 0.0f) {
            text.layout.setText(this.font, value, color, wrapWidth, align, true);
            this.height = Math.max(this.height, this.height + (float)(text.layout.runs.size - 1) * -this.font.getData().down);
            text.width = text.layout.width;
            text.layout.setText(this.font, value, color, text.width, align, true);
        } else {
            text.layout.setText(this.font, value, color, 0.0f, 8, false);
            text.x = this.width;
            text.width = text.layout.width;
        }
        if (text.width == 0.0f) {
            return;
        }
        this.width += text.width;
        if (value.equals(" ")) {
            return;
        }
        text.cache.setText(text.layout, 0.0f, 0.0f);
        this.parts.add(text);
        if (value.equals(":")) {
            if (this.isSmall()) {
                this.width -= 8.0f;
            } else {
                text.x -= 4.0f;
                this.width -= 6.0f;
            }
        }
    }

    private TextureRegion findRegion(String name, Color color) {
        TextureRegion region;
        String suffix;
        String string = suffix = color == Color.BLACK ? "-black" : "";
        if (this.isSmall()) {
            region = App.skin.optional("abilities/" + name + "-small" + suffix, TextureRegion.class);
            if (region != null) {
                return region;
            }
        } else if (this.isMedium()) {
            region = App.skin.optional("abilities/" + name + "-medium" + suffix, TextureRegion.class);
            if (region != null) {
                return region;
            }
            region = App.skin.optional("abilities/" + name + "-small" + suffix, TextureRegion.class);
            if (region != null) {
                return region;
            }
        }
        if ((region = App.skin.optional("abilities/" + name + suffix, TextureRegion.class)) != null) {
            return region;
        }
        if (color == Color.BLACK) {
            return this.findRegion(name, Color.WHITE);
        }
        throw new RuntimeException("Region not found: " + name);
    }

    private void addIconPart(String value, int id, Color color) {
        boolean move = value.equals("move");
        RegionPart icon = new RegionPart();
        icon.region = this.findRegion(value, color);
        if (move) {
            icon.flying = this.findRegion("flying", color);
        }
        icon.width = icon.region.getRegionWidth();
        String text = tokenText.get(value, "");
        this.addTextPart(text, color, 0.0f, 0);
        if (text.length() > 0 && text.equals(text.toUpperCase())) {
            if (this.isSmall()) {
                icon.x = 4.0f;
                icon.space = 4.0f;
            } else if (this.isMedium()) {
                icon.x = 6.0f;
                icon.space = 7.0f;
            } else {
                icon.x = 6.0f;
                icon.space = 7.0f;
            }
        } else if (this.isSmall()) {
            icon.x = move ? 2 : 4;
            icon.space = move ? 2 : 5;
        } else if (this.isMedium()) {
            icon.x = move ? 5 : 6;
            icon.space = move ? 5 : 8;
        } else {
            icon.x = move ? 9 : 12;
            icon.space = move ? 17 : 18;
        }
        icon.width += icon.space;
        icon.x += this.width;
        icon.y = Math.round((this.font.getData().capHeight - (float)icon.region.getRegionHeight()) / 2.0f);
        if (id == 179 && value.equals("earth")) {
            icon.y += 8.0f;
            this.height += 4.0f;
        }
        if (id == -46 && !App.config.isRussian()) {
            if (value.equals("boss-aoe-sightless-eye-sp1")) {
                icon.y -= 13.0f;
            }
            if (value.equals("boss-aoe-sightless-eye-sp2")) {
                icon.x -= 80.0f;
                icon.y -= 38.0f;
            }
        }
        if (id == -40 && value.equals("boss-aoe-elder-drake-sp1")) {
            icon.y = icon.y - (float)(App.config.isRussian() ? 23 : 20);
        }
        if (id == 207 && value.equals("aoe-circle")) {
            icon.y -= 33.0f;
        }
        if (id == 202 && value.equals("aoe-triangle-2-side")) {
            icon.y -= 17.0f;
        }
        if (id == 58 && value.equals("fire")) {
            this.height += 15.0f;
        }
        if (id == 228 && value.equals("air")) {
            this.height += 25.0f;
        }
        if (id == 264 && value.equals("aoe-arc-3")) {
            icon.x -= 10.0f;
            icon.y += 15.0f;
        }
        if (value.equals("use")) {
            icon.x -= icon.width;
            this.width -= icon.width;
            if (this.isSmall()) {
                this.parts.peek().x -= 5.0f;
                icon.x -= 5.0f;
                this.width -= 5.0f;
            }
        }
        if (this.font == App.plainLargeOutline && (move || value.equals("attack") || value.equals("heal") || value.equals("loot") || value.equals("shield") || value.equals("retaliate"))) {
            icon.y += 2.0f;
        }
        if (this.isMedium() && value.equals("retaliate")) {
            icon.y += 1.0f;
        }
        this.parts.add(icon);
        if (!value.contains("aoe")) {
            this.width += icon.width;
        } else {
            icon.y -= 2.0f;
            if (id == 3) {
                icon.y -= 17.0f;
            }
            if (id == 4) {
                icon.y -= 32.0f;
            }
            if (id == 7) {
                icon.y -= 17.0f;
            }
            if (id == 32 || id == 33) {
                icon.x += 8.0f;
                icon.y += 13.0f;
            }
            if (id == 41 || id == 42) {
                icon.x -= 8.0f;
                icon.y -= 10.0f;
            }
            if (id == 55) {
                this.height += 15.0f;
                icon.y += 15.0f;
            }
            if (id == 58) {
                icon.y -= 1.0f;
            }
            if (id == 68 || id == 69) {
                icon.y -= 12.0f;
            }
            if (id == 93) {
                icon.y += 24.0f;
            }
            if (id == 180 && !App.config.isRussian()) {
                icon.y += 37.0f;
            }
            if (id == 228) {
                icon.y = icon.y + (float)(value.equals("aoe-circle-with-side-black") ? 3 : 15);
            }
        }
        if (value.equals("use")) {
            this.addTextPart(":", color, 0.0f, 0);
        }
    }

    public void draw(Batch batch, float cardX, float cardY, MonsterData data, float alpha) {
        for (LinePart part : this.parts) {
            part.draw(batch, this, cardX, cardY, data, alpha);
        }
    }

    public boolean floatRight() {
        return this.line.charAt(0) == '!';
    }

    public String toString() {
        return this.line;
    }

    public static void loadAbilityLines(MonsterAbility card) {
        if (card.text.size == 0) {
            return;
        }
        float height = 0.0f;
        String previous = "";
        for (String text : card.text) {
            Line line = new Line(text, previous, card.id, Color.WHITE, 409.0f, 1);
            if (!line.floatRight()) {
                if (height > 0.0f) {
                    height += line.spaceTop;
                }
                height += line.height;
            } else if (card.lines.size >= 2 && card.lines.peek().floatRight()) {
                height += 24.0f;
            }
            card.lines.add(line);
            previous = text;
        }
        if (card.id == 48) {
            height += 36.0f;
        }
        if (card.id == 62) {
            height += 5.0f;
        }
        if (card.id == 151) {
            height += 5.0f;
        }
        if (card.id == 156 || card.id == 157) {
            height -= 24.0f;
        }
        if (card.id == 224) {
            height -= 7.0f;
        }
        if (card.id == 228) {
            height += 10.0f;
        }
        int x = 218;
        if (card.id == 180 && App.config.isRussian()) {
            x -= 30;
        }
        if (card.id >= 375 && card.id <= 377) {
            x += 20;
        }
        Line.layout(card.lines, x, 108 + Math.round(height / 2.0f), true, card.id);
        card.text.clear();
    }

    public static void loadSpecialLines(MonsterData data, MonsterStats stats) {
        Line line;
        if (stats.specialText1.size == 0) {
            return;
        }
        float wrapWidth = 212.0f;
        boolean russian = App.config.isRussian();
        if (russian) {
            wrapWidth = 225.0f;
        }
        if (data.id == -55) {
            wrapWidth = 999.0f;
        }
        if (data.id == -68) {
            wrapWidth = 234.0f;
        }
        float calculatedWrapWidth = wrapWidth;
        for (String text : stats.specialText1) {
            text = text.charAt(0) == '!' ? "!*" + text.substring(1) : "*" + text;
            line = new Line(text, "", data.id, Color.WHITE, wrapWidth, 8);
            stats.special1.add(line);
            if (!russian) {
                wrapWidth -= line.height;
            }
            if (wrapWidth < 150.0f) {
                wrapWidth = 150.0f;
            }
            text = Line.calculateSpecial(text, stats);
            line = new Line(text, "", data.id, Color.WHITE, calculatedWrapWidth, 8);
            stats.specialCalculated1.add(line);
            if (!russian) {
                calculatedWrapWidth -= line.height;
            }
            if (!(calculatedWrapWidth < 150.0f)) continue;
            calculatedWrapWidth = 150.0f;
        }
        for (String text : stats.specialText2) {
            text = text.charAt(0) == '!' ? "!*" + text.substring(1) : "*" + text;
            line = new Line(text, "", data.id, Color.WHITE, wrapWidth, 8);
            stats.special2.add(line);
            if (!russian) {
                wrapWidth -= line.height;
            }
            if (wrapWidth < 150.0f) {
                wrapWidth = 150.0f;
            }
            text = Line.calculateSpecial(text, stats);
            line = new Line(text, "", data.id, Color.WHITE, calculatedWrapWidth, 8);
            stats.specialCalculated2.add(line);
            if (!russian) {
                calculatedWrapWidth -= line.height;
            }
            if (!(calculatedWrapWidth < 150.0f)) continue;
            calculatedWrapWidth = 150.0f;
        }
        if (stats.notesText != null) {
            if (data.id == -39) {
                wrapWidth -= 45.0f;
                calculatedWrapWidth -= 45.0f;
            }
            stats.notes = new Line("*" + stats.notesText, "", data.id, Color.WHITE, wrapWidth, 8);
            stats.notesCalculated = new Line("*" + stats.notesText, "", data.id, Color.WHITE, calculatedWrapWidth, 8);
        }
        Line.layout(stats.special1, 0.0f, 0.0f, false, data.id);
        Line.layout(stats.special2, 0.0f, 0.0f, false, data.id);
        Line.layout(Array.with(stats.notes), 0.0f, 0.0f, false, data.id);
        Line.layout(stats.specialCalculated1, 0.0f, 0.0f, false, data.id);
        Line.layout(stats.specialCalculated2, 0.0f, 0.0f, false, data.id);
        Line.layout(Array.with(stats.notesCalculated), 0.0f, 0.0f, false, data.id);
        stats.specialText1.clear();
        stats.specialText2.clear();
    }

    /*
     * Unable to fully structure code
     */
    private static String calculateSpecial(String text, MonsterStats stats) {
        buffer = new StringBuffer(text.length());
        inToken = false;
        i = 0;
        s = 0;
        n = text.length();
        while (i < n) {
            block6: {
                block7: {
                    c = text.charAt(i);
                    if (c != '%') break block6;
                    if (!inToken) break block7;
                    inToken = false;
                    name = text.substring(s, i);
                    buffer.append('%');
                    buffer.append(name);
                    buffer.append('%');
                    if (n - i < 4 || !name.equals("move") && !name.equals("attack")) ** GOTO lbl-1000
                    dir = text.charAt(i + 2);
                    if (text.charAt(i + 1) != ' ' || dir != '+' && dir != '-' || text.charAt(i + 3) != ' ') ** GOTO lbl-1000
                    end = i + 4;
                    while (end < n) {
                        c = text.charAt(end);
                        if (c < '0' || c > '9') break;
                        ++end;
                    }
                    if (end != i + 4 && (value = Line.calculateSpecialValue(name, text.substring(i + 4, end), dir, stats)) != null) {
                        buffer.append(' ');
                        buffer.append(value);
                        i = end - 1;
                        s = end;
                    } else lbl-1000:
                    // 3 sources

                    {
                        s = i + 1;
                    }
                    break block6;
                }
                inToken = true;
                if (i - s > 0) {
                    buffer.append(text.substring(s, i));
                }
                s = i + 1;
            }
            ++i;
        }
        if (i - s > 0) {
            buffer.append(text.substring(s, i));
        }
        return buffer.toString();
    }

    private static String calculateSpecialValue(String name, String abilityString, char dir, MonsterStats stats) {
        String valueString;
        int ability;
        try {
            ability = App.parseInt(abilityString);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        if (dir == '-') {
            ability = -ability;
        }
        if (name.equals("attack")) {
            valueString = stats.attack;
        } else if (name.equals("move")) {
            valueString = stats.move;
        } else {
            throw new RuntimeException();
        }
        try {
            return Integer.toString(App.parseInt(valueString) + ability);
        }
        catch (NumberFormatException ex) {
            if (App.eclipse && !name.equals("attack")) {
                throw new RuntimeException(name);
            }
            try {
                stats.attack();
                if (ability > 9 || ability < -9) {
                    throw new RuntimeException();
                }
                return "!!" + dir + Math.abs(ability);
            }
            catch (NumberFormatException ex2) {
                return null;
            }
        }
    }

    public static void loadAttributeLines(MonsterData data, MonsterStats stats, boolean elite) {
        if (stats.attributeText.size == 0) {
            return;
        }
        float y = 0.0f;
        int i = 0;
        for (String text : stats.attributeText) {
            if (text.charAt(0) != '*') {
                text = "^" + text;
            }
            Line line = new Line(text, "", -1, elite ? Color.WHITE : Color.BLACK, 148.0f, elite ? 8 : 16);
            if (i > 0 && line.isSmall()) {
                line.spaceTop -= 11.0f;
                line.height += 10.0f;
            }
            if (i != 0) {
                y -= line.spaceTop;
            }
            if (!elite) {
                line.x = Math.max(-18.0f, 130.0f - line.width);
            }
            line.y = y;
            stats.attributeLines.add(line);
            y -= line.height + 5.0f;
            ++i;
        }
        stats.attributeText.clear();
    }

    public static void layout(Array<Line> lines, float x, float y, boolean center, int id) {
        int i = 0;
        int n = lines.size;
        while (i < n) {
            Line line = lines.get(i);
            if (i != 0) {
                y -= line.spaceTop;
            }
            line.x = center ? x - (float)Math.round(line.width / 2.0f) : x;
            line.y += (y -= line.height);
            if (i < n - 1 && lines.get(i + 1).floatRight()) {
                Line wrap1 = lines.get(++i);
                if (i < n - 1 && lines.get(i + 1).floatRight()) {
                    Line wrap2 = lines.get(++i);
                    float iconWidth = line.width;
                    line.width += Math.max(wrap1.width, wrap2.width);
                    line.height = iconWidth;
                    wrap1.height = 0.0f;
                    wrap2.height = 0.0f;
                    line.x = center ? x - (float)Math.round(line.width / 2.0f) - 8.0f : x;
                    line.y = y -= 12.0f;
                    wrap1.x += line.x + iconWidth;
                    if (wrap1.parts.first() instanceof TextPart) {
                        wrap1.x += 12.0f;
                    }
                    float spreadY = wrap1.isSmall() ? (id < 0 ? 8 : 12) : 15;
                    wrap1.y = y + spreadY;
                    wrap2.x += line.x + iconWidth;
                    if (wrap2.parts.first() instanceof TextPart) {
                        wrap2.x += 12.0f;
                    }
                    if (wrap2.line.equals("!^Self")) {
                        wrap2.x += (float)Math.round((wrap1.width - wrap2.width) / 2.0f);
                    }
                    wrap2.y = y - spreadY;
                    y -= 12.0f;
                } else {
                    float iconWidth = line.width;
                    line.width += wrap1.width;
                    line.x = center ? x - (float)Math.round(line.width / 2.0f) - 8.0f : x;
                    wrap1.x += line.x + iconWidth;
                    if (wrap1.parts.first() instanceof TextPart) {
                        wrap1.x += 12.0f;
                    }
                    wrap1.y = y;
                }
            }
            ++i;
        }
    }

    public static void loadTokens(JsonValue tokens) {
        tokenText.clear();
        tokenText.put("attack", tokens.getString("attack"));
        tokenText.put("move", tokens.getString("move"));
        tokenText.put("range", tokens.getString("range"));
        tokenText.put("heal", tokens.getString("heal"));
        tokenText.put("target", tokens.getString("target"));
        tokenText.put("shield", tokens.getString("shield"));
        tokenText.put("loot", tokens.getString("loot"));
        tokenText.put("retaliate", tokens.getString("retaliate"));
        tokenText.put("jump", tokens.getString("jump"));
        tokenText.put("stun", tokens.getString("stun"));
        tokenText.put("wound", tokens.getString("wound"));
        tokenText.put("disarm", tokens.getString("disarm"));
        tokenText.put("immobilize", tokens.getString("immobilize"));
        tokenText.put("poison", tokens.getString("poison"));
        tokenText.put("invisible", tokens.getString("invisible"));
        tokenText.put("strengthen", tokens.getString("strengthen"));
        tokenText.put("muddle", tokens.getString("muddle"));
        tokenText.put("regenerate", tokens.getString("regenerate"));
        tokenText.put("push", tokens.getString("push"));
        tokenText.put("pull", tokens.getString("pull"));
        tokenText.put("pierce", tokens.getString("pierce"));
        tokenText.put("curse", tokens.getString("curse"));
        tokenText.put("bless", tokens.getString("bless"));
        and = tokens.getString("and");
    }

    public static abstract class LinePart {
        public float x;
        public float y;
        public float width;
        public float space;

        public abstract void draw(Batch var1, Line var2, float var3, float var4, MonsterData var5, float var6);
    }

    public static class RegionPart
    extends LinePart {
        TextureRegion region;
        TextureRegion flying;

        @Override
        public void draw(Batch batch, Line line, float cardX, float cardY, MonsterData data, float alpha) {
            if (data != null && data.flying && this.flying != null) {
                batch.draw(this.flying, cardX + line.x + this.x - 3.0f, cardY + line.y + this.y);
            } else {
                batch.draw(this.region, cardX + line.x + this.x, cardY + line.y + this.y);
            }
        }
    }

    public static class TextPart
    extends LinePart {
        public final String text;
        private final Color color = new Color();
        public final GlyphLayout layout = new GlyphLayout();
        final BitmapFontCache cache;

        public TextPart(String text, BitmapFont font, Color color) {
            this.text = text;
            this.color.set(color);
            this.cache = new BitmapFontCache(font);
        }

        @Override
        public void draw(Batch batch, Line line, float cardX, float cardY, MonsterData data, float alpha) {
            this.cache.setPosition(cardX + line.x + this.x, cardY + line.y + this.y + this.layout.height);
            this.color.a = alpha;
            this.cache.setColors(this.color.toFloatBits());
            this.cache.draw(batch);
        }
    }
}

