/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.ImageTextButton;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.util.Menu;
import com.esotericsoftware.gloomhavenhelper.util.builders.ImageTextButtonBuilder;
import com.esotericsoftware.gloomhavenhelper.util.builders.TextButtonBuilder;

public class TextMenu
extends Menu {
    public final Table table = new Table();
    private final ScrollPane scroll;

    public TextMenu() {
        this.table.defaults().growX();
        this.scroll = new ScrollPane((Actor)this.table);
        this.scroll.getStyle().vScrollKnob = App.skin.getDrawable("scroll-vert");
        this.scroll.setFadeScrollBars(false);
        this.scroll.setupFadeScrollBars(0.4f, 0.0f);
        this.scroll.setScrollBarTouch(false);
        this.scroll.setScrollingDisabled(true, false);
        this.scroll.setFlickScrollTapSquareSize(35.0f);
        this.add(this.scroll).grow().fill();
    }

    @Override
    public boolean show(Actor positionActor, float positionX, float positionY, float positionWidth, float positionHeight, boolean preferRight) {
        this.scroll.setScrollY(0.0f);
        App.stage.setScrollFocus(this.scroll);
        return super.show(positionActor, positionX, positionY, positionWidth, positionHeight, preferRight);
    }

    public Container seperator() {
        return new Container<Image>(new Image(App.drawable("white", App.buttonGray))).height(1.0f).pad(9.0f, 20.0f, 9.0f, 20.0f).fillX();
    }

    public Cell addSeperator() {
        return this.table.add(this.seperator());
    }

    public TextButton textItem(String text, ChangeListener listener) {
        Button button = ((TextButtonBuilder)((TextButtonBuilder)App.textButton(text).change(listener)).align(8)).create();
        button.pad(0.0f, 20.0f, 0.0f, 20.0f);
        ((TextButton)button).getLabelCell().height(80.0f);
        button.invalidate();
        return button;
    }

    public Cell<TextButton> addTextItem(String text, ChangeListener listener) {
        return this.table.add(this.textItem(text, listener));
    }

    public Cell<ImageTextButton> addImageTextItem(String text, String imageUp, ChangeListener listener) {
        ImageTextButton button = ((ImageTextButtonBuilder)App.imageTextButton(text).imageUp(imageUp, App.darken).imageOver(imageUp).imageDisabled(imageUp, App.disabledDim).change(listener)).align(8).create();
        button.pad(0.0f, 20.0f, 0.0f, 20.0f);
        button.getLabelCell().height(80.0f);
        button.invalidate();
        return this.table.add(button);
    }

    public CheckBox checkBoxItem(String text, boolean checked, ChangeListener listener) {
        CheckBox checkbox = App.checkbox(text);
        checkbox.setChecked(checked);
        checkbox.pad(0.0f, 20.0f, 0.0f, 20.0f);
        checkbox.getLabelCell().height(80.0f);
        checkbox.invalidate();
        if (listener != null) {
            checkbox.addListener(listener);
        }
        return checkbox;
    }

    public CheckBox radioItem(String text, boolean checked, ChangeListener listener) {
        CheckBox checkbox = App.radio(text);
        checkbox.setChecked(checked);
        checkbox.pad(0.0f, 20.0f, 0.0f, 20.0f);
        checkbox.getLabelCell().height(80.0f);
        checkbox.invalidate();
        if (listener != null) {
            checkbox.addListener(listener);
        }
        return checkbox;
    }

    public Cell<CheckBox> addCheckBoxItem(String text, boolean checked, ChangeListener listener) {
        return this.table.add(this.checkBoxItem(text, checked, listener));
    }
}

