/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.gloomhavenhelper.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.actions.TemporalAction;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.HorizontalGroup;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.utils.DragListener;
import com.badlogic.gdx.scenes.scene2d.utils.DragScrollListener;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.SnapshotArray;
import com.esotericsoftware.gloomhavenhelper.App;
import com.esotericsoftware.gloomhavenhelper.MonsterBox;
import com.esotericsoftware.gloomhavenhelper.model.Condition;
import com.esotericsoftware.gloomhavenhelper.model.Monster;
import com.esotericsoftware.gloomhavenhelper.model.MonsterData;
import com.esotericsoftware.gloomhavenhelper.model.MonsterType;
import com.esotericsoftware.gloomhavenhelper.model.PlayerInit;
import com.esotericsoftware.gloomhavenhelper.model.SummonColor;
import com.esotericsoftware.gloomhavenhelper.util.Animator;

public abstract class Row
extends Table
implements Comparable<Row>,
Animator.HasAnimator {
    public static boolean animatedHeight = true;
    private static final float readyDuration = 0.5f;
    public float finalX;
    public float finalY;
    public Actor dragStartActor;
    public boolean desatDisabled;
    public float readyTime;
    public Animator animator = new Animator(this, 250.0f, 3000.0f, 500.0f);
    public HorizontalGroup monstersGroup;
    public Cell<HorizontalGroup> monstersCell;
    public float animateHeight;
    public final Array<MonsterBox> boxes = new Array();
    public boolean turnComplete;
    public DragListener dragListener = new DragListener(){
        DragScrollListener dragScroll;
        {
            this.dragScroll = new DragScrollListener(App.gloom.rowsScroll);
            this.dragScroll.setup(30.0f, 75.0f, 0.05f, 0.9f);
            this.setTapSquareSize(34.0f);
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            event.stop();
            return super.touchDown(event, x, y, pointer, button);
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            super.touchDragged(event, (App.state.playerInit == PlayerInit.dragNumber || App.state.playerInit == PlayerInit.dragNumberRequired) && App.dragRow == null ? this.getTouchDownX() : x, y, pointer);
        }

        @Override
        public void dragStart(InputEvent event, float x, float y, int pointer) {
            if (App.dragRow != null) {
                return;
            }
            if (App.state.canDraw) {
                App.stage.cancelTouchFocus();
                return;
            }
            App.dragging = true;
            App.dragRow = Row.this;
            App.lastSwapRow = null;
            event.getListenerActor().localToAscendantCoordinates(App.dragRow, App.dragStart.set(x, y));
            App.stage.cancelTouchFocusExcept(this, Row.this.dragStartActor);
        }

        @Override
        public void drag(InputEvent event, float x, float y, int pointer) {
            App.gloom.updateDrag(event.getStageX(), event.getStageY());
            this.dragScroll.drag(event, x, y, pointer);
        }

        @Override
        public void dragStop(InputEvent event, float x, float y, int pointer) {
            this.dragScroll.dragStop(event, x, y, pointer);
            App.state.changed();
            App.dragging = false;
            MoveToAction move = Actions.moveTo(Row.this.finalX, Row.this.finalY, 0.25f, Interpolation.fastSlow);
            move.setActor(Row.this);
            App.stage.addAction(Actions.sequence((Action)move, new Action(){

                @Override
                public boolean act(float delta) {
                    if (!App.dragging) {
                        App.dragRow = null;
                        Animator.storeChildren(App.gloom.rows, 0.0f);
                    }
                    return true;
                }
            }));
        }
    };

    public Row() {
        super(App.skin);
        this.monstersGroup = new HorizontalGroup(){

            @Override
            public void invalidate() {
                if (!Animator.enabled || !Animator.childrenAnimating(this)) {
                    super.invalidate();
                }
            }

            @Override
            public void draw(Batch batch, float parentAlpha) {
                Animator.updateChildren(this);
                super.draw(batch, parentAlpha);
            }
        }.space(9.0f).wrap().wrapSpace(4.0f).rowAlign(8).bottom();
        this.top();
    }

    @Override
    public void act(float delta) {
        super.act(delta);
        this.readyTime -= delta;
    }

    public boolean isCurrentTurn() {
        if (this.turnComplete) {
            return false;
        }
        if (!this.isAlive()) {
            return false;
        }
        SnapshotArray<Actor> children = App.gloom.rows.getChildren();
        int i = 0;
        int n = children.size;
        while (i < n) {
            Row row = (Row)children.get(i);
            if (row == this) {
                return true;
            }
            if (!row.turnComplete && row.isAlive()) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public void setTurnComplete(boolean ready, boolean animate) {
        if (this.turnComplete == ready) {
            return;
        }
        this.turnComplete = ready;
        this.readyTime = animate ? 0.5f : 0.0f;
    }

    public float desat() {
        if (this.desatDisabled) {
            return 0.0f;
        }
        float desat = Math.min(1.0f, 1.0f - this.readyTime / 0.5f);
        if (!this.turnComplete) {
            desat = 1.0f - desat;
        }
        return desat;
    }

    public void beginDesat(Batch batch) {
        float desat;
        if (this.readyTime > 0.0f) {
            Gdx.graphics.requestRendering();
        }
        if ((desat = this.desat()) > 0.0f) {
            batch.setShader(App.desatShader);
            App.desatShader.setUniformf("u_desat", this.turnComplete ? Interpolation.fastSlow.apply(desat) : Interpolation.slowFast.apply(desat));
        }
    }

    public void endDesat(Batch batch) {
        if (this.desat() > 0.0f) {
            batch.setShader(null);
        }
    }

    public abstract int getInitiative();

    public abstract boolean hasExpiringConditions();

    public abstract boolean isAlive();

    public abstract void setLevel(int var1);

    public abstract int getLevel();

    public void turnStart(boolean endOfRound) {
        Array<String> names = new Array<String>(2);
        for (MonsterBox box : this.boxes) {
            names.clear();
            if (box.monster.conditions.contains(Condition.regenerate, true)) {
                names.add("regenerate");
            }
            if (box.monster.conditions.contains(Condition.wound, true)) {
                names.add("wound");
            }
            box.flashIcons(names);
        }
        if (App.config.autoScroll) {
            App.gloom.rowsScroll.scrollTo(this.getX(), this.getY(), this.getWidth(), this.getHeight(), false, true);
        }
    }

    public void turnStartRevert() {
        if (App.config.autoScroll) {
            App.gloom.rowsScroll.scrollTo(this.getX(), this.getY(), this.getWidth(), this.getHeight(), false, true);
        }
    }

    public void turnEnd(boolean endOfRound) {
        if (this.turnComplete) {
            return;
        }
        SnapshotArray<Actor> children = App.gloom.rows.getChildren();
        if (!endOfRound) {
            int i = 0;
            int n = children.size;
            while (i < n) {
                Row row = (Row)children.get(i);
                if (row == this) break;
                if (!row.turnComplete) {
                    row.turnEnd(endOfRound);
                }
                ++i;
            }
            if (this.isAlive()) {
                this.setTurnComplete(true, true);
            }
        }
        if (this.turnComplete) {
            int next = this.getZIndex() + 1;
            while (next < children.size) {
                Row row;
                if (!(row = (Row)children.get(next++)).isAlive() || row.turnComplete) continue;
                row.turnStart(endOfRound);
                break;
            }
        }
        if (App.state.expireConditions) {
            for (MonsterBox box : this.boxes) {
                int i = box.monster.conditions.size - 1;
                while (i >= 0) {
                    Condition condition = box.monster.conditions.get(i);
                    switch (condition) {
                        case stun: 
                        case immobilize: 
                        case disarm: 
                        case muddle: 
                        case strengthen: 
                        case invisible: {
                            if (box.monster.currentTurnConditions.contains(condition, true)) break;
                            box.monster.conditions.removeIndex(i);
                            box.monster.expiredConditions.add(condition);
                        }
                    }
                    --i;
                }
            }
        }
    }

    public void turnEndRevert() {
        Row row;
        if (!this.turnComplete) {
            return;
        }
        SnapshotArray<Actor> children = App.gloom.rows.getChildren();
        int i = this.getZIndex() + 1;
        int n = children.size;
        while (i < n) {
            row = (Row)children.get(i);
            if (row.turnComplete) {
                row.turnEndRevert();
            }
            ++i;
        }
        if (this.turnComplete) {
            int next = this.getZIndex() + 1;
            while (next < children.size) {
                Row row2;
                if (!(row2 = (Row)children.get(next++)).isAlive() || row2.turnComplete) continue;
                row2.turnStartRevert();
                break;
            }
        }
        if (this.isAlive()) {
            this.setTurnComplete(false, true);
        }
        i = this.getZIndex() + 1;
        n = children.size;
        while (i < n) {
            row = (Row)children.get(i);
            if (row.turnComplete) {
                row.turnEndRevert();
            }
            ++i;
        }
        Array<String> names = new Array<String>(2);
        for (MonsterBox box : this.boxes) {
            names.clear();
            if (box.monster.conditions.contains(Condition.regenerate, true)) {
                names.add("regenerate");
            }
            if (box.monster.conditions.contains(Condition.wound, true)) {
                names.add("wound");
            }
            box.flashIcons(names);
            box.monster.conditions.addAll(box.monster.expiredConditions);
            box.monster.conditions.sort();
            box.monster.expiredConditions.clear();
        }
    }

    public void roundEnd() {
        this.setTurnComplete(false, true);
        for (MonsterBox box : this.boxes) {
            box.animator.finish(false);
            box.animator.store(0.0f);
            box.monster.isNew = false;
            box.monster.expiredConditions.clear();
            box.monster.currentTurnConditions.clear();
            if (!box.monster.conditions.contains(Condition.summonNew, true)) continue;
            box.monster.conditions.removeValue(Condition.summonNew, true);
            box.monster.conditions.add(Condition.summon);
            box.monster.conditions.sort();
        }
        this.boxes.sort();
        this.monstersGroup.getChildren().sort();
        this.monstersGroup.invalidate();
        Animator.storeChildren(this.monstersGroup, 0.0f);
    }

    @Override
    public Animator getAnimator() {
        return this.animator;
    }

    public void animateIcon(Actor actor, String name, float scale, float x, float y) {
        Vector2 position = actor.localToStageCoordinates(App.v2.set(x, y));
        Container<Image> icon = new Container<Image>(App.image(name));
        icon.setTouchable(Touchable.disabled);
        icon.setPosition(position.x, position.y);
        icon.setTransform(true);
        icon.setOrigin(icon.getWidth() / 2.0f, icon.getHeight() / 2.0f);
        icon.setScale(0.3f, 0.3f);
        icon.getColor().a = 0.0f;
        icon.addAction(Actions.sequence((Action)Actions.parallel((Action)Actions.fadeIn(0.2f), (Action)Actions.scaleTo(scale, scale, 0.4f, Interpolation.fastSlow)), (Action)Actions.parallel((Action)Actions.sequence((Action)Actions.delay(0.1f), (Action)Actions.fadeOut(0.3f)), (Action)Actions.scaleTo(1.0f, 1.0f, 0.4f, Interpolation.slowFast)), (Action)Actions.removeActor()));
        App.stage.addActor(icon);
    }

    public MonsterBox addMonsterBox(int number, MonsterData data, int level, boolean elite, SummonColor color, boolean sort) {
        MonsterType type = data == App.summonData ? MonsterType.summon : (data.isBoss() ? MonsterType.boss : (elite ? MonsterType.elite : MonsterType.normal));
        MonsterBox box = new MonsterBox(this, new Monster(data, type, level, number), this.monstersGroup.getScaleX());
        box.monster.summonColor = color;
        if (App.state.scenarioNumber == 49 && elite && data.name.equals("Ancient Artillery")) {
            box.monster.hpMax *= 2;
            box.monster.hp = box.monster.hpMax;
            box.monster.conditions.add(Condition.star);
        }
        if (App.state.scenarioNumber == 57 && elite && data.name.equals("Harrower Infester")) {
            box.monster.conditions.add(Condition.star);
        }
        if (App.state.scenarioNumber == 58 && elite && data.name.equals("City Guard")) {
            box.monster.conditions.add(Condition.star);
        }
        if (App.state.scenarioNumber == 67 && elite && data.name.equals("Stone Golem")) {
            box.monster.hpMax *= App.gloom.playerCount();
            box.monster.hp = box.monster.hpMax;
            box.monster.conditions.add(Condition.star);
        }
        if (App.state.scenarioNumber == 110 && elite) {
            if (data.name.equals("Vermling Shaman") || data.name.equals("City Guard") || data.name.equals("Savvas Lavaflow")) {
                box.monster.hp = box.monster.hpMax = (int)Math.ceil(App.gloom.playerCount() * box.monster.hpMax / 2);
                box.monster.conditions.add(Condition.star);
            } else if (data.name.equals("Valrath Tracker")) {
                box.monster.conditions.add(Condition.star);
            }
        }
        if (App.state.scenarioNumber == 111 && elite && data.name.equals("Aesther Ashblade")) {
            box.monster.hp = box.monster.hpMax = App.gloom.playerCount() * box.monster.hpMax;
            box.monster.conditions.add(Condition.star);
        }
        box.monster.conditions.sort();
        float time = 0.45f;
        Animator.enabled = false;
        final float startHeight = this.getPrefHeight();
        this.boxes.add(box);
        if (sort) {
            this.boxes.sort();
        }
        this.monstersGroup.addActor(box);
        if (sort) {
            this.monstersGroup.getChildren().sort();
        }
        final float endHeight = this.getPrefHeight();
        Animator.enabled = true;
        if (startHeight != endHeight) {
            this.animateHeight = startHeight;
            App.gloom.rows.addAction(Actions.sequence((Action)new TemporalAction(0.5f){

                @Override
                protected void update(float percent) {
                    Row.this.animateHeight = Interpolation.fastSlow.apply(startHeight, endHeight, percent);
                    Row.this.invalidateHierarchy();
                }

                @Override
                protected void end() {
                    Row.this.animateHeight = 0.0f;
                    Row.this.invalidateHierarchy();
                }
            }));
        }
        Animator.storeChildren(this.monstersGroup, 0.0f);
        this.monsterAdded();
        box.animator.finish(false);
        box.animator.store(0.0f);
        box.getColor().a = 0.0f;
        box.addAction(Actions.fadeIn(time, Interpolation.fastSlow));
        box.moveBy(0.0f, type == MonsterType.summon ? -80 : 80);
        return box;
    }

    protected void monsterAdded() {
    }

    @Override
    public int compareTo(Row row) {
        return this.getInitiative() - row.getInitiative();
    }
}

