/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

import cc.mallet.types.Alphabet;
import cc.mallet.types.FeatureVector;
import cc.mallet.util.Randoms;
import java.text.NumberFormat;
import java.util.Arrays;

public class MVNormal {
    public static double[] cholesky(double[] input, int numRows) {
        double[] result = new double[input.length];
        double sumRowSquared = 0.0;
        double dotProduct = 0.0;
        int rowOffset = 0;
        int colOffset = 0;
        for (int row = 0; row < numRows; ++row) {
            sumRowSquared = 0.0;
            rowOffset = row * numRows;
            for (int col = 0; col < row; ++col) {
                dotProduct = 0.0;
                colOffset = col * numRows;
                for (int i = 0; i < col; ++i) {
                    dotProduct += result[rowOffset + i] * result[colOffset + i];
                }
                result[rowOffset + col] = (input[rowOffset + col] - dotProduct) / result[colOffset + col];
                sumRowSquared += result[rowOffset + col] * result[rowOffset + col];
            }
            result[rowOffset + row] = Math.sqrt(input[rowOffset + row] - sumRowSquared);
        }
        return result;
    }

    public static double[] bandCholesky(double[] input, int numRows) {
        double[] result = new double[input.length];
        double sumRowSquared = 0.0;
        double dotProduct = 0.0;
        int rowOffset = 0;
        int colOffset = 0;
        for (int row = 0; row < numRows; ++row) {
            sumRowSquared = 0.0;
            rowOffset = row * numRows;
            int firstNonZero = row;
            for (int col = 0; col < row; ++col) {
                if (firstNonZero == row) {
                    if (input[rowOffset + col] == 0.0) continue;
                    firstNonZero = col;
                }
                dotProduct = 0.0;
                colOffset = col * numRows;
                for (int i = firstNonZero; i < col; ++i) {
                    dotProduct += result[rowOffset + i] * result[colOffset + i];
                }
                result[rowOffset + col] = (input[rowOffset + col] - dotProduct) / result[colOffset + col];
                sumRowSquared += result[rowOffset + col] * result[rowOffset + col];
            }
            result[rowOffset + row] = Math.sqrt(input[rowOffset + row] - sumRowSquared);
        }
        return result;
    }

    public static double[] bandMatrixRoot(int dim, int bandwidth) {
        double[] result = new double[dim * dim];
        for (int row = 0; row < dim; ++row) {
            int rowOffset = row * dim;
            for (int col = Math.max(0, row - bandwidth + 1); col <= row; ++col) {
                result[rowOffset + col] = 1.0;
            }
        }
        return result;
    }

    public static double[] nextMVNormal(double[] mean, double[] precision, Randoms random) {
        return MVNormal.nextMVNormalWithCholesky(mean, MVNormal.cholesky(precision, mean.length), random);
    }

    public static double[] nextMVNormalWithCholesky(double[] mean, double[] precisionLowerTriangular, Randoms random) {
        int i;
        int n = mean.length;
        double[] result = new double[n];
        for (int i2 = 0; i2 < n; ++i2) {
            result[i2] = random.nextGaussian();
        }
        for (i = n - 1; i >= 0; --i) {
            double innerProduct = 0.0;
            for (int j = i + 1; j < n; ++j) {
                innerProduct += result[j] * precisionLowerTriangular[n * j + i];
            }
            result[i] = (result[i] - innerProduct) / precisionLowerTriangular[n * i + i];
        }
        for (i = 0; i < n; ++i) {
            int n2 = i;
            result[n2] = result[n2] + mean[i];
        }
        return result;
    }

    public static double[][] nextMVNormal(int n, double[] mean, double[] precision, Randoms random) {
        double[][] result = new double[n][];
        for (int i = 0; i < n; ++i) {
            result[i] = MVNormal.nextMVNormal(mean, precision, random);
        }
        return result;
    }

    public static FeatureVector nextFeatureVector(Alphabet alphabet, double[] mean, double[] precision, Randoms random) {
        return new FeatureVector(alphabet, MVNormal.nextMVNormal(mean, precision, random));
    }

    public static double[] nextMVNormalPosterior(double[] priorMean, double[] priorPrecisionDiagonal, double[] precision, double[] observedMean, int observations, Randoms random) {
        int dimension = priorMean.length;
        double[] linearCombination = new double[dimension];
        int i = 0;
        while (i < dimension) {
            linearCombination[i] = priorMean[i] * priorPrecisionDiagonal[i];
            double innerProduct = 0.0;
            for (int j = 0; j < dimension; ++j) {
                innerProduct += precision[dimension * i + j] * observedMean[j];
            }
            int n = i++;
            linearCombination[n] = linearCombination[n] + (double)observations * innerProduct;
        }
        double[] posteriorPrecision = new double[precision.length];
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col < dimension; ++col) {
                posteriorPrecision[dimension * row + col] = (double)observations * precision[dimension * row + col];
                if (row != col) continue;
                int n = dimension * row + col;
                posteriorPrecision[n] = posteriorPrecision[n] + priorPrecisionDiagonal[row];
            }
        }
        double[] inversePosteriorPrecision = MVNormal.invertSPD(posteriorPrecision, dimension);
        double[] posteriorMean = new double[dimension];
        for (int row = 0; row < dimension; ++row) {
            double innerProduct = 0.0;
            for (int col = 0; col < dimension; ++col) {
                innerProduct += inversePosteriorPrecision[dimension * row + col] * linearCombination[col];
            }
            posteriorMean[row] = innerProduct;
        }
        return MVNormal.nextMVNormal(posteriorMean, posteriorPrecision, random);
    }

    public static double[] invertLowerTriangular(double[] inputMatrix, int dimension) {
        double[] outputMatrix = new double[inputMatrix.length];
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col <= row; ++col) {
                double x = col == row ? 1.0 : 0.0;
                for (int i = col; i < row; ++i) {
                    x -= inputMatrix[dimension * row + i] * outputMatrix[dimension * i + col];
                }
                outputMatrix[dimension * row + col] = x / inputMatrix[dimension * row + row];
            }
        }
        return outputMatrix;
    }

    public static double[] lowerTriangularCrossproduct(double[] inputMatrix, int dimension) {
        double[] outputMatrix = new double[inputMatrix.length];
        for (int row = 0; row < dimension; ++row) {
            for (int col = row; col < dimension; ++col) {
                double innerProduct = 0.0;
                for (int i = col; i < dimension; ++i) {
                    innerProduct += inputMatrix[row + dimension * i] * inputMatrix[col + dimension * i];
                }
                outputMatrix[dimension * row + col] = innerProduct;
                outputMatrix[row + dimension * col] = innerProduct;
            }
        }
        return outputMatrix;
    }

    public static double[] lowerTriangularProduct(double[] leftMatrix, double[] rightMatrix, int dimension) {
        double[] outputMatrix = new double[leftMatrix.length];
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col <= row; ++col) {
                double innerProduct = 0.0;
                for (int i = col; i <= row; ++i) {
                    innerProduct += leftMatrix[dimension * row + i] * rightMatrix[dimension * i + col];
                }
                outputMatrix[dimension * row + col] = innerProduct;
            }
        }
        return outputMatrix;
    }

    public static double[] invertSPD(double[] inputMatrix, int dimension) {
        return MVNormal.lowerTriangularCrossproduct(MVNormal.invertLowerTriangular(MVNormal.bandCholesky(inputMatrix, dimension), dimension), dimension);
    }

    public static double[] nextWishart(double[] sqrtScaleMatrix, int dimension, int degreesOfFreedom, Randoms random) {
        double[] sample = new double[sqrtScaleMatrix.length];
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col < row; ++col) {
                sample[row * dimension + col] = random.nextGaussian(0.0, 1.0);
            }
            sample[row * dimension + row] = Math.sqrt(random.nextChiSq(degreesOfFreedom));
        }
        System.out.println(MVNormal.diagonalToString(sample, dimension));
        System.out.println(MVNormal.diagonalToString(sqrtScaleMatrix, dimension));
        System.out.println(MVNormal.diagonalToString(MVNormal.lowerTriangularProduct(sample, sqrtScaleMatrix, dimension), dimension));
        return MVNormal.lowerTriangularCrossproduct(MVNormal.lowerTriangularProduct(sample, sqrtScaleMatrix, dimension), dimension);
    }

    public static double[] nextWishartPosterior(double[] scatterMatrix, int observations, double[] priorPrecisionDiagonal, int priorDF, int dimension, Randoms random) {
        double[] scatterPlusPrior = new double[scatterMatrix.length];
        System.arraycopy(scatterMatrix, 0, scatterPlusPrior, 0, scatterMatrix.length);
        for (int i = 0; i < dimension; ++i) {
            int n = dimension * i + i;
            scatterPlusPrior[n] = scatterPlusPrior[n] + 1.0 / priorPrecisionDiagonal[i];
        }
        System.out.println(" inverted scatter plus prior");
        System.out.println(MVNormal.diagonalToString(MVNormal.invertSPD(scatterPlusPrior, dimension), dimension));
        System.out.println(" chol inverted scatter plus prior");
        System.out.println(MVNormal.diagonalToString(MVNormal.cholesky(MVNormal.invertSPD(scatterPlusPrior, dimension), dimension), dimension));
        double[] sqrtScaleMatrix = MVNormal.cholesky(MVNormal.invertSPD(scatterPlusPrior, dimension), dimension);
        return MVNormal.nextWishart(sqrtScaleMatrix, dimension, observations + priorDF, random);
    }

    public static String doubleArrayToString(double[] matrix, int dimension) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(10);
        StringBuffer output = new StringBuffer();
        for (int row = 0; row < dimension; ++row) {
            for (int col = 0; col < dimension; ++col) {
                output.append(formatter.format(matrix[dimension * row + col]));
                output.append("\t");
            }
            output.append("\n");
        }
        return output.toString();
    }

    public static String diagonalToString(double[] matrix, int dimension) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(4);
        StringBuffer output = new StringBuffer();
        for (int row = 0; row < dimension; ++row) {
            output.append(formatter.format(matrix[dimension * row + row]));
            output.append(" ");
        }
        return output.toString();
    }

    public static double[] getScatterMatrix(double[][] observationMatrix) {
        int i;
        int observations = observationMatrix.length;
        int dimension = observationMatrix[0].length;
        double[] outputMatrix = new double[dimension * dimension];
        double[] means = new double[dimension];
        for (i = 0; i < observations; ++i) {
            for (int d = 0; d < dimension; ++d) {
                int n = d;
                means[n] = means[n] + observationMatrix[i][d];
            }
        }
        int d = 0;
        while (d < dimension) {
            int n = d++;
            means[n] = means[n] / (double)observations;
        }
        for (i = 0; i < observations; ++i) {
            for (int d1 = 0; d1 < dimension; ++d1) {
                for (int d2 = 0; d2 < dimension; ++d2) {
                    int n = dimension * d1 + d2;
                    outputMatrix[n] = outputMatrix[n] + (observationMatrix[i][d1] - means[d1]) * (observationMatrix[i][d2] - means[d2]);
                }
            }
        }
        return outputMatrix;
    }

    public static void testCholesky() {
        int observations = 1000;
        double[] mean = new double[20];
        double[] precisionMatrix = new double[400];
        for (int i = 0; i < 20; ++i) {
            precisionMatrix[20 * i + i] = 1.0;
        }
        Randoms random = new Randoms();
        double[] scatterMatrix = MVNormal.getScatterMatrix(MVNormal.nextMVNormal(observations, mean, precisionMatrix, random));
        double[] priorPrecision = new double[20];
        Arrays.fill(priorPrecision, 1.0);
        MVNormal.nextWishartPosterior(scatterMatrix, observations, priorPrecision, 21, 20, random);
    }

    public static void main(String[] args) {
        int i;
        int dim = 100;
        double[] bandLower = MVNormal.bandMatrixRoot(dim, 3);
        System.out.println(MVNormal.doubleArrayToString(bandLower, dim));
        double[] bandMatrix = MVNormal.lowerTriangularCrossproduct(bandLower, dim);
        System.out.println(MVNormal.doubleArrayToString(bandMatrix, dim));
        long startTime = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            MVNormal.bandCholesky(bandMatrix, dim);
        }
        System.out.println(System.currentTimeMillis() - startTime);
        startTime = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            MVNormal.cholesky(bandMatrix, dim);
        }
        System.out.println(System.currentTimeMillis() - startTime);
    }
}

